
<?php
require_once "core/db-connect91.php";
$selected_staff_id = $_SESSION['selected_staff_id'] ?? 0;
?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">



<?php
// Assumes $conn and $website are already defined earlier in your application.
// -------------------------------------------------------------------------
// Defensive initializations (preserve your original logic; just make safe)
session_start();


// Check if required session values are set
if (
    empty($_SESSION['selected_staff_id']) ||
    empty($_SESSION['selected_month']) ||
    empty($_SESSION['selected_year']) ||
    empty($_SESSION['selected_batch'])
) {
    // Redirect user if any session variable is missing
    header("Location: staff-pay-salary.php"); // change to your target page
    exit();
}

// Safe assignments after check
$selected_staff_id = (int)($_SESSION['selected_staff_id'] ?? 0);
$staff_id          = (int)($_SESSION['selected_staff_id'] ?? 0);

$month = (int)($_SESSION['selected_month'] ?? 6);
$year  = (int)($_SESSION['selected_year']  ?? 2024);
$batch = $_SESSION['selected_batch']       ?? '';


// -------------------------------------------------------------------------
// 1) Fetch staff (preserves card/grid layout and classes)
$staff_stmt = $conn->prepare("SELECT * FROM staff WHERE staff_id = ?");
$staff_stmt->bind_param("i", $selected_staff_id);
$staff_stmt->execute();
$staff_result = $staff_stmt->get_result();
?>

<div class="grid grid-cols-1 gap-4 sm:grid-cols-2 sm:gap-5 lg:grid-cols-3 lg:gap-6 xl:grid-cols-4 mt-6">
<?php
if ($staff_result && $staff_result->num_rows > 0) {
    while ($row = $staff_result->fetch_assoc()) {
        // explicit image src fallback (preserve behavior)
        $imgSrc = $website . ($row['staff_image'] ?: 'default.png');
?>
    <div class="card">
        <div class="p-2 text-right"></div>
        <div class="flex grow flex-col items-center px-4 pb-5 sm:px-5">
            <div class="avatar size-20">
                <img class="rounded-full" src="<?= htmlspecialchars($imgSrc) ?>" alt="avatar"/>
            </div>
            <h3 class="pt-3 text-lg font-medium text-slate-700 dark:text-navy-100">
                <?= htmlspecialchars($row['staff_name'] . " " . $row['staff_surname']) ?>
            </h3>
            <p class="text-xs-plus"><?= ucfirst(htmlspecialchars($row['staff_role'])) ?></p>
            
            <div class="inline-space mt-3 flex grow flex-wrap justify-center items-start">
                <span class="tag rounded-full bg-success/10 text-success m-1">
                    Phone: <?= htmlspecialchars($row['staff_phonenumber']) ?>
                </span>
            </div>
            <div class="inline-space mt-3 flex grow flex-wrap justify-center items-start">
                <span class="tag rounded-full bg-success/10 text-success m-1">
                    Email: <?= htmlspecialchars($row['staff_email']) ?>
                </span>
            </div>

            <!-- Hidden Form -->
            <form action="set-staff-id.php" method="POST" id="staffForm<?= (int)$row['staff_id'] ?>" style="display:none;">
                <input type="hidden" name="staff_id" value="<?= (int)$row['staff_id'] ?>">
                <input type="hidden" name="target_page" id="targetPage<?= (int)$row['staff_id'] ?>" value="">
            </form>

            <!-- Buttons -->
            <div class="mt-6 grid w-full grid-cols-2 gap-2">                
                <button type="button" 
                    class="btn space-x-2 bg-primary px-0 font-medium text-white hover:bg-primary-focus"
                    onclick="
                        document.getElementById('targetPage<?= (int)$row['staff_id'] ?>').value='staff-salary-payment-history.php';
                        document.getElementById('staffForm<?= (int)$row['staff_id'] ?>').submit();
                    ">
                 Salary Payment History
                </button>           
                <button type="button" 
                    class="btn space-x-2 bg-slate-150 px-0 font-medium text-slate-800 hover:bg-slate-200"
                    onclick="
                        document.getElementById('targetPage<?= (int)$row['staff_id'] ?>').value='staff-view-staff-attendance-main.php';
                        document.getElementById('staffForm<?= (int)$row['staff_id'] ?>').submit();
                    ">
                  View  Attendance
                </button>
            </div>
        </div>
    </div>
<?php
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<p class='text-center col-span-3'>No staff found.</p>";
}
$staff_stmt->close();
?>
</div>

<?php
// -------------------------------------------------------------------------
// 2) Fetch salary components (use a separate prepared statement)
$components_sql = "SELECT * FROM staff_salary_components WHERE staff_id = ?";
$components_stmt = $conn->prepare($components_sql);
$components_stmt->bind_param("i", $selected_staff_id);
$components_stmt->execute();
$components_result = $components_stmt->get_result();
?>

<div class="mt-5">
  <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
    <table class="is-zebra w-full text-left">
      <thead>
        <tr>
          <th class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">#</th>
          <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 lg:px-5">Type</th>
          <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 lg:px-5">Name</th>
          <th class="whitespace-nowrap rounded-r-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Amount</th>
        </tr>
      </thead>
      <tbody>
        <?php
        $sr_no = 1;
        while ($row = $components_result->fetch_assoc()) {
            echo '<tr>';
            echo '<td class="whitespace-nowrap rounded-l-lg px-4 py-3 sm:px-5">' . $sr_no++ . '</td>';
            echo '<td class="whitespace-nowrap px-4 py-3 sm:px-5">' . htmlspecialchars($row['type']) . '</td>';
            echo '<td class="whitespace-nowrap px-4 py-3 sm:px-5">' . htmlspecialchars($row['name']) . '</td>';
            echo '<td class="whitespace-nowrap rounded-r-lg px-4 py-3 sm:px-5">' . number_format((float)$row['amount'], 2) . '</td>';
            echo '</tr>';
        }

        if ($components_result->num_rows == 0) {
            echo '<tr><td colspan="4" class="text-center px-4 py-3">No salary components found.</td></tr>';
        }
        ?>
      </tbody>
    </table>
  </div>
</div>

<?php
$components_stmt->close();
?>

<?php
// -------------------------------------------------------------------------
// 3) Salary & attendance calculations
// 3.1 Net salary (type = 'net_salary')
$net_sql = "SELECT amount FROM staff_salary_components WHERE staff_id = ? AND type = 'net_salary' LIMIT 1";
$net_stmt = $conn->prepare($net_sql);
$net_stmt->bind_param("i", $staff_id);
$net_stmt->execute();
$net_res = $net_stmt->get_result();
$net_salary = ($net_res && $net_res->num_rows > 0) ? (float)$net_res->fetch_assoc()['amount'] : 0.0;
$net_stmt->close();



// 3.2 Attendance counts
$att_sql = "
SELECT status, leave_type, COUNT(*) as count
FROM staff_attendance
WHERE staff_id = ? AND month = ? AND year = ?
GROUP BY status, leave_type
";
$att_stmt = $conn->prepare($att_sql);
$att_stmt->bind_param("iii", $staff_id, $month, $year);
$att_stmt->execute();
$att_res = $att_stmt->get_result();

$present = $absent = $half_day = $leave = $paid_leave = 0;
while ($r = $att_res->fetch_assoc()) {
    switch ($r['status']) {
        case 'present':
            $present += (int)$r['count'];
            break;
        case 'absent':
            $absent += (int)$r['count'];
            break;
        case 'half_day':
            $half_day += (int)$r['count'];
            break;
        case 'leave':
            $leave += (int)$r['count'];
            if (strtolower($r['leave_type']) === 'paid') {
                $paid_leave += (int)$r['count'];
            }
            break;
    }
}
$att_stmt->close();


if (!empty($switchstatus['calculate_salary_by_attendance_auto']) && $switchstatus['calculate_salary_by_attendance_auto'] == 1) {
// 3.3 Total days & daily salary
$total_days = $present + $absent + $half_day + $leave;
$daily_salary = ($total_days > 0) ? ($net_salary / $total_days) : 0.0;

// 3.4 Payable total (present + half_day/2 + paid_leave)
$payable_total = ($present * $daily_salary) + ($half_day * $daily_salary * 0.5) + ($paid_leave * $daily_salary);
}else{
$payable_total = $net_salary;
}

// 3.5 Deductions (sum where type='deduction')
$deduction_sql = "SELECT COALESCE(SUM(amount),0) as total_deduction FROM staff_salary_components WHERE staff_id = ? AND type = 'deduction'";
$ded_stmt = $conn->prepare($deduction_sql);
$ded_stmt->bind_param("i", $staff_id);
$ded_stmt->execute();
$ded_res = $ded_stmt->get_result();
$total_deduction = ($ded_res && $ded_res->num_rows > 0) ? (float)$ded_res->fetch_assoc()['total_deduction'] : 0.0;
$ded_stmt->close();

// 3.6 Net payable after deductions
$net_payable = max(0.0, $payable_total);

// 3.7 Sum of payments already made for the same month/year/batch
$payment_sum_sql = "SELECT COALESCE(SUM(payment_amount), 0) AS total_payment
        FROM staff_salary_payment_history
        WHERE staff_id = ? AND salary_month = ? AND salary_year = ? AND batch = ?";
$payment_sum_stmt = $conn->prepare($payment_sum_sql);
$payment_sum_stmt->bind_param("iiis", $staff_id, $month, $year, $batch);
$payment_sum_stmt->execute();
$payment_sum_res = $payment_sum_stmt->get_result();
$total_payment = 0.0;
if ($payment_sum_res && $row = $payment_sum_res->fetch_assoc()) {
    $total_payment = (float)$row['total_payment'];
}
$payment_sum_stmt->close();

// 3.8 Final net payable considering payments done (keeps your original variable)
$final_net_payable = $net_payable - $total_payment;
?>

<div class="card mt-4">
    <div class="p-2 text-lg font-bold">Salary & Attendance Summary</div>
    <div class="px-4 pb-5 sm:px-1 w-full">
        <table class="table-auto w-full border border-slate-300 text-lg font-bold">
            <tbody>
                <tr class="border-b border-slate-300">
                    <td class="px-3 py-2">Net Salary (₹)</td>
                    <td class="px-3 py-2 text-right"><?= number_format($net_salary,2) ?></td>
                </tr>


                <tr class="border-b border-slate-300">
                    <td class="px-3 py-2">Total Days</td>
                    <td class="px-3 py-2 text-right"><?= $total_days ?></td>
                </tr>
                <tr class="border-b border-slate-300">
                    <td class="px-3 py-2">Present Days</td>
                    <td class="px-3 py-2 text-right"><?= $present ?></td>
                </tr>
                <tr class="border-b border-slate-300">
                    <td class="px-3 py-2">Absent Days</td>
                    <td class="px-3 py-2 text-right"><?= $absent ?></td>
                </tr>
                <tr class="border-b border-slate-300">
                    <td class="px-3 py-2">Half Days</td>
                    <td class="px-3 py-2 text-right"><?= $half_day ?></td>
                </tr>
                <tr class="border-b border-slate-300">
                    <td class="px-3 py-2">Leave Days</td>
                    <td class="px-3 py-2 text-right"><?= $leave ?></td>
                </tr>
                <tr class="border-b border-slate-300">
                    <td class="px-3 py-2">Paid Leave Days</td>
                    <td class="px-3 py-2 text-right"><?= $paid_leave ?></td>
                </tr>
<tr class="border-b border-slate-300">
    <td class="px-3 py-2">Attendance Deductions (₹)</td>
    <td class="px-3 py-2 text-right"><?= number_format($net_salary - $payable_total,2) ?></td>
</tr>


                <tr class="border-b border-slate-300">
                    <td class="px-3 py-2">Net Payable (₹)</td>
                    <td class="px-3 py-2 text-right"><?= number_format($net_payable,2) ?></td>
                </tr>
                <tr class="border-b border-slate-300">
	                <td class="px-3 py-2">Payment Done (₹)</td>
	                <td class="px-3 py-2 text-right"><?= number_format($total_payment,2) ?></td>
                </tr>
				<tr class="border-b border-slate-300">
				    <td class="px-3 py-2">Amount To Pay (₹)</td>
				    <td class="px-3 py-2 text-right"><?= number_format($final_net_payable,2) ?></td>
				</tr>
            </tbody>
        </table>
    </div>
</div>

<?php
// -------------------------------------------------------------------------
// 4) Staff bank details
$bank_sql = "SELECT b.*, s.staff_name, s.staff_role 
        FROM staff_bank_details b
        JOIN staff s ON b.staff_id = s.staff_id
        WHERE b.staff_id = ?
        ORDER BY b.id ASC";
$bank_stmt = $conn->prepare($bank_sql);
$bank_stmt->bind_param("i", $selected_staff_id);
$bank_stmt->execute();
$bank_result = $bank_stmt->get_result();
?>

<div class="mt-5">
    <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
        <table class="is-zebra w-full text-left">
            <thead>
                <tr>
                    <th class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">#</th>
                    <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 lg:px-5">Name</th>
                    <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 lg:px-5">Role</th>
                    <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 lg:px-5">Bank</th>
                    <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 lg:px-5">Account Number</th>
                    <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 lg:px-5">IFSC</th>
                    <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 lg:px-5">UPI ID</th>
                    <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 lg:px-5">Payment Number</th>
                    <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 lg:px-5">PAN</th>
                    <th class="whitespace-nowrap rounded-r-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Aadhaar</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $count = 1;
                if ($bank_result->num_rows > 0) {
                    while ($row = $bank_result->fetch_assoc()) {
                        echo '<tr>';
                        echo '<td class="whitespace-nowrap rounded-l-lg px-4 py-3 sm:px-5">' . $count++ . '</td>';
                        echo '<td class="whitespace-nowrap px-4 py-3 sm:px-5" style="cursor:pointer;color:blue;" title="Click to copy" onclick="copyCell(this)">' . htmlspecialchars($row['staff_name']) . '</td>';
                        echo '<td class="whitespace-nowrap px-4 py-3 sm:px-5" style="cursor:pointer;color:blue;" title="Click to copy" onclick="copyCell(this)">' . htmlspecialchars($row['staff_role']) . '</td>';
                        echo '<td class="whitespace-nowrap px-4 py-3 sm:px-5" style="cursor:pointer;color:blue;" title="Click to copy" onclick="copyCell(this)">' . htmlspecialchars($row['bank_name']) . '</td>';
                        echo '<td class="whitespace-nowrap px-4 py-3 sm:px-5" style="cursor:pointer;color:blue;" title="Click to copy" onclick="copyCell(this)">' . htmlspecialchars($row['account_number']) . '</td>';
                        echo '<td class="whitespace-nowrap px-4 py-3 sm:px-5" style="cursor:pointer;color:blue;" title="Click to copy" onclick="copyCell(this)">' . htmlspecialchars($row['ifsc_code']) . '</td>';
                        echo '<td class="whitespace-nowrap px-4 py-3 sm:px-5" style="cursor:pointer;color:blue;" title="Click to copy" onclick="copyCell(this)">' . htmlspecialchars($row['upi_id']) . '</td>';
                        echo '<td class="whitespace-nowrap px-4 py-3 sm:px-5" style="cursor:pointer;color:blue;" title="Click to copy" onclick="copyCell(this)">' . htmlspecialchars($row['payment_number']) . '</td>';
                        echo '<td class="whitespace-nowrap px-4 py-3 sm:px-5" style="cursor:pointer;color:blue;" title="Click to copy" onclick="copyCell(this)">' . htmlspecialchars($row['pan_number']) . '</td>';
                        echo '<td class="whitespace-nowrap rounded-r-lg px-4 py-3 sm:px-5" style="cursor:pointer;color:blue;" title="Click to copy" onclick="copyCell(this)">' . htmlspecialchars($row['aadhaar_number']) . '</td>';
                        echo '</tr>';
                    }
                } else {
                    echo '<tr><td colspan="10" class="text-center px-4 py-3">No staff bank details found</td></tr>';
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<?php
$bank_stmt->close();
?>

<script>
function copyCell(cell) {
    let text = cell.textContent.trim();
    navigator.clipboard.writeText(text).then(() => {
        alert("Copied: " + text);
    }).catch(err => {
        alert("Failed to copy!");
        console.error(err);
    });
}
</script>

<?php
// -------------------------------------------------------------------------
// 5) Payment History table (preserve your SELECT fields & ordering)
$history_sql = "SELECT 
            p.id,
            CONCAT(s.staff_name, ' ', s.staff_surname) AS staff_name,
            s.staff_role,
            p.total_amount,
            p.deductions,
            p.net_payable,
            p.payment_amount,
            p.due_amount,            
            p.payment_status,
            p.payment_date,
            p.payment_method,
            p.payment_reference,
            p.remarks,
            p.present_days,
            p.absent_days,
            p.half_days,
            p.paid_leaves
        FROM staff_salary_payment_history p
        INNER JOIN staff s ON s.staff_id = p.staff_id
        WHERE p.staff_id = ?
          AND p.salary_month = ?
          AND p.salary_year = ?
          AND p.batch = ?
        ORDER BY p.payment_date DESC";
$history_stmt = $conn->prepare($history_sql);
$history_stmt->bind_param("iiis", $staff_id, $month, $year, $batch);
$history_stmt->execute();
$history_result = $history_stmt->get_result();
?>

<div class="mt-5">
  <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
    <table class="is-zebra w-full text-left">
      <thead>
        <tr>
          <th class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">#</th>
          <th class="whitespace-nowrap  bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Name</th>
          <th class="whitespace-nowrap  bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Role</th>
          <th class="whitespace-nowrap  bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Total Salary</th>
          <th class="whitespace-nowrap  bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Deductions</th>
          <th class="whitespace-nowrap  bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Net Payable</th>
          <th class="whitespace-nowrap  bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Paid</th>
          <th class="whitespace-nowrap  bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Due</th>        
          <th class="whitespace-nowrap  bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Status</th>
          <th class="whitespace-nowrap  bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Payment Date</th>
          <th class="whitespace-nowrap  bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Method</th>
          <th class="whitespace-nowrap  bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Reference</th>
          <th class="whitespace-nowrap  bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Present</th>
          <th class="whitespace-nowrap  bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Absent</th>
          <th class="whitespace-nowrap  bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Half Days</th>
          <th class="whitespace-nowrap  bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Paid Leaves</th>
          <th class="whitespace-nowrap rounded-r-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">Remarks</th>
        </tr>
      </thead>
      <tbody>
        <?php
        if ($history_result->num_rows > 0) {
            $i = 1;
            $total_paid = 0;
            while ($row = $history_result->fetch_assoc()) {
                $total_paid += (float)$row['payment_amount'];
                echo "<tr>
                        <td class='whitespace-nowrap rounded-l-lg px-4 py-3 sm:px-5'>{$i}</td>
                        <td class='whitespace-nowrap  px-4 py-3 sm:px-5'>".htmlspecialchars($row['staff_name'])."</td>
                        <td class='whitespace-nowrap  px-4 py-3 sm:px-5'>".htmlspecialchars($row['staff_role'])."</td>
                        <td class='whitespace-nowrap  px-4 py-3 sm:px-5'>₹".htmlspecialchars($row['total_amount'])."</td>
                        <td class='whitespace-nowrap  px-4 py-3 sm:px-5'>₹".htmlspecialchars($row['deductions'])."</td>
                        <td class='whitespace-nowrap  px-4 py-3 sm:px-5'>₹".htmlspecialchars($row['net_payable'])."</td>
                        <td class='whitespace-nowrap  px-4 py-3 sm:px-5'>₹".htmlspecialchars($row['payment_amount'])."</td>
                        <td class='whitespace-nowrap  px-4 py-3 sm:px-5'>₹".htmlspecialchars($row['due_amount'])."</td>                      
                        <td class='whitespace-nowrap  px-4 py-3 sm:px-5'>".htmlspecialchars($row['payment_status'])."</td>
                        <td class='whitespace-nowrap  px-4 py-3 sm:px-5'>".htmlspecialchars($row['payment_date'])."</td>
                        <td class='whitespace-nowrap  px-4 py-3 sm:px-5'>".htmlspecialchars($row['payment_method'])."</td>
                        <td class='whitespace-nowrap  px-4 py-3 sm:px-5'>".htmlspecialchars($row['payment_reference'])."</td>
                        <td class='whitespace-nowrap  px-4 py-3 sm:px-5'>".htmlspecialchars($row['present_days'])."</td>
                        <td class='whitespace-nowrap  px-4 py-3 sm:px-5'>".htmlspecialchars($row['absent_days'])."</td>
                        <td class='whitespace-nowrap  px-4 py-3 sm:px-5'>".htmlspecialchars($row['half_days'])."</td>
                        <td class='whitespace-nowrap  px-4 py-3 sm:px-5'>".htmlspecialchars($row['paid_leaves'])."</td>
                        <td class='whitespace-nowrap rounded-r-lg px-4 py-3 sm:px-5'>".htmlspecialchars($row['remarks'])."</td>
                      </tr>";
                $i++;
            }
            echo "<tr class='bg-slate-100 font-semibold'>
                    <td colspan='6' class='text-right'>Total Paid:</td>
                    <td class='text-green-600'>₹".number_format($total_paid,2)."</td>
                    <td colspan='9'></td>
                  </tr>";
        } else {
            echo "<tr><td colspan='16' class='text-center'>No payment history found</td></tr>";
        }
        ?>
      </tbody>
    </table>
  </div>
</div>

<?php
$history_stmt->close();
?>

<!-- Payment form -->
<form method="POST">
<div class="card mt-4">
<div class="p-2 text-right"></div>
<div class="flex grow flex-col items-center px-4 pb-5 sm:px-1 w-full">
<label class="relative flex">
    <span class="font-bold text-lg">Amount To Pay (₹)</span>   
    <input 
        name="payable_amount"
        class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 
               placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary 
               dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent 
               font-bold text-lg"
        type="text"
        value="<?php echo number_format($final_net_payable, 2, '.', '') ?>"
    />
</label>
</div>
</div>

<!-- Payment Method -->
<div class="card mt-4">
    <div class="p-2 text-right"></div>
    <div class="flex grow flex-col items-center px-4 pb-5 sm:px-1 w-full">
        <label class="block w-full">
            <span>Payment Method</span>
            <select id="paymentMethod" name="payment_method" required
                class="mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2
                       hover:border-slate-400 focus:border-primary
                       dark:border-navy-450 dark:bg-navy-700
                       dark:hover:border-navy-400 dark:focus:border-accent">
                <option value="">Select Payment Method</option>
                <option value="cash">Cash</option>
                <option value="cheque">Cheque</option>
                <option value="upi">UPI</option>
                <option value="imps">IMPS</option>
                <option value="neft">NEFT</option>
                <option value="rtgs">RTGS</option>
                <option value="demand_draft">Demand Draft</option>
                <option value="others">Others</option>
            </select>
        </label>
    </div>
</div>

<div id="paymentDetailsContainer" class="card mt-4 hidden">
    <div class="p-4 space-y-4" id="paymentDetails"></div>
</div><!-- Dynamic Payment Details -->

<script>
const methodSelect = document.getElementById("paymentMethod");
const detailsContainer = document.getElementById("paymentDetailsContainer");
const detailsBox = document.getElementById("paymentDetails");

methodSelect.addEventListener("change", function() {
    const method = this.value;
    detailsBox.innerHTML = ""; 
    detailsContainer.classList.add("hidden");
    if (!method) return;

    let fields = "";

    switch (method) {

        case "cheque":
            fields = `
                <h3 class="font-bold">Cheque Payment Details</h3>
                <label class="block">
                    <span>Cheque Number</span>
                    <input type="text" name="cheque_number" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
                <label class="block">
                    <span>Bank Name</span>
                    <input type="text" name="bank_name" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
                <label class="block">
                    <span>IFSC Code</span>
                    <input type="text" name="ifsc_code" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
            `;
            break;

        case "upi":
            fields = `
                <h3 class="font-bold">UPI Payment Details</h3>
                <label class="block">
                    <span>UPI ID</span>
                    <input type="text" name="upi_id" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
                <label class="block">
                    <span>Transaction ID</span>
                    <input type="text" name="transaction_id" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
            `;
            break;

        case "imps":
        case "neft":
        case "rtgs":
            fields = `
                <h3 class="font-bold">${method.toUpperCase()} Payment Details</h3>
                <label class="block">
                    <span>Bank Name</span>
                    <input type="text" name="bank_name" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
                <label class="block">
                    <span>IFSC Code</span>
                    <input type="text" name="ifsc_code" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
                <label class="block">
                    <span>Transaction ID</span>
                    <input type="text" name="transaction_id" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
            `;
            break;

        case "demand_draft":
            fields = `
                <h3 class="font-bold">Demand Draft Payment Details</h3>
                <label class="block">
                    <span>DD Number</span>
                    <input type="text" name="dd_number" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
                <label class="block">
                    <span>Bank Name</span>
                    <input type="text" name="bank_name" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
            `;
            break;

        case "others":
            fields = `
                <h3 class="font-bold">Other Payment Method</h3>
                <label class="block">
                    <span>Description</span>
                    <input type="text" name="other_description" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
            `;
            break;
    }

    detailsBox.innerHTML = fields;
    detailsContainer.classList.remove("hidden");
});

// Live cash calculation
detailsBox.addEventListener("input", function(e) {
    if (methodSelect.value === "cash") {
        let total = 0;
        document.querySelectorAll(".note-count").forEach(input => {
            let count = parseInt(input.value) || 0;
            let value = parseInt(input.dataset.noteValue) || 0;
            if (isNaN(value) && input.dataset.noteValue === "Other") {
                total += count; // Other amount directly
            } else {
                total += count * value;
            }
        });
        document.getElementById("cashTotal").textContent = total;
    }
});
</script>

<div class="mt-6 grid w-full grid-cols-1 gap-2">                
    <button type="submit" 
        class="btn space-x-2 bg-primary px-0 font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
      >
Submit
    </button>
</div>
</form>

<?php
// -------------------------------------------------------------------------
// 6) Handle POST (insert/update) - keep your insert/update behavior and fields
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
// Escape / cast inputs
$staff_id       = (int)$_SESSION['selected_staff_id'];
$batch          = mysqli_real_escape_string($conn, $_POST['batch'] ?? $batch);
$salary_month   = (int)$month;
$salary_year    = (int)$year;
$total_amount   = (float)$payable_total;
$deductions     = (float)$total_deduction;
$net_payable    = (float)$net_payable;
$payment_amount = (float)($_POST['payable_amount'] ?? 0.0);
// Define due_amount
$due_amount = max(0.0, $net_payable - $payment_amount - $total_payment);

$payment_amount    = round((float)$payment_amount, 2);
$final_net_payable = round((float)$final_net_payable, 2);
// validation

$errors = [];

// Payment amount can't be negative
if ($payment_amount <= 0) {
    $errors[] = "Payment amount cannot be negative OR 0.";
}


if ($payment_amount > $final_net_payable) {
    $errors[] = "Payment amount cannot exceed net payable.";
}

// Calculate due amount
$due_amount = $net_payable - $payment_amount;

// Due amount can't be negative (should already be handled above, but double-check)
if ($due_amount < 0) {
    $errors[] = "Due amount cannot be negative.";
}

// If there are validation errors, stop here
if (!empty($errors)) {
$message = "Error: " . implode(", ", $errors);
$messageType = "error";


}else{

// Set payment status based on due amount
if ($due_amount == 0) {
$payment_status = "paid";
} elseif ($due_amount > 0 && $due_amount < $net_payable) {
$payment_status = "partial";
} else {
$payment_status = "unpaid";
}
$payment_date   = date("Y-m-d H:i:s");
$payment_method = mysqli_real_escape_string($conn, $_POST['payment_method'] ?? '');
$payment_reference = mysqli_real_escape_string($conn, $_POST['paymentReference'] ?? '');
$remarks        = mysqli_real_escape_string($conn, $_POST['remarks'] ?? '');

$present_days   = (int)$present;
$absent_days    = (int)$absent;
$half_days      = (int)$half_day;
$paid_leaves    = (int)$paid_leave;

$created_by     = (int)($_SESSION['staff_id'] ?? 0);
$updated_by     = 0;



$sql = "
INSERT INTO staff_salary_payment_history (
    staff_id, batch, salary_month, salary_year, total_amount, deductions, net_payable, 
    payment_amount, due_amount, payment_status, payment_date, payment_method, payment_reference, remarks, 
    present_days, absent_days, half_days, paid_leaves, created_by, created_at
) VALUES (
    $staff_id, '$batch', $salary_month, $salary_year, $total_amount, $deductions, $net_payable, 
    $payment_amount, $due_amount, '$payment_status', '$payment_date', '$payment_method', '$payment_reference', '$remarks', 
    $present_days, $absent_days, $half_days, $paid_leaves, $created_by, NOW()
)
";

if ($conn->query($sql) === TRUE) {


echo "<div style='color:green;'>Record inserted successfully.</div>";

// --- Fetch total paid so far from payment history ---
$sql = "SELECT COALESCE(SUM(payment_amount), 0) AS total_paid
        FROM staff_salary_payment_history
        WHERE staff_id = ?
          AND salary_month = ?
          AND salary_year = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("iss", $staff_id, $salary_month, $salary_year);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();

$previous_payments = (float)$row['total_paid'];

// Add the current payment to the total
$total_paid_now = $previous_payments;

// Salary to pay — must be defined or fetched from somewhere
$salary_to_pay = (float)($net_payable ?? 0.00);

// Calculate remaining amount
$due_amount = max(0, $salary_to_pay - $total_paid_now);

// Determine payment status
if ($due_amount == 0 && $total_paid_now > 0) {
    $payment_status = "paid";
} elseif ($total_paid_now > 0 && $due_amount > 0) {
    $payment_status = "partially_paid";
} else {
    $payment_status = "unpaid";
}

// Other fields
$payment_type         = $payment_method; // matches ENUM
$transaction_id       = $payment_reference;
$payment_id           = ''; // Optional
$payment_date2        = date("Y-m-d");
$payment_receiver_id  = $created_by;
$remarks2             = $remarks;

// --- Check if salary record exists ---
$check_sql = "SELECT salary_payment_id FROM staff_salary_payments 
              WHERE staff_id = $staff_id 
                AND month = $salary_month 
                AND year = $salary_year 
                AND batch = '$batch'
              LIMIT 1";
$check_result = $conn->query($check_sql);

if ($check_result && $check_result->num_rows > 0) {
    // Update existing record
    $row = $check_result->fetch_assoc();
    $salary_payment_id = (int)$row['salary_payment_id'];

    $update_sql = "
        UPDATE staff_salary_payments SET
            salary_to_pay = $salary_to_pay,
            payment_status = '$payment_status',
            paid_amount = $total_paid_now,
            payment_type = '$payment_type',
            transaction_id = '$transaction_id',
            payment_id = '$payment_id',
            payment_date = '$payment_date2',
            payment_receiver_id = $payment_receiver_id,
            remarks = '$remarks2'
        WHERE salary_payment_id = $salary_payment_id
    ";

    if ($conn->query($update_sql) === TRUE) {

$message = 'Payment Added Successfully';
$messageType = 'success';
    } else {
$message = "Error: Something Went Wrong...";
$messageType = "error";
    }

} else {
    // Insert new record
    $sql2 = "
        INSERT INTO staff_salary_payments (
            staff_id, month, year, batch, salary_to_pay,
            payment_status, paid_amount, payment_type, transaction_id, payment_id,
            payment_date, payment_receiver_id, remarks
        ) VALUES (
            $staff_id, $salary_month, $salary_year, '$batch', $salary_to_pay,
            '$payment_status', $total_paid_now, '$payment_type', '$transaction_id', '$payment_id',
            '$payment_date2', $payment_receiver_id, '$remarks2'
        )
    ";

    if ($conn->query($sql2) === TRUE) {
        
        $message = 'Payment Added Successfully';
        $messageType = 'success';
        

    } else {
$message = "Error: Something Went Wrong...";
$messageType = "error";
    }
}



if ($payment_amount > $final_net_payable) {
    $errors[] = "Payment amount cannot exceed net payable.";
}

} else {
$message = "Error: Something Went Wrong...";
$messageType = "error";
}
}

}
?>

  </div>
</div>
      </main>
    </div>
    
    
<!-- Alpine Modal -->
<div x-data="{ 
        showModal: <?= $message ? 'true' : 'false' ?>, 
        message: '<?= addslashes($message) ?>', 
        type: '<?= $messageType ?>' 
     }">
  <!-- Modal content same as before (success/error with colors) -->
  <template x-teleport="#x-teleport-target">
    <div class="fixed inset-0 z-[100] flex items-center justify-center px-4 py-6 sm:px-5"
         x-show="showModal"
         role="dialog"
         @keydown.window.escape="showModal = false">

      <!-- Overlay -->
      <div class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
           @click="showModal = false"
           x-show="showModal"
           x-transition:enter="ease-out"
           x-transition:enter-start="opacity-0"
           x-transition:enter-end="opacity-100"
           x-transition:leave="ease-in"
           x-transition:leave-start="opacity-100"
           x-transition:leave-end="opacity-0"></div>

      <!-- Modal Content -->
      <div class="scrollbar-sm relative flex max-w-lg flex-col overflow-y-auto rounded-lg px-4 py-10 text-center transition-opacity duration-300 sm:px-5"
           x-show="showModal"
           x-transition:enter="ease-out"
           x-transition:enter-start="opacity-0"
           x-transition:enter-end="opacity-100"
           x-transition:leave="ease-in"
           x-transition:leave-start="opacity-100"
           x-transition:leave-end="opacity-0"
           :class="type === 'success' ? 'bg-white dark:bg-navy-700' : 'bg-white border border-red-500 dark:bg-navy-700'">

        <!-- Icon based on type -->
        <svg x-show="type === 'success'" xmlns="http://www.w3.org/2000/svg"
             class="mx-auto inline size-28 shrink-0 text-success"
             fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>

        <svg x-show="type === 'error'" xmlns="http://www.w3.org/2000/svg"
             class="mx-auto inline size-28 shrink-0 text-red-600"
             fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M6 18L18 6M6 6l12 12"/>
        </svg>

        <div class="mt-4">
          <h2 class="text-2xl font-bold"
              :class="type === 'success' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'">
            <span x-text="type === 'success' ? 'Success!' : 'Error!'"></span>
          </h2>
          <p class="mt-2 text-slate-600 dark:text-slate-200" x-text="message"></p>

          <button @click="showModal = false"
                  class="btn mt-6 font-medium text-white"
                  :class="type === 'success' ? 'bg-success hover:bg-success-focus' : 'bg-red-600 hover:bg-red-700'">
            Close
          </button>
        </div>
      </div>
    </div>
  </template>
</div>
    
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>