
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

  
  

<?php
if (!isset($_SESSION['staff_id'])) {
    die("Error: Staff not logged in.");
}

$staff_id = $_SESSION['staff_id'];

// Fetch all attendance records for this staff & batch
$sql = "SELECT * FROM staff_attendance 
        WHERE staff_id = '$staff_id' 
        AND batch = '$batch'
     ORDER BY year ASC, month ASC, day ASC";

$result = mysqli_query($conn, $sql);

if (!$result || mysqli_num_rows($result) == 0) {
    echo '<div class="text-center text-red-500 font-medium mt-5">No staff attendance record found.</div>';
}

// Group records by month-year
$attendanceData = [];
while ($row = mysqli_fetch_assoc($result)) {
    $monthYear = date("F Y", mktime(0, 0, 0, $row['month'], 1, $row['year']));
    $attendanceData[$monthYear][] = $row;
}
?>

<div class="col-span-12 grid lg:grid-cols-1 gap-6 mx-auto max-w-7xl">


<?php foreach ($attendanceData as $monthYear => $records): ?>
  <div class="card shadow-md">
    <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
      <div class="flex items-center space-x-2">
        <div class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary dark:bg-accent-light/10 dark:text-accent-light">
          <i class="fa-solid fa-calendar-days"></i>
        </div>
        <h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">
          <?= $monthYear ?>
        </h4>
      </div>
    </div>

    <div class="space-y-4 p-4 sm:p-5 text-center">
      <div class="flex flex-wrap gap-2 justify-center">
        <?php foreach ($records as $row): 
          $day = $row['day'];
          $status = strtolower($row['status']); 
          $btnClass = "bg-slate-400 text-white";

          if ($status == 'present') $btnClass = "bg-success hover:bg-success-focus";
          if ($status == 'absent') $btnClass = "bg-error hover:bg-error-focus";
          if ($status == 'half_day') $btnClass = "bg-warning hover:bg-warning-focus";
          if ($status == 'leave') $btnClass = "bg-info hover:bg-info-focus";
        ?>

          <button 
            class="btn size-9 <?= $btnClass ?> p-0 font-medium text-white hover:shadow-lg hover:shadow-black/30 focus:shadow-lg focus:shadow-black/30 active:opacity-90"
            title="Status: <?= ucfirst($status) ?><?= $row['remarks'] ? ' | '.$row['remarks'] : '' ?>"     
            x-data
            @click="$dispatch('open-modal', {id: <?= $row['attendance_id'] ?>, status: '<?= $row['status'] ?>'})"
          >
          <?= $day ?>
          </button>
        <?php endforeach; ?>
      </div>

      <div class="mt-4 text-xs text-slate-600 dark:text-navy-200">
        <span class="inline-block size-3 rounded-full bg-success mr-1"></span> Present
        <span class="inline-block size-3 rounded-full bg-error ml-3 mr-1"></span> Absent
        <span class="inline-block size-3 rounded-full bg-warning ml-3 mr-1"></span> Half Day
        <span class="inline-block size-3 rounded-full bg-info ml-3 mr-1"></span> Leave
      </div>
    </div>
  </div>
<?php endforeach; ?>
</div>


  
  
  
  
  

  
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>