
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

  
  


<?php
$staff_id = $_SESSION['selected_staff_id']; // session variable for the selected staff

// Fetch staff data
$sql = "SELECT * FROM staff WHERE staff_id = '$staff_id' LIMIT 1";
$result = mysqli_query($conn, $sql);

if (!$result || mysqli_num_rows($result) == 0) {
    die("Error: Staff data not found.");
}

$staff = mysqli_fetch_assoc($result);
?>

<form method="POST" enctype="multipart/form-data" class="col-span-12 grid lg:col-span-8 mx-auto max-w-3xl">
  <input type="hidden" name="staff_id" value="<?= htmlspecialchars($staff['staff_id']) ?>">

  <div class="card">
    <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
      <div class="flex items-center space-x-2">
        <div class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary dark:bg-accent-light/10 dark:text-accent-light">
          <i class="fa-solid fa-user-tie"></i>
        </div>
        <h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">
          Edit Staff Profile
        </h4>
      </div>
    </div>

    <div class="space-y-4 p-4 sm:p-5">

      <!-- Image -->
      <div class="flex justify-center pt-4">
        <img src="<?= $website . htmlspecialchars($staff['staff_image']) ?>" 
             alt="Staff Image" 
             class="h-32 w-32 rounded-lg border border-slate-300 object-cover">
      </div>
      <label class="block">
        <span>Change Image</span>
        <input type="file" name="staff_image"  class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <!-- Editable Fields -->
      <label class="block">
        <span>Username</span>
        <input type="text" name="staff_username" value="<?= htmlspecialchars($staff['staff_username']) ?>"  class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Password</span>
        <input type="text" name="staff_password" value="<?= htmlspecialchars($staff['staff_password']) ?>"  class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Surname</span>
        <input type="text" name="staff_surname" value="<?= htmlspecialchars($staff['staff_surname']) ?>"  class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Name</span>
        <input type="text" name="staff_name" value="<?= htmlspecialchars($staff['staff_name']) ?>"  class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Father Name</span>
        <input type="text" name="staff_fathername" value="<?= htmlspecialchars($staff['staff_fathername']) ?>"  class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <div class="grid grid-cols-2 gap-4">
<label class="block">
  <span>Gender</span>
  <select
    name="staff_gender"
    class="mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"
    x-init="$el._x_tom = new Tom($el, { create: true, sortField: { field: 'text', direction: 'asc' } })"
  >
    <option value="Male" <?= ($staff['staff_gender'] === 'Male') ? 'selected' : '' ?>>Male</option>
    <option value="Female" <?= ($staff['staff_gender'] === 'Female') ? 'selected' : '' ?>>Female</option>
    <option value="Other" <?= ($staff['staff_gender'] === 'Other') ? 'selected' : '' ?>>Other</option>
  </select>
</label>

<label class="block">
  <span>Caste</span>
  <select
    name="staff_caste"
    class="mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"
    x-init="$el._x_tom = new Tom($el, { create: true, sortField: { field: 'text', direction: 'asc' } })"
  >
    <option value="General" <?= ($staff['staff_caste'] === 'General') ? 'selected' : '' ?>>General</option>
    <option value="OBC" <?= ($staff['staff_caste'] === 'OBC') ? 'selected' : '' ?>>OBC</option>
    <option value="SC" <?= ($staff['staff_caste'] === 'SC') ? 'selected' : '' ?>>SC</option>
    <option value="ST" <?= ($staff['staff_caste'] === 'ST') ? 'selected' : '' ?>>ST</option>
    <option value="Other" <?= ($staff['staff_caste'] === 'Other') ? 'selected' : '' ?>>Other</option>
  </select>
</label>
      </div>

      <div class="grid grid-cols-2 gap-4">
        <label class="block">
          <span>Subcaste</span>
          <input type="text" name="staff_subcaste" value="<?= htmlspecialchars($staff['staff_subcaste']) ?>"  class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
        </label>

<label class="block">
  <span>Minority</span>
  <select
    name="staff_minority"
    class="mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"
    x-init="$el._x_tom = new Tom($el, { create: true, sortField: { field: 'text', direction: 'asc' } })"
  >
    <option value="Yes" <?= ($staff['staff_minority'] === 'Yes') ? 'selected' : '' ?>>Yes</option>
    <option value="No" <?= ($staff['staff_minority'] === 'No') ? 'selected' : '' ?>>No</option>
    <option value="Other" <?= ($staff['staff_minority'] === 'Other') ? 'selected' : '' ?>>Other</option>
  </select>
</label>
      </div>

      <label class="block">
        <span>Birthdate</span>
        <input type="date" name="staff_birthdate" value="<?= htmlspecialchars($staff['staff_birthdate']) ?>"  class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Phone Number</span>
        <input type="text" name="staff_phonenumber" value="<?= htmlspecialchars($staff['staff_phonenumber']) ?>"  class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Alternative Number</span>
        <input type="text" name="staff_alternativenumber" value="<?= htmlspecialchars($staff['staff_alternativenumber']) ?>"  class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Email</span>
        <input type="email" name="staff_email" value="<?= htmlspecialchars($staff['staff_email']) ?>"  class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Address</span>
        <input type="text" name="staff_address" value="<?= htmlspecialchars($staff['staff_address']) ?>"  class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Salary</span>
        <input type="text" name="staff_salary" value="<?= htmlspecialchars($staff['staff_salary']) ?>"  class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>
<label class="block">
  <span>Role</span>
  <select
    name="staff_role"
    class="mt-1.5 w-full border border-slate-300 rounded-lg bg-slate-100 px-3 py-2"
    x-init="$el._x_tom = new Tom($el, { create: true, sortField: { field: 'text', direction: 'asc' } })"
  >
    <option value="admin" <?= ($staff['staff_role'] === 'admin') ? 'selected' : '' ?>>Admin</option>
    <option value="driver" <?= ($staff['staff_role'] === 'driver') ? 'selected' : '' ?>>Driver</option>
    <option value="accountant" <?= ($staff['staff_role'] === 'accountant') ? 'selected' : '' ?>>Accountant</option>
    <option value="teacher" <?= ($staff['staff_role'] === 'teacher') ? 'selected' : '' ?>>Teacher</option>
    <option value="other" <?= ($staff['staff_role'] === 'other') ? 'selected' : '' ?>>Other</option>
  </select>
</label>

      <label class="block">
        <span>Details</span>
        <textarea name="staff_details"  class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"><?= htmlspecialchars($staff['staff_details']) ?></textarea>
      </label>

<label class="block">
  <span>Status</span>
  <select
    name="staff_status"
    class="mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"
    x-init="$el._x_tom = new Tom($el, { create: true, sortField: { field: 'text', direction: 'asc' } })"
  >
    <option value="Active" <?= ($staff['staff_status'] === 'Active') ? 'selected' : '' ?>>Active</option>
    <option value="Inactive" <?= ($staff['staff_status'] === 'Inactive') ? 'selected' : '' ?>>Inactive</option>
    <option value="Suspended" <?= ($staff['staff_status'] === 'Suspended') ? 'selected' : '' ?>>Suspended</option>
    <option value="Retired" <?= ($staff['staff_status'] === 'Retired') ? 'selected' : '' ?>>Retired</option>
  </select>
</label>

      <label class="block">
        <span>Registration Date</span>
        <input disabled type="date" name="staff_registrationdate" value="<?= htmlspecialchars($staff['staff_registrationdate']) ?>"  class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <!-- Submit -->
      <button type="submit" class="btn mt-4 bg-primary text-white px-4 py-2 rounded-lg">
        Update Staff
      </button>

    </div>
  </div>
</form>
 
  
  
<?php


if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $staff_id = intval($_POST['staff_id']);

    // Prepare data safely
    $staff_username       = mysqli_real_escape_string($conn, $_POST['staff_username']);
    $staff_password       = mysqli_real_escape_string($conn, $_POST['staff_password']);
    $staff_surname        = mysqli_real_escape_string($conn, $_POST['staff_surname']);
    $staff_name           = mysqli_real_escape_string($conn, $_POST['staff_name']);
    $staff_fathername     = mysqli_real_escape_string($conn, $_POST['staff_fathername']);
    $staff_gender         = mysqli_real_escape_string($conn, $_POST['staff_gender']);
    $staff_caste          = mysqli_real_escape_string($conn, $_POST['staff_caste']);
    $staff_subcaste       = mysqli_real_escape_string($conn, $_POST['staff_subcaste']);
    $staff_minority       = mysqli_real_escape_string($conn, $_POST['staff_minority']);
    $staff_birthdate      = mysqli_real_escape_string($conn, $_POST['staff_birthdate']);
    $staff_phonenumber    = mysqli_real_escape_string($conn, $_POST['staff_phonenumber']);
    $staff_alternativenumber = mysqli_real_escape_string($conn, $_POST['staff_alternativenumber']);
    $staff_email          = mysqli_real_escape_string($conn, $_POST['staff_email']);
    $staff_address        = mysqli_real_escape_string($conn, $_POST['staff_address']);
    $staff_salary         = floatval($_POST['staff_salary']);
    $staff_role           = mysqli_real_escape_string($conn, $_POST['staff_role']);
    $staff_details        = mysqli_real_escape_string($conn, $_POST['staff_details']);
    $staff_status         = mysqli_real_escape_string($conn, $_POST['staff_status']);
    $staff_registrationdate = mysqli_real_escape_string($conn, $_POST['staff_registrationdate']);

    // Handle image upload if new image is provided
    if (!empty($_FILES['staff_image']['name'])) {
        $target_dir = "../staffprofileimage/";
        $target_dir2 = "staffprofileimage/";      
        if (!is_dir($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        $target_file = $target_dir2 . basename($_FILES["staff_image"]["name"]);
        move_uploaded_file($_FILES["staff_image"]["tmp_name"], $target_file);
        $staff_image = $target_file;
    } else {
        // Keep old image if no new one is uploaded
        $result = mysqli_query($conn, "SELECT staff_image FROM staff WHERE staff_id = $staff_id");
        $row = mysqli_fetch_assoc($result);
        $staff_image = $row['staff_image'];
    }

    // Update staff record
    $sql = "UPDATE staff SET 
                staff_username = '$staff_username',
                staff_password = '$staff_password',
                staff_surname = '$staff_surname',
                staff_name = '$staff_name',
                staff_fathername = '$staff_fathername',
                staff_gender = '$staff_gender',
                staff_caste = '$staff_caste',
                staff_subcaste = '$staff_subcaste',
                staff_minority = '$staff_minority',
                staff_birthdate = '$staff_birthdate',
                staff_phonenumber = '$staff_phonenumber',
                staff_alternativenumber = '$staff_alternativenumber',
                staff_email = '$staff_email',
                staff_address = '$staff_address',
                staff_image = '$staff_image',
                staff_salary = '$staff_salary',
                staff_role = '$staff_role',
                staff_details = '$staff_details',
                staff_status = '$staff_status',
                staff_registrationdate = '$staff_registrationdate'
            WHERE staff_id = $staff_id";

if (mysqli_query($conn, $sql)) {
    $message = "Staff Edited successfully!";
    $messageType = "success";

} else {
    $message = "Error: " . mysqli_error($conn);
    $messageType = "error";
}
}
?>
  
  
  
  
  </div>
</div>
      </main>
    </div>
    
<div x-data="{ 
        showModal: <?= $message ? 'true' : 'false' ?>, 
        message: '<?= addslashes($message) ?>', 
        type: '<?= $messageType ?>' 
     }"
     x-init="
        $watch('showModal', value => {
          if (!value && type === 'success') {
            // Reset form and refresh GR
            document.getElementById('studentForm').reset();
            document.getElementById('grNumber').value = '<?= $nextGR ?>';
          }
        });
     ">
  <!-- Modal content same as before (success/error with colors) -->


  <template x-teleport="#x-teleport-target">
    <div class="fixed inset-0 z-[100] flex items-center justify-center px-4 py-6 sm:px-5"
         x-show="showModal"
         role="dialog"
         @keydown.window.escape="showModal = false">

      <!-- Overlay -->
      <div class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
           @click="showModal = false"
           x-show="showModal"
           x-transition:enter="ease-out"
           x-transition:enter-start="opacity-0"
           x-transition:enter-end="opacity-100"
           x-transition:leave="ease-in"
           x-transition:leave-start="opacity-100"
           x-transition:leave-end="opacity-0"></div>

      <!-- Modal Content -->
      <div class="scrollbar-sm relative flex max-w-lg flex-col overflow-y-auto rounded-lg px-4 py-10 text-center transition-opacity duration-300 sm:px-5"
           x-show="showModal"
           x-transition:enter="ease-out"
           x-transition:enter-start="opacity-0"
           x-transition:enter-end="opacity-100"
           x-transition:leave="ease-in"
           x-transition:leave-start="opacity-100"
           x-transition:leave-end="opacity-0"
           :class="type === 'success' ? 'bg-white dark:bg-navy-700' : 'bg-white border border-red-500 dark:bg-navy-700'">

        <!-- Icon based on type -->
        <svg x-show="type === 'success'" xmlns="http://www.w3.org/2000/svg"
             class="mx-auto inline size-28 shrink-0 text-success"
             fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>

        <svg x-show="type === 'error'" xmlns="http://www.w3.org/2000/svg"
             class="mx-auto inline size-28 shrink-0 text-red-600"
             fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M6 18L18 6M6 6l12 12"/>
        </svg>

        <div class="mt-4">
          <h2 class="text-2xl font-bold"
              :class="type === 'success' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'">
            <span x-text="type === 'success' ? 'Success!' : 'Error!'"></span>
          </h2>
          <p class="mt-2 text-slate-600 dark:text-slate-200" x-text="message"></p>

          <button @click="showModal = false"
                  class="btn mt-6 font-medium text-white"
                  :class="type === 'success' ? 'bg-success hover:bg-success-focus' : 'bg-red-600 hover:bg-red-700'">
            Close
          </button>
        </div>
      </div>
    </div>
  </template>
</div>
    
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>