
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">
<?php


if (!isset($_SESSION['exam_id'])) {
    die("Exam ID not set.");
}
$exam_id = $_SESSION['exam_id'];

// ✅ Update when form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['form_type'] === 'updateprimary') {
    $exam_name = mysqli_real_escape_string($conn, $_POST['exam_name']);
    $exam_start_date = mysqli_real_escape_string($conn, $_POST['exam_start_date']);
    $exam_end_date = mysqli_real_escape_string($conn, $_POST['exam_end_date']);
    $batch = mysqli_real_escape_string($conn, $_POST['batch']);
    $updated_at = date("Y-m-d H:i:s");

    $sql = "UPDATE exam_schedule 
            SET exam_name='$exam_name',
                start_date='$exam_start_date',
                end_date='$exam_end_date',
                batch='$batch',
                created_at='$updated_at'
            WHERE exam_id='$exam_id'";

    if (mysqli_query($conn, $sql)) {
        echo "<script>alert('Exam Schedule Updated Successfully');</script>";
    } else {
        echo "Error: " . mysqli_error($conn);
    }
}

// ✅ Fetch exam details again (latest data after update)
$sql = "SELECT * FROM exam_schedule WHERE exam_id = '$exam_id'";
$result = mysqli_query($conn, $sql);
$exam = mysqli_fetch_assoc($result);

if (!$exam) {
    die("Exam not found.");
}
?>

<div class="col-span-12 grid lg:col-span-8">
  <div class="card">
    <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
      <div class="flex items-center space-x-2">
        <div
          class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary dark:bg-accent-light/10 dark:text-accent-light"
        >
          <i class="fa-solid fa-layer-group"></i>
        </div>
        <h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">
          Edit Exam Schedule
        </h4>
      </div>
    </div>

    <div class="space-y-4 p-4 sm:p-5">
      <form method="POST">
        <!-- Exam Name -->
<input type="hidden" value="updateprimary" name="form_type">
<span class="font-medium text-slate-600 dark:text-navy-100">Enter Exam Name</span>
<label class="relative flex">
<input name="exam_name"
  class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
  placeholder="Exam Name"
  type="text"
  value="<?= htmlspecialchars($exam['exam_name']) ?>"
  required
/>
<span
  class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
>
  <svg xmlns="http://www.w3.org/2000/svg" class="size-4.5" fill="currentColor" viewBox="0 0 24 24"><path d="M3.316 13.781l.73-.171-.73.171zm0-5.457l.73.171-.73-.171zm15.473 0l.73-.171-.73.171zm0 5.457l.73.171-.73-.171zm-5.008 5.008l-.171-.73.171.73zm-5.457 0l-.171.73.171-.73zm0-15.473l-.171-.73.171.73zm5.457 0l.171-.73-.171.73zM20.47 21.53a.75.75 0 101.06-1.06l-1.06 1.06zM4.046 13.61a11.198 11.198 0 010-5.115l-1.46-.342a12.698 12.698 0 000 5.8l1.46-.343zm14.013-5.115a11.196 11.196 0 010 5.115l1.46.342a12.698 12.698 0 000-5.8l-1.46.343zm-4.45 9.564a11.196 11.196 0 01-5.114 0l-.342 1.46c1.907.448 3.892.448 5.8 0l-.343-1.46zM8.496 4.046a11.198 11.198 0 015.115 0l.342-1.46a12.698 12.698 0 00-5.8 0l.343 1.46zm0 14.013a5.97 5.97 0 01-4.45-4.45l-1.46.343a7.47 7.47 0 005.568 5.568l.342-1.46zm5.457 1.46a7.47 7.47 0 005.568-5.567l-1.46-.342a5.97 5.97 0 01-4.45 4.45l.342 1.46zM13.61 4.046a5.97 5.97 0 014.45 4.45l1.46-.343a7.47 7.47 0 00-5.568-5.567l-.342 1.46zm-5.457-1.46a7.47 7.47 0 00-5.567 5.567l1.46.342a5.97 5.97 0 014.45-4.45l-.343-1.46zm8.652 15.28l3.665 3.664 1.06-1.06-3.665-3.665-1.06 1.06z"/></svg>
</span>
</label>

<span class="font-medium text-slate-600 dark:text-navy-100">Exam Start Date</span>    
<label class="relative flex">

  <input
    x-init="$el._x_flatpickr = flatpickr($el)"
    class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
    placeholder="Exam Start Date"
    type="text"
    name="exam_start_date"
    value="<?= htmlspecialchars($exam['start_date']) ?>"0 
    required
  />
  <span
    class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
  >
    <svg
      xmlns="http://www.w3.org/2000/svg"
      class="size-5 transition-colors duration-200"
      fill="none"
      viewBox="0 0 24 24"
      stroke="currentColor"
      stroke-width="1.5"
    >
      <path
        stroke-linecap="round"
        stroke-linejoin="round"
        d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"
      />
    </svg>
  </span>
</label>


 <span class="font-medium text-slate-600 dark:text-navy-100">Exam End Date</span>                   
<label class="relative flex">
  <input
    x-init="$el._x_flatpickr = flatpickr($el)"
    class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
    placeholder="Exam End Date"
    type="text"
    name="exam_end_date"
    value="<?= htmlspecialchars($exam['end_date']) ?>"
    required
  />
  <span
    class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
  >
    <svg
      xmlns="http://www.w3.org/2000/svg"
      class="size-5 transition-colors duration-200"
      fill="none"
      viewBox="0 0 24 24"
      stroke="currentColor"
      stroke-width="1.5"
    >
      <path
        stroke-linecap="round"
        stroke-linejoin="round"
        d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"
      />
    </svg>
  </span>
</label>


<?php
$sql = "SELECT batch_id, batch_name FROM batch WHERE status = 'Active' ORDER BY batch_id DESC";
$result = mysqli_query($conn, $sql);
?>




        <!-- Batch Select -->
        <?php
        $sqlBatch = "SELECT batch_id, batch_name FROM batch WHERE status = 'Active' ORDER BY batch_id DESC";
        $resultBatch = mysqli_query($conn, $sqlBatch);
        ?>
        <label class="block">
          <span>Select Batch</span>
          <select
            name="batch"
            required
    class="mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent"
          >
            <option value="">Select Batch</option>
            <?php while ($row = mysqli_fetch_assoc($resultBatch)) : ?>
              <option value="<?= $row['batch_name'] ?>" 
                <?= ($exam['batch'] == $row['batch_name']) ? "selected" : "" ?>>
                <?= htmlspecialchars($row['batch_name']) ?>
              </option>
            <?php endwhile; ?>
          </select>
        </label>

        <br>



  <button
    type="submit"
    class="btn space-x-2 w-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
  >
    <span>Submit</span>
  </button>


        
        

      </form>
    </div>
  </div>
</div>




<?php

$exam_id = $_SESSION['exam_id'];

// ✅ Handle Update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['form_type'] === 'updatesubject') {
    if (isset($_POST['subject_id'])) {
        foreach ($_POST['subject_id'] as $index => $id) {
            $subject_name = mysqli_real_escape_string($conn, $_POST['subject_name'][$index]);
            $exam_date    = mysqli_real_escape_string($conn, $_POST['exam_date'][$index]);
            $start_time   = mysqli_real_escape_string($conn, $_POST['start_time'][$index]);
            $end_time     = mysqli_real_escape_string($conn, $_POST['end_time'][$index]);
            $max_marks    = (int)$_POST['max_marks'][$index];
            $passing_marks = (int)$_POST['passing_marks'][$index];

            $sqlUpdate = "UPDATE exam_subjects 
                          SET subject_name='$subject_name',
                              exam_date='$exam_date',
                              start_time='$start_time',
                              end_time='$end_time',
                              max_marks='$max_marks',
                              passing_marks='$passing_marks'
                          WHERE exam_subject_id='$id' AND exam_id='$exam_id'";
            mysqli_query($conn, $sqlUpdate);
        }
        echo "<script>alert('Exam Subjects Updated Successfully');</script>";
    }
}

// ✅ Fetch subjects
$sql = "SELECT * FROM exam_subjects WHERE exam_id='$exam_id' ORDER BY exam_date ASC";
$result = mysqli_query($conn, $sql);
?>

<div class="col-span-12 mt-5 grid lg:col-span-8">
  <div class="card">
    <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
      <div class="flex items-center space-x-2">
        <div
          class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary dark:bg-accent-light/10 dark:text-accent-light"
        >
          <i class="fa-solid fa-layer-group"></i>
        </div>
        <h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">
          Edit Exam Schedule
        </h4>
      </div>
    </div>

<form method="POST">
<div class="overflow-auto">
<input type="hidden" value="updatesubject" name="form_type">  
  <table class="is-zebra mt-5 w-full text-left">
    <thead>
      <tr>
        <th class="whitespace-nowrap bg-slate-200 px-3 py-3 font-semibold">#</th>
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold">Subject Name</th>
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold">Exam Date</th>
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold">Start Time</th>
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold">End Time</th>
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold">Max Marks</th>
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold">Passing Marks</th>
      </tr>
    </thead>
    <tbody>
      <?php 
      $i = 1;
      while ($row = mysqli_fetch_assoc($result)) : ?>
        <tr>
          <td class="px-4 py-3"><?= $i ?></td>
          
          <td>
            <input type="hidden" name="subject_id[]" value="<?= $row['exam_subject_id'] ?>">
            <input type="text" name="subject_name[]" value="<?= htmlspecialchars($row['subject_name']) ?>" 
              class="form-input w-full rounded-lg border px-2 py-1">
          </td>

          <td>
            <input type="date" name="exam_date[]" value="<?= $row['exam_date'] ?>" 
              class="form-input w-full rounded-lg border px-2 py-1">
          </td>

          <td>
            <input type="time" name="start_time[]" value="<?= $row['start_time'] ?>" 
              class="form-input w-full rounded-lg border px-2 py-1">
          </td>

          <td>
            <input type="time" name="end_time[]" value="<?= $row['end_time'] ?>" 
              class="form-input w-full rounded-lg border px-2 py-1">
          </td>

          <td>
            <input type="number" name="max_marks[]" value="<?= $row['max_marks'] ?>" 
              class="form-input w-full rounded-lg border px-2 py-1">
          </td>

          <td>
            <input type="number" name="passing_marks[]" value="<?= $row['passing_marks'] ?>" 
              class="form-input w-full rounded-lg border px-2 py-1">
          </td>
        </tr>
      <?php 
      $i++;
      endwhile; 
      ?>
    </tbody>
  </table>
</div>
<br>
<button
type="submit"
class="btn space-x-2 w-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
>
<span>Submit</span>
</button>

</form>
</div>
</div>


  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>

  </body>
</html>