
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

<!-- export-form.php -->

  


 
<form method="POST" id="studentForm" action="export-929.php" x-data>
<div class="col-span-12 grid lg:col-span-8">
  <div class="card">
    <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
      <div class="flex items-center space-x-2">
        <div class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary dark:bg-accent-light/10 dark:text-accent-light">
          <i class="fa-solid fa-layer-group"></i>
        </div>
        <h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">General</h4>
      </div>
    </div>

    <div class="space-y-4 p-4 sm:p-5">

      <!-- Student Name Fields -->
      <label class="block">
        <span>Select Data</span>
<?php


$mainTable = "exam_results";
$joinTable = "students";
$mainColumn = "student_id";
$joinColumn = "student_id";
// Fetch columns from main table

$result = $conn->query("DESCRIBE `$mainTable`");
while ($row = $result->fetch_assoc()) {
    echo '<input type="checkbox" name="columns[]" value="'.$mainTable.'.'.$row['Field'].'"> '.$row['Field'].'<br>';
}

// Fetch columns from join table

$result = $conn->query("DESCRIBE `$joinTable`");
while ($row = $result->fetch_assoc()) {
    echo '<input type="checkbox" name="columns[]" value="'.$joinTable.'.'.$row['Field'].'"> '.$row['Field'].'<br>';
}
?>

<!-- Pass main table and join table info in hidden inputs -->
<input type="hidden" name="table" value="<?php echo $mainTable; ?>">
<input type="hidden" name="join_table" value="<?php echo $joinTable; ?>">
<input type="hidden" name="main_column" value="<?php echo $mainColumn; ?>"> <!-- column in main table to join -->
<input type="hidden" name="join_column" value="<?php echo $joinColumn; ?>"> <!-- column in join table to join -->

      <!-- Gender & Minority -->
      <div class="grid grid-cols-2 gap-4">
        <label class="block">
          <span>Formate</span>
          <select name="format" required
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2">
<option value="csv">CSV</option>
<option value="txt">TXT</option>
<option value="xlsx">Excel</option>
<option value="pdf">PDF</option>
          </select>
        </label>

      </div>

<?php
// Get maximum student_id from students table
$resultMax = $conn->query("SELECT MAX($mainColumn) AS max_id FROM $mainTable");
$rowMax = $resultMax->fetch_assoc();
$maxId = $rowMax['max_id'] ?? 0;
?>

<!-- From and To Fields -->
<div class="grid grid-cols-2 gap-4">
  <label class="block">
    <span>From Student ID</span>
    <input type="number" name="from_id" min="1" max="<?php echo $maxId; ?>" class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2" placeholder="e.g., 1" required>
  </label>

  <label class="block">
    <span>To Student ID (Max: <?php echo $maxId; ?>)</span>
    <input type="number" name="to_id" min="1" max="<?php echo $maxId; ?>" class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2" placeholder="e.g., <?php echo $maxId; ?>" required>
  </label>
</div>




      <div class="flex justify-center space-x-2 pt-4">
        <button type="submit"
          class="btn space-x-2 bg-slate-150 font-medium text-slate-800 hover:bg-slate-200 focus:bg-slate-200 active:bg-slate-200/80 dark:bg-navy-500 dark:text-navy-50 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90">
          <span>Submit</span>
        </button>
      </div>

    </div>
  </div>
</div>
</form>
  
  
  

  
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>