
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

  
  


  
  
  
<form method="POST" enctype="multipart/form-data" class="col-span-12 grid lg:col-span-8 mx-auto max-w-3xl">

  <div class="card">
    <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
      <div class="flex items-center space-x-2">
        <div class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary dark:bg-accent-light/10 dark:text-accent-light">
          <i class="fa-solid fa-user-tie"></i>
        </div>
        <h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">
          Add New Staff
        </h4>
      </div>
    </div>

    <div class="space-y-4 p-4 sm:p-5">

      <!-- Image -->
      <label class="block">
        <span>Staff Image</span>
        <input type="file" name="staff_image" class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Username</span>
        <input type="text" name="staff_username" required class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Password</span>
        <input type="password" name="staff_password" required class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Surname</span>
        <input type="text" name="staff_surname" required class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Name</span>
        <input type="text" name="staff_name" required class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Father Name</span>
        <input type="text" name="staff_fathername" class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <div class="grid grid-cols-2 gap-4">
        <label class="block">
          <span>Gender</span>
          <select name="staff_gender" required class="mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2">
            <option value="">Select Gender</option>
            <option value="Male">Male</option>
            <option value="Female">Female</option>
            <option value="Other">Other</option>
          </select>
        </label>

        <label class="block">
          <span>Caste</span>
          <select name="staff_caste" required class="mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2">
            <option value="">Select Caste</option>
            <option value="General">General</option>
            <option value="OBC">OBC</option>
            <option value="SC">SC</option>
            <option value="ST">ST</option>
            <option value="Other">Other</option>
          </select>
        </label>
      </div>

      <div class="grid grid-cols-2 gap-4">
        <label class="block">
          <span>Subcaste</span>
          <input type="text" name="staff_subcaste" class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
        </label>

        <label class="block">
          <span>Minority</span>
          <select name="staff_minority" required class="mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2">
            <option value="">Select Minority</option>
            <option value="Yes">Yes</option>
            <option value="No">No</option>
            <option value="Other">Other</option>
          </select>
        </label>
      </div>

      <label class="block">
        <span>Birthdate</span>
        <input type="date" name="staff_birthdate" class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Phone Number</span>
        <input type="text" name="staff_phonenumber" class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Alternative Number</span>
        <input type="text" name="staff_alternativenumber" class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Email</span>
        <input type="email" name="staff_email" class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Address</span>
        <input type="text" name="staff_address" class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Salary</span>
        <input type="number" step="0.01" name="staff_salary" class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Role</span>
        <select name="staff_role" required class="mt-1.5 w-full border border-slate-300 rounded-lg bg-slate-100 px-3 py-2">
          <option value="">Select Role</option>
          <option value="admin">Admin</option>
          <option value="driver">Driver</option>
          <option value="accountant">Accountant</option>
          <option value="teacher">Teacher</option>
          <option value="other">Other</option>
        </select>
      </label>

      <label class="block">
        <span>Details</span>
        <textarea name="staff_details" class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"></textarea>
      </label>

      <label class="block">
        <span>Status</span>
        <select name="staff_status" required class="mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2">
          <option value="Active" selected>Active</option>
          <option value="Inactive">Inactive</option>
          <option value="Suspended">Suspended</option>
          <option value="Retired">Retired</option>
        </select>
      </label>



      <button type="submit" class="btn mt-4 bg-primary text-white px-4 py-2 rounded-lg">
        Add Staff
      </button>

    </div>
  </div>
</form>

  
<?php

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Sanitize inputs (use your DB connection $conn)
    $staff_username        = mysqli_real_escape_string($conn, $_POST['staff_username']);
    $staff_password        = mysqli_real_escape_string($conn, $_POST['staff_password']);
    $staff_surname         = mysqli_real_escape_string($conn, $_POST['staff_surname']);
    $staff_name            = mysqli_real_escape_string($conn, $_POST['staff_name']);
    $staff_fathername      = mysqli_real_escape_string($conn, $_POST['staff_fathername']);
    $staff_gender          = mysqli_real_escape_string($conn, $_POST['staff_gender']);
    $staff_caste           = mysqli_real_escape_string($conn, $_POST['staff_caste']);
    $staff_subcaste        = mysqli_real_escape_string($conn, $_POST['staff_subcaste']);
    $staff_minority        = mysqli_real_escape_string($conn, $_POST['staff_minority']);
    $staff_birthdate       = mysqli_real_escape_string($conn, $_POST['staff_birthdate']);
    $staff_phonenumber     = mysqli_real_escape_string($conn, $_POST['staff_phonenumber']);
    $staff_alternativenumber = mysqli_real_escape_string($conn, $_POST['staff_alternativenumber']);
    $staff_email           = mysqli_real_escape_string($conn, $_POST['staff_email']);
    $staff_address         = mysqli_real_escape_string($conn, $_POST['staff_address']);
    $staff_salary          = floatval($_POST['staff_salary']);
    $staff_role            = mysqli_real_escape_string($conn, $_POST['staff_role']);
    $staff_details         = mysqli_real_escape_string($conn, $_POST['staff_details']);
    $staff_status          = mysqli_real_escape_string($conn, $_POST['staff_status']);
$staff_registrationdate = date('Y-m-d H:i:s');  // current datetime

    // Handle image upload
    if (!empty($_FILES['staff_image']['name'])) {
$target_dir = "../staffprofileimage/";
$target_dir2 = "staffprofileimage/";      
        if (!is_dir($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        $target_file = $target_dir2 . basename($_FILES["staff_image"]["name"]);
        move_uploaded_file($_FILES["staff_image"]["tmp_name"], $target_file);
        $staff_image = $target_file;
    } else {
        $staff_image = ""; // No image uploaded
    }

    // Insert query
    $sql = "INSERT INTO staff (
                staff_username,
                staff_password,
                staff_surname,
                staff_name,
                staff_fathername,
                staff_gender,
                staff_caste,
                staff_subcaste,
                staff_minority,
                staff_birthdate,
                staff_phonenumber,
                staff_alternativenumber,
                staff_email,
                staff_address,
                staff_image,
                staff_salary,
                staff_role,
                staff_details,
                staff_status,
                staff_registrationdate
            ) VALUES (
                '$staff_username',
                '$staff_password',
                '$staff_surname',
                '$staff_name',
                '$staff_fathername',
                '$staff_gender',
                '$staff_caste',
                '$staff_subcaste',
                '$staff_minority',
                '$staff_birthdate',
                '$staff_phonenumber',
                '$staff_alternativenumber',
                '$staff_email',
                '$staff_address',
                '$staff_image',
                '$staff_salary',
                '$staff_role',
                '$staff_details',
                '$staff_status',
                '$staff_registrationdate'
            )";

if (mysqli_query($conn, $sql)) {
    $message = "Staff added successfully!";
    $messageType = "success";

} else {
    $message = "Error: " . mysqli_error($conn);
    $messageType = "error";
}
}
?>
  
  
  </div>
</div>
      </main>
    </div>
    
<div x-data="{ 
        showModal: <?= $message ? 'true' : 'false' ?>, 
        message: '<?= addslashes($message) ?>', 
        type: '<?= $messageType ?>' 
     }"
     x-init="
        $watch('showModal', value => {
          if (!value && type === 'success') {
            // Reset form and refresh GR
            document.getElementById('studentForm').reset();
            document.getElementById('grNumber').value = '<?= $nextGR ?>';
          }
        });
     ">
  <!-- Modal content same as before (success/error with colors) -->


  <template x-teleport="#x-teleport-target">
    <div class="fixed inset-0 z-[100] flex items-center justify-center px-4 py-6 sm:px-5"
         x-show="showModal"
         role="dialog"
         @keydown.window.escape="showModal = false">

      <!-- Overlay -->
      <div class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
           @click="showModal = false"
           x-show="showModal"
           x-transition:enter="ease-out"
           x-transition:enter-start="opacity-0"
           x-transition:enter-end="opacity-100"
           x-transition:leave="ease-in"
           x-transition:leave-start="opacity-100"
           x-transition:leave-end="opacity-0"></div>

      <!-- Modal Content -->
      <div class="scrollbar-sm relative flex max-w-lg flex-col overflow-y-auto rounded-lg px-4 py-10 text-center transition-opacity duration-300 sm:px-5"
           x-show="showModal"
           x-transition:enter="ease-out"
           x-transition:enter-start="opacity-0"
           x-transition:enter-end="opacity-100"
           x-transition:leave="ease-in"
           x-transition:leave-start="opacity-100"
           x-transition:leave-end="opacity-0"
           :class="type === 'success' ? 'bg-white dark:bg-navy-700' : 'bg-white border border-red-500 dark:bg-navy-700'">

        <!-- Icon based on type -->
        <svg x-show="type === 'success'" xmlns="http://www.w3.org/2000/svg"
             class="mx-auto inline size-28 shrink-0 text-success"
             fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>

        <svg x-show="type === 'error'" xmlns="http://www.w3.org/2000/svg"
             class="mx-auto inline size-28 shrink-0 text-red-600"
             fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M6 18L18 6M6 6l12 12"/>
        </svg>

        <div class="mt-4">
          <h2 class="text-2xl font-bold"
              :class="type === 'success' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'">
            <span x-text="type === 'success' ? 'Success!' : 'Error!'"></span>
          </h2>
          <p class="mt-2 text-slate-600 dark:text-slate-200" x-text="message"></p>

          <button @click="showModal = false"
                  class="btn mt-6 font-medium text-white"
                  :class="type === 'success' ? 'bg-success hover:bg-success-focus' : 'bg-red-600 hover:bg-red-700'">
            Close
          </button>
        </div>
      </div>
    </div>
  </template>
</div>
    
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>