
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

  
  


  





<?php
// add_fee_structure.php
include '../core/db-connect91.php';
session_start();

// Helper: sanitize array values
function clean_array($arr) {
    $out = [];
    foreach ($arr as $v) {
        $v = trim($v);
        if ($v !== '') $out[] = $v;
    }
    return $out;
}

$action = $_POST['action'] ?? '';
$classes = mysqli_query($conn, "SELECT class_id, class_name, division FROM classes ORDER BY class_name+0, division");

// ====== HANDLE SAVE ======
if ($action === 'save') {
    $class_id = intval($_POST['class_id']);
    $batch = mysqli_real_escape_string($conn, $_POST['batch']);
    $selected_semester = intval($_POST['semester']);
    $selected_gender = mysqli_real_escape_string($conn, $_POST['gender']);

    // Build rows grouped by semester.
    $rows_by_sem = [];

    if ($selected_semester > 0) {
        // Old single-semester structure: fee_type[] and amount[]
        $fee_types = $_POST['fee_type'] ?? [];
        $amounts   = $_POST['amount'] ?? [];
        for ($i = 0; $i < count($fee_types); $i++) {
            $ft = trim($fee_types[$i]);
            $am = trim($amounts[$i]);
            if ($ft === '' && $am === '') continue;
            $am = floatval(str_replace(',', '', $am));
            $rows_by_sem[$selected_semester][] = ['fee_type' => $ft, 'amount' => $am];
        }
    } else {
        // New multi-semester structure: fee_type[1][], amount[1][], fee_type[2][], amount[2][]
        for ($sem = 1; $sem <= 2; $sem++) {
            $fts = $_POST['fee_type'][$sem] ?? [];
            $ams = $_POST['amount'][$sem] ?? [];
            for ($i = 0; $i < count($fts); $i++) {
                $ft = trim($fts[$i]);
                $am = trim($ams[$i]);
                if ($ft === '' && $am === '') continue;
                $am = floatval(str_replace(',', '', $am));
                $rows_by_sem[$sem][] = ['fee_type' => $ft, 'amount' => $am];
            }
        }
    }

    // If no rows for any semester, warn and redirect
    $has_any = false;
    foreach ($rows_by_sem as $r) { if (!empty($r)) { $has_any = true; break; } }
    if (!$has_any) {
        $_SESSION['fee_msg'] = ['type' => 'warning', 'text' => 'No fee rows to save.'];
        header("Location: " . $_SERVER['REQUEST_URI']);
        exit;
    }

    mysqli_begin_transaction($conn);
    try {
        // Prepare delete and insert statements
        $delSql = "DELETE FROM fee_structure WHERE class_id=? AND batch=? AND semester=? AND gender=?";
        $delStmt = mysqli_prepare($conn, $delSql);

        $insSql = "INSERT INTO fee_structure (class_id, fee_type, amount, semester, month, batch, gender, created_at) 
                   VALUES (?, ?, ?, ?, 0, ?, ?, NOW())";
        $insStmt = mysqli_prepare($conn, $insSql);

        foreach ($rows_by_sem as $semester => $rows) {
            // Delete old fees for this semester/gender
            mysqli_stmt_bind_param($delStmt, "isis", $class_id, $batch, $semester, $selected_gender);
            if (!mysqli_stmt_execute($delStmt)) {
                throw new Exception(mysqli_stmt_error($delStmt));
            }

            // Insert new fees (if any)
            if (!empty($rows)) {
                foreach ($rows as $r) {
                    mysqli_stmt_bind_param($insStmt, "isdiss", $class_id, $r['fee_type'], $r['amount'], $semester, $batch, $selected_gender);
                    if (!mysqli_stmt_execute($insStmt)) {
                        throw new Exception(mysqli_stmt_error($insStmt));
                    }
                }
            }
        }

        mysqli_stmt_close($delStmt);
        mysqli_stmt_close($insStmt);
        mysqli_commit($conn);

        $_SESSION['fee_msg'] = ['type' => 'success', 'text' => "Fees saved successfully for gender: {$selected_gender}"];
    } catch (Exception $e) {
        mysqli_rollback($conn);
        $_SESSION['fee_msg'] = ['type' => 'danger', 'text' => 'Save failed: '.$e->getMessage()];
    }

    header("Location: " . $_SERVER['REQUEST_URI']);
    exit;
}

// ====== SHOW FORM VARIABLES ======
$selected_class = intval($_POST['class_id'] ?? 0);
$selected_batch = $_POST['batch'] ?? '';
$selected_semester = intval($_POST['semester'] ?? 0);
$selected_gender = $_POST['gender'] ?? 'common';

// ====== FETCH EXISTING FEES ======
$fee_data_by_sem = []; // keyed by semester
if ($action === 'show' && $selected_class > 0 && $selected_batch !== '') {
    if ($selected_semester > 0) {
        $q = sprintf(
            "SELECT fee_type, amount FROM fee_structure
             WHERE class_id=%d AND batch='%s' AND gender='%s' AND semester=%d
             ORDER BY fee_type",
            $selected_class,
            mysqli_real_escape_string($conn, $selected_batch),
            mysqli_real_escape_string($conn, $selected_gender),
            $selected_semester
        );
        $res = mysqli_query($conn, $q);
        while ($r = mysqli_fetch_assoc($res)) {
            $fee_data_by_sem[$selected_semester][] = $r;
        }
    } else {
        // load for both semesters
        for ($sem = 1; $sem <= 2; $sem++) {
            $q = sprintf(
                "SELECT fee_type, amount FROM fee_structure
                 WHERE class_id=%d AND batch='%s' AND gender='%s' AND semester=%d
                 ORDER BY fee_type",
                $selected_class,
                mysqli_real_escape_string($conn, $selected_batch),
                mysqli_real_escape_string($conn, $selected_gender),
                $sem
            );
            $res = mysqli_query($conn, $q);
            while ($r = mysqli_fetch_assoc($res)) {
                $fee_data_by_sem[$sem][] = $r;
            }
        }
    }
}

// ====== RENDER FEE CARD ======
function render_fee_card($card_title, $rows = [], $gender_key = '', $semester = 1) {
    $gender_attr = htmlspecialchars($gender_key);
    $sem_attr = intval($semester);
    ?>
    <div class="card px-4 pb-4 mt-4 sm:px-5 mb-4">
      <div class="my-3 flex items-center justify-between">
        <h2 class="font-medium tracking-wide text-slate-700 dark:text-navy-100 lg:text-base">
          <?= htmlspecialchars($card_title) ?>
        </h2>
        <div>
          <button type="button" class="btn-add-row inline-block rounded px-3 py-1 bg-primary text-white" data-gender="<?= $gender_attr ?>" data-sem="<?= $sem_attr ?>">Add row</button>
        </div>
      </div>

      <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
        <table class="is-zebra w-full text-left fee-table" data-gender="<?= $gender_attr ?>" data-sem="<?= $sem_attr ?>">
          <thead>
            <tr>
              <th class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">#</th>
              <th class="whitespace-nowrap bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Fee Type</th>
              <th class="whitespace-nowrap bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Amount</th>
              <th class="whitespace-nowrap rounded-r-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Action</th>
            </tr>
          </thead>
          <tbody>
            <?php
            $i = 1;
            if (!empty($rows)) {
                foreach ($rows as $r) {
                    $ft = htmlspecialchars($r['fee_type']);
                    $am = number_format((float)$r['amount'], 2, '.', '');
                    // name arrays keyed by semester: fee_type[semester][] and amount[semester][]
                    echo "<tr>
                        <td class='whitespace-nowrap rounded-l-lg px-4 py-3 sm:px-5'>{$i}</td>
                        <td class=whitespace-nowrap px-4 py-3 sm:px-5'><input type='text' name='fee_type[{$sem_attr}][]' class='form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9' value='{$ft}' required></td>
                        <td class=whitespace-nowrap px-4 py-3 sm:px-5'><input type='number' step='0.01' name='amount[{$sem_attr}][]' class='form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 amount-input' value='{$am}' required></td>
                    <td class=whitespace-nowrap rounded-r-lg px-4 py-3 sm:px-5'><center><button type='button' class='remove-row btn bg-error size-6 text-white px-4 py-2'>X</button></center></td>
                    </tr>";
                    $i++;
                }
            } else {
                echo "<tr>
                    <tdclass=whitespace-nowrap rounded-l-lg px-4 py-3 sm:px-5'>1</td>
                    <td class=whitespace-nowrap px-4 py-3 sm:px-5'><input type='text' name='fee_type[{$sem_attr}][]' class='form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9' required></td>
                    <td class=whitespace-nowrap px-4 py-3 sm:px-5'><input type='number' step='0.01' name='amount[{$sem_attr}][]' class='form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 amount-input' value='0.00' required></td>
                    <td class=whitespace-nowrap rounded-r-lg px-4 py-3 sm:px-5'><center><button type='button' class='remove-row size-6 btn bg-error text-white px-4 py-2'>X</button></center></td>
                </tr>";
            }
            ?>
          </tbody>
          <tfoot>
            <tr class="font-semibold bg-slate-100 total-row">
              <td>Total</td>
              <td></td>
              <td class="total-amount" colspan="2">0.00</td>
            </tr>
          </tfoot>
        </table>
      </div>
    </div>
    <?php
}
?>

<!-- ====== CLASS/SEMESTER/GENDER SELECTION FORM ====== -->
<div class="col-span-12 grid lg:col-span-8">
  <div class="card">
    <div class="border-b border-slate-200 p-4 sm:px-5">
      <div class="flex items-center space-x-2">
        <h4 class="text-lg font-medium text-slate-700">Fee Structure</h4>
      </div>
    </div>

    <form method="POST" id="selectForm" class="p-4 sm:p-5">
      <input type="hidden" name="action" value="show">

<label class="block">
  <span class="font-medium text-slate-600 dark:text-navy-100">Class</span>
  <select name="class_id" required
    class="mt-1.5 w-full"
    x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
  >
    <option value="">Select Class</option>
    <?php while ($row = mysqli_fetch_assoc($classes)) :
        $display_name = $row['class_name'] . ' ' . strtoupper($row['division']); ?>
      <option value="<?= $row['class_id'] ?>" <?= $selected_class == $row['class_id'] ? 'selected' : '' ?>>
        <?= htmlspecialchars($display_name) ?>
      </option>
    <?php endwhile; ?>
  </select>
</label>

<label class="block mt-3">
  <span class="font-medium text-slate-600 dark:text-navy-100">Batch</span>
  <select name="batch" required
    class="mt-1.5 w-full"
    x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
  >
    <option value="">Select Batch</option>
    <?php
    $bres = mysqli_query($conn, "SELECT batch_name FROM batch WHERE status='Active' ORDER BY batch_id DESC");
    while ($b = mysqli_fetch_assoc($bres)) : ?>
      <option value="<?= htmlspecialchars($b['batch_name']) ?>" <?= $selected_batch == $b['batch_name'] ? 'selected' : '' ?>>
        <?= htmlspecialchars($b['batch_name']) ?>
      </option>
    <?php endwhile; ?>
  </select>
</label>

<label class="block mt-3">
  <span class="font-medium text-slate-600 dark:text-navy-100">Semester</span>
  <select name="semester" required
    class="mt-1.5 w-full"
    x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
  >
    <option value="0" <?= $selected_semester == 0 ? 'selected' : '' ?>>All</option>
    <option value="1" <?= $selected_semester == 1 ? 'selected' : '' ?>>Semester 1</option>
    <option value="2" <?= $selected_semester == 2 ? 'selected' : '' ?>>Semester 2</option>
  </select>
</label>

<label class="block mt-3">
  <span class="font-medium text-slate-600 dark:text-navy-100">Gender</span>
  <select name="gender" required
    class="mt-1.5 w-full"
    x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
  >
    <option value="common" <?= $selected_gender == 'common' ? 'selected' : '' ?>>Common</option>
    <option value="male" <?= $selected_gender == 'male' ? 'selected' : '' ?>>Male</option>
    <option value="female" <?= $selected_gender == 'female' ? 'selected' : '' ?>>Female</option>
  </select>
</label>

      <div class="flex justify-center pt-4">
        <button type="submit" class="btn bg-primary text-white px-4 py-2">Submit</button>
      </div>
    </form>
  </div>
</div>

<!-- ====== EDIT TABLE ====== -->
<?php if ($action === 'show' && $selected_class > 0 && $selected_batch !== ''): ?>
<div class="col-span-12 grid lg:col-span-10 mt-5">
  <form method="POST" id="saveForm">
    <input type="hidden" name="action" value="save">
    <input type="hidden" name="class_id" value="<?= $selected_class ?>">
    <input type="hidden" name="batch" value="<?= htmlspecialchars($selected_batch) ?>">
    <input type="hidden" name="semester" value="<?= $selected_semester ?>">
    <input type="hidden" name="gender" value="<?= htmlspecialchars($selected_gender) ?>">

    <?php
    if ($selected_semester > 0) {
        // single semester card
        $rows = $fee_data_by_sem[$selected_semester] ?? [];
        render_fee_card("Semester {$selected_semester} - " . ucfirst($selected_gender) . " Fees", $rows, $selected_gender, $selected_semester);
    } else {
        // show both semesters as separate cards
        for ($sem = 1; $sem <= 2; $sem++) {
            $rows = $fee_data_by_sem[$sem] ?? [];
            render_fee_card("Semester {$sem} - " . ucfirst($selected_gender) . " Fees", $rows, $selected_gender, $sem);
        }
    }
    ?>

    <div class="flex justify-center pt-4">
      <button type="submit" class="btn bg-primary text-white px-4 py-2">Save Fees</button>
    </div>
  </form>
</div>
<?php endif; ?>

<!-- ====== JS ====== -->
<script>
document.addEventListener('DOMContentLoaded', function () {
  function updateIndexes(tbl) {
    tbl.querySelectorAll('tbody tr').forEach((r, idx) => {
      const firstCell = r.querySelector('td');
      if (firstCell) firstCell.textContent = idx + 1;
    });
  }

  function recalcTotal(tbl) {
    let total = 0;
    tbl.querySelectorAll('.amount-input').forEach(input => {
      total += parseFloat(input.value) || 0;
    });
    const totalCell = tbl.querySelector('.total-amount');
    if (totalCell) totalCell.textContent = total.toFixed(2);
  }

  document.addEventListener('click', function (e) {
    // Use closest() so clicks on inner elements still work
    const addBtn = e.target.closest('.btn-add-row');
    if (addBtn) {
      const gender = addBtn.dataset.gender;
      const sem = addBtn.dataset.sem;
      const tbl = document.querySelector(`table.fee-table[data-gender="${gender}"][data-sem="${sem}"]`);
      if (!tbl) return;
      const tbody = tbl.querySelector('tbody');
      const idx = tbody.querySelectorAll('tr').length + 1;
      const tr = document.createElement('tr');

      // Pick the button classes that match your CSS framework.
      // Bootstrap example: "btn btn-danger btn-sm"
      // Tailwind example: "px-3 py-1 bg-red-600 text-white rounded"
      tr.innerHTML = `<td class="whitespace-nowrap rounded-l-lg px-4 py-3 sm:px-5">${idx}</td>
        <td class="whitespace-nowrap px-4 py-3 sm:px-5"><input type="text" name="fee_type[${sem}][]" class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9" required></td>
        <td class="whitespace-nowrap px-4 py-3 sm:px-5"><input type="number" step="0.01" name="amount[${sem}][]" class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 amount-input" value="0.00" required></td>
        <td class="whitespace-nowrap rounded-r-lg px-4 py-3 sm:px-5"><center><button type="button" class="remove-row btn bg-error size-6 text-white px-4 py-2">X</button></center></td>`;

      tbody.appendChild(tr);
      updateIndexes(tbl);
      recalcTotal(tbl);
      return;
    }

    // Remove button (using closest to catch clicks on inner elements)
    const removeBtn = e.target.closest('.remove-row');
    if (removeBtn) {
      // optional confirmation:
      // if (!confirm('Remove this row?')) return;

      const tbl = removeBtn.closest('table');
      const row = removeBtn.closest('tr');
      if (row) row.remove();
      if (tbl) {
        updateIndexes(tbl);
        recalcTotal(tbl);
      }
      return;
    }
  });

  document.addEventListener('input', function (e) {
    if (e.target.classList.contains('amount-input')) {
      const tbl = e.target.closest('table');
      if (tbl) recalcTotal(tbl);
    }
  });

  // Init totals for any existing tables
  document.querySelectorAll('table.fee-table').forEach(tbl => recalcTotal(tbl));
});
</script>

<?php if (!empty($_SESSION['fee_msg'])): $m = $_SESSION['fee_msg']; unset($_SESSION['fee_msg']); ?>
<div class="mt-3 p-3 <?= $m['type'] === 'success' ? 'bg-green-100' : ($m['type'] === 'danger' ? 'bg-red-100' : 'bg-yellow-100') ?>">
  <?= htmlspecialchars($m['text']) ?>
</div>
<?php endif; ?>

  
  


  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>