
<!doctype html>

<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>QR Scanner</title>
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #f3f4f6;
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
    }
    .card {
      background: #fff;
      border-radius: 24px;
      box-shadow: 0 10px 30px rgba(0,0,0,0.1);
      padding: 24px;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      gap: 16px;
    }
    #reader {
      width: 320px;
      height: 320px;
      border: 4px solid red;
      border-radius: 20px;
      box-shadow: 0 6px 20px rgba(0,0,0,0.08);
      overflow: hidden;
      position: relative;
      transition: border-color 0.3s ease;
      background: #000;
    }
    .scan-line {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 4px;
      background: rgba(0, 255, 0, 0.7);
      animation: scan 2s linear infinite;
    }
    @keyframes scan {
      0% { top: 0; }
      100% { top: calc(100% - 4px); }
    }
    .status {
      font-size: 16px;
      font-weight: 500;
      color: #555;
      transition: color 0.3s ease;
    }
    .status.detected {
      color: green;
    }
  </style>
</head>
<body>
  <div class="card">
    <div id="reader">
      <div class="scan-line"></div>
    </div>
    <div id="statusText" class="status">Scanning...</div>
  </div>  <script src="https://unpkg.com/html5-qrcode@2.3.7/minified/html5-qrcode.min.js"></script>  <script>
    const readerId = "reader";
    const html5QrCode = new Html5Qrcode(readerId);

    function onScanSuccess(decodedText, decodedResult) {
      const reader = document.getElementById(readerId);
      const statusText = document.getElementById("statusText");
      reader.style.borderColor = "#22c55e";
      statusText.textContent = "QR Code Detected!";
      statusText.classList.add("detected");
      html5QrCode.stop().then(() => {
        const encoded = encodeURIComponent(decodedText);
        setTimeout(() => {
          window.location.href = `qr_result.php?token=${encoded}`;
        }, 500);
      });
    }

    function onScanFailure(error) {
      document.getElementById(readerId).style.borderColor = "#ef4444";
      document.getElementById("statusText").textContent = "Scanning...";
      document.getElementById("statusText").classList.remove("detected");
    }

    Html5Qrcode.getCameras().then(cameras => {
      if (cameras && cameras.length) {
        html5QrCode.start(
          cameras[0].id,
          {
            fps: 10,
            qrbox: { width: 260, height: 260 }
          },
          onScanSuccess,
          onScanFailure
        );
      } else {
        document.getElementById(readerId).innerText = "No camera found";
      }
    }).catch(err => {
      document.getElementById(readerId).innerText = "Camera error";
    });
  </script></body>
</html>