<div
  x-show="$store.global.isRightSidebarExpanded"
  @keydown.window.escape="$store.global.isRightSidebarExpanded = false"
>
  <div
    class="fixed inset-0 z-[150] bg-slate-900/60 transition-opacity duration-200"
    @click="$store.global.isRightSidebarExpanded = false"
    x-show="$store.global.isRightSidebarExpanded"
    x-transition:enter="ease-out"
    x-transition:enter-start="opacity-0"
    x-transition:enter-end="opacity-100"
    x-transition:leave="ease-in"
    x-transition:leave-start="opacity-100"
    x-transition:leave-end="opacity-0"
  ></div>
  <div class="fixed right-0 top-0 z-[151] h-full w-full sm:w-80">
    <div
      x-data="{activeTab:'tabHome'}"
      class="relative flex h-full w-full transform-gpu flex-col bg-white transition-transform duration-200 dark:bg-navy-750"
      x-show="$store.global.isRightSidebarExpanded"
      x-transition:enter="ease-out"
      x-transition:enter-start="translate-x-full"
      x-transition:enter-end="translate-x-0"
      x-transition:leave="ease-in"
      x-transition:leave-start="translate-x-0"
      x-transition:leave-end="translate-x-full"
    >
      <div class="flex items-center justify-between py-2 px-4">
        <p
          x-show="activeTab === 'tabHome'"
          class="flex shrink-0 items-center space-x-1.5"
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-4"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              stroke-width="1.5"
              d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"
            />
          </svg>
          <span class="text-xs"><?php 
          echo date("d F Y");
          ?>
          </span>
        </p>
        <p
          x-show="activeTab === 'tabProjects'"
          class="flex shrink-0 items-center space-x-1.5"
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-4"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="1.5"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M7 12l3-3 3 3 4-4M8 21l4-4 4 4M3 4h18M4 4h16v12a1 1 0 01-1 1H5a1 1 0 01-1-1V4z"
            />
          </svg>
          <span class="text-xs">Syllabus</span>
        </p>
        <p
          x-show="activeTab === 'tabActivity'"
          class="flex shrink-0 items-center space-x-1.5"
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-4"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="1.5"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"
            />
          </svg>
          <span class="text-xs">Activity</span>
        </p>

        <button
          @click="$store.global.isRightSidebarExpanded=false"
          class="btn -mr-1 size-6 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-4"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="2"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M6 18L18 6M6 6l12 12"
            />
          </svg>
        </button>
      </div>

      <div
        x-show="activeTab === 'tabHome'"
        x-transition:enter="transition-all duration-500 easy-in-out"
        x-transition:enter-start="opacity-0 [transform:translate3d(0,1rem,0)]"
        x-transition:enter-end="opacity-100 [transform:translate3d(0,0,0)]"
        class="is-scrollbar-hidden overflow-y-auto overscroll-contain pt-1"
      >
        <label class="relative flex px-3">
          <input
            class="form-input peer h-8 w-full rounded-lg bg-slate-150 px-3 py-2 pl-9 text-xs-plus ring-primary/50 placeholder:text-slate-400 hover:bg-slate-200 focus:ring-3 dark:bg-navy-900/90 dark:ring-accent/50 dark:placeholder:text-navy-300 dark:hover:bg-navy-900 dark:focus:bg-navy-900"
            placeholder="Search here..."
            type="text"
          />
          <span
            class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
          >
            <svg
              xmlns="http://www.w3.org/2000/svg"
              class="size-4.5 transition-colors duration-200"
              fill="currentColor"
              viewBox="0 0 24 24"
            >
              <path
                d="M3.316 13.781l.73-.171-.73.171zm0-5.457l.73.171-.73-.171zm15.473 0l.73-.171-.73.171zm0 5.457l.73.171-.73-.171zm-5.008 5.008l-.171-.73.171.73zm-5.457 0l-.171.73.171-.73zm0-15.473l-.171-.73.171.73zm5.457 0l.171-.73-.171.73zM20.47 21.53a.75.75 0 101.06-1.06l-1.06 1.06zM4.046 13.61a11.198 11.198 0 010-5.115l-1.46-.342a12.698 12.698 0 000 5.8l1.46-.343zm14.013-5.115a11.196 11.196 0 010 5.115l1.46.342a12.698 12.698 0 000-5.8l-1.46.343zm-4.45 9.564a11.196 11.196 0 01-5.114 0l-.342 1.46c1.907.448 3.892.448 5.8 0l-.343-1.46zM8.496 4.046a11.198 11.198 0 015.115 0l.342-1.46a12.698 12.698 0 00-5.8 0l.343 1.46zm0 14.013a5.97 5.97 0 01-4.45-4.45l-1.46.343a7.47 7.47 0 005.568 5.568l.342-1.46zm5.457 1.46a7.47 7.47 0 005.568-5.567l-1.46-.342a5.97 5.97 0 01-4.45 4.45l.342 1.46zM13.61 4.046a5.97 5.97 0 014.45 4.45l1.46-.343a7.47 7.47 0 00-5.568-5.567l-.342 1.46zm-5.457-1.46a7.47 7.47 0 00-5.567 5.567l1.46.342a5.97 5.97 0 014.45-4.45l-.343-1.46zm8.652 15.28l3.665 3.664 1.06-1.06-3.665-3.665-1.06 1.06z"
              />
            </svg>
          </span>
        </label>
        
        <div class="mt-3 px-3">
        
        
        <h2
          class="text-xs-plus font-medium tracking-wide text-slate-700 line-clamp-1 dark:text-navy-100"
        >
Activity
        </h2>

<div class="mt-3">
        
       
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/vanilla-calendar-pro@2.9.2/build/vanilla-calendar.min.css">
<script src="https://cdn.jsdelivr.net/npm/vanilla-calendar-pro@2.9.2/build/vanilla-calendar.min.js"></script>
<center>
<div id="calendar" class="rounded-lg border border-slate-200 bg-white"></div>
</center>
<!-- Modal -->
<div id="todoModal" class="hidden fixed inset-0 flex items-center justify-center bg-black/50 z-50">
  <div class="bg-white rounded-xl shadow-lg p-6 w-96">
    <h3 class="text-lg font-bold text-slate-700 mb-3">To-Do for <span id="selectedDate"></span></h3>
    <form id="todoForm" method="POST">
      <input type="hidden" name="todo_date" id="todoDate">
      <div id="existingTodos" class="mb-3"></div>
      <div id="todoInputs">
        <input type="text" id="todoText" name="todo_text[]" class="w-full mb-2 rounded-lg border border-slate-300 p-2" placeholder="Enter new task">
      </div>
      <button type="button" onclick="addTodoInput()" class="btn mt-2 w-full rounded-lg bg-info text-white">+ Add Another</button>
      <button type="submit" class="btn mt-3 w-full rounded-lg bg-success text-white">Save</button>
      <button type="button" onclick="closeModal()" class="btn mt-2 w-full rounded-lg bg-slate-200">Cancel</button>
    </form>
  </div>
</div>

<script>
let calendar;

document.addEventListener('DOMContentLoaded', function () {
  calendar = new VanillaCalendar('#calendar', {
    settings: { selection: { day: 'single' }, visibility: { theme: 'light' } },
    actions: {
      clickDay(event, self) {
        let date = self.selectedDates[0];
        document.getElementById('todoDate').value = date;
        document.getElementById('selectedDate').innerText = date;
        loadTodos(date);
        document.getElementById('todoModal').classList.remove('hidden');
      },
      changeMonth(event, self) {
        let month = self.currentMonth.year + '-' + String(self.currentMonth.month + 1).padStart(2,'0');
        loadCounts(month);
      }
    }
  });
  calendar.init();

  // Initial counts
  let today = new Date();
  let month = today.getFullYear() + '-' + String(today.getMonth() + 1).padStart(2,'0');
  loadCounts(month);
});

function addTodoInput() {
  let div = document.createElement('div');
  div.innerHTML = `<input type="text" name="todo_text[]" class="w-full mb-2 rounded-lg border border-slate-300 p-2" placeholder="Enter new task">`;
  document.getElementById('todoInputs').appendChild(div);
}

function closeModal() {
  document.getElementById('todoModal').classList.add('hidden');
  // Clear all input fields
  $('#todoInputs').empty();
  $('#existingTodos').empty();
}

// Load old todos
function loadTodos(date) {
  $.ajax({
    url: 'supporting/fetch-todo.php',
    type: 'POST',
    data: { todo_date: date },
    dataType: 'json',
    success: function(data) {
      let list = $('#existingTodos');
      list.empty();
      if (data.length > 0) {
        list.append('<p class="mb-2 font-semibold text-slate-600">Existing Todos:</p>');
        data.forEach(todo => {
          list.append(`<div class="mb-1 rounded bg-slate-100 p-2">${todo.todo_text}</div>`);
        });
      }
    },
    error: function(xhr, status, err) {
      console.error("Error fetching todos:", err);
    }
  });
}

// Load todo counts for month
function loadCounts(month) {
  $.ajax({
    url: 'supporting/fetch-todo.php',
    type: 'POST',
    data: { month: month },
    dataType: 'json',
    success: function(counts) {
      $('.vanilla-calendar-day__btn').each(function() {
        let btn = $(this);
        let date = btn.attr('data-calendar-day');
        btn.find('.todo-badge').remove(); // remove old badges
        if (counts[date]) {
let badge = $(`<span class="todo-badge ml-1 inline-flex h-5 w-5 items-center justify-center rounded-full" style="background-color: blue; color: white; font-size: 0.75rem;">
  ${counts[date]}
</span>`);
          btn.append(badge);
        }
      });
    },
    error: function(xhr, status, err) {
      console.error("Error fetching counts:", err);
    }
  });
}

// Save todos
$('#todoForm').on('submit', function(e) {  
  e.preventDefault();  

  let todo_date = $('#todoDate').val();  
  let todo_text = $('input[name="todo_text[]"]').map(function(){ return $(this).val(); }).get();  

  if(todo_text.length === 0 || todo_text.every(t => t.trim() === '')) {
    alert("Please enter at least one task");
    return;
  }

  $.ajax({  
    url: 'supporting/save-todo.php',  
    type: 'POST',  
    data: { todo_date: todo_date, todo_text: todo_text },  
    dataType: 'json',  
    success: function(res) {  
      if (res.status === "success") {  
        closeModal();  
        let d = new Date(todo_date);  
        let month = d.getFullYear() + '-' + String(d.getMonth()+1).padStart(2,'0');  
        loadCounts(month);  
        loadTodos(todo_date);  
      } else {  
        alert(res.message || "Failed to save");  
      }  
    },  
    error: function(xhr, status, err) {  
      console.error("Response text:", xhr.responseText);  
      alert("Server error while saving: " + xhr.responseText);  
    }  
  });  
});  
</script>




</div>        
        
        </div>
        
        
        
        <div class="mt-3 px-3">


<h2
  class="text-xs-plus font-medium tracking-wide text-slate-700 line-clamp-1 dark:text-navy-100"
>
Absent Staff
</h2>
<div class="grid grid-cols-1 gap-4 sm:grid-cols-2 sm:gap-5 lg:gap-6">

<?php


// Today’s date
$day   = date("j");
$month = date("n");
$year  = date("Y");

// Fetch absent OR leave staff
$sql = "SELECT s.staff_id, s.staff_name, s.staff_surname, s.staff_role, s.staff_image, sa.status 
        FROM staff_attendance sa
        INNER JOIN staff s ON s.staff_id = sa.staff_id
        WHERE sa.day = ? AND sa.month = ? AND sa.year = ? 
        AND (sa.status = 'absent' OR sa.status = 'leave')";

$stmt = $conn->prepare($sql);
$stmt->bind_param("iii", $day, $month, $year);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        ?>
        <div class="card items-center justify-between lg:flex-row">
          <div class="flex flex-col items-center p-4 text-center sm:p-5 lg:flex-row lg:space-x-4 lg:text-left">
            <div class="avatar size-18 lg:h-12 lg:w-12">
              <img class="rounded-full" src="<?= !empty($row['staff_image']) ? $row['staff_image'] : 'default.jpg'; ?>" alt="avatar" />
            </div>
            <div class="mt-2 lg:mt-0">
              <div class="flex items-center justify-center space-x-1">
                <h4 class="text-base font-medium text-slate-700 line-clamp-1 dark:text-navy-100">
                  <?= htmlspecialchars($row['staff_name'] . " " . $row['staff_surname']); ?>
                </h4>
                <button
                  class="btn hidden h-6 rounded-full px-2 text-xs font-medium 
                  <?= $row['status'] == 'absent' ? 'text-red-600 bg-red-100' : 'text-yellow-600 bg-yellow-100'; ?>
                  hover:bg-opacity-75 focus:bg-opacity-75 active:bg-opacity-90 
                  lg:inline-flex">
                  <?= ucfirst($row['status']); ?>
                </button>
              </div>
              <p class="text-xs-plus"><?= htmlspecialchars($row['staff_role']); ?></p>
            </div>
          </div>
        </div>
        <?php
    }
} else {
    echo "<p class='text-center text-slate-500'>No staff absent or on leave today.</p>";
}

$stmt->close();

?>

</div>



        </div>


<div class="mt-3 px-3">
<h2
  class="text-xs-plus font-medium tracking-wide text-slate-700 line-clamp-1 dark:text-navy-100"
>
Transportation Arrival
</h2>
<div
  class="mt-3 grid grid-cols-1 gap-4 px-4 sm:gap-5 sm:px-5 lg:grid-cols-2"
>
<?php

$today = date("Y-m-d");

// 1. Total buses (from buses table)
$total_sql = "SELECT COUNT(*) as total_buses FROM buses WHERE status='active'";
$total_result = $conn->query($total_sql)->fetch_assoc();
$total_buses = $total_result['total_buses'] ?? 0;

// 2. Completed buses (from tracking table for today)
$completed_sql = "SELECT COUNT(DISTINCT bus_id) as completed_buses
                  FROM bus_tracking
                  WHERE track_date = ? AND status='completed'";
$stmt = $conn->prepare($completed_sql);
$stmt->bind_param("s", $today);
$stmt->execute();
$completed_result = $stmt->get_result()->fetch_assoc();
$completed_buses = $completed_result['completed_buses'] ?? 0;

// 3. Percentage
$percentage = ($total_buses > 0) ? round(($completed_buses / $total_buses) * 100) : 0;

// 4. Fetch buses NOT completed today
$not_arrived_sql = "SELECT b.bus_id, b.bus_number, s.staff_name, s.staff_surname
                    FROM buses b
                    INNER JOIN staff s ON b.driver_id = s.staff_id
                    LEFT JOIN (
                        SELECT bus_id, status 
                        FROM bus_tracking 
                        WHERE track_date = ?
                    ) bt ON b.bus_id = bt.bus_id
                    WHERE bt.bus_id IS NULL OR bt.status != 'completed'";
$stmt = $conn->prepare($not_arrived_sql);
$stmt->bind_param("s", $today);
$stmt->execute();
$not_arrived_result = $stmt->get_result();
?>

<!-- Progress Card -->
<div class="rounded-lg border border-slate-150 p-4 dark:border-navy-600">
  <div class="flex justify-between">
    <div>
      <span class="text-2xl font-medium text-slate-700 dark:text-navy-100">
        <?= $completed_buses ?>/<?= $total_buses ?>
      </span>
      <span class="text-xs">Buses</span>
    </div>
    <p class="text-xs-plus">Reached Destination</p>
  </div>

  <div class="progress mt-3 h-1.5 bg-slate-150 dark:bg-navy-500">
    <div class="is-active relative overflow-hidden rounded-full bg-success"
         style="width: <?= $percentage ?>%">
    </div>
  </div>

  <div class="mt-2 flex justify-between text-xs text-slate-400 dark:text-navy-300">
    <p>Arrival Rate</p>
    <p><?= $percentage ?>%</p>
  </div>
</div>

<!-- Not Arrived Buses -->
<div class="grid grid-cols-2 gap-4 mt-4">
<?php 
if ($not_arrived_result->num_rows > 0) {
  while ($row = $not_arrived_result->fetch_assoc()) {
$bus_initials = strtoupper(substr($row['bus_number'], 0, 2));
?>
  <div class="relative flex flex-col items-center justify-center rounded-lg border border-slate-200 p-4 dark:border-navy-500">

<div class="is-initial size-10 flex items-center justify-center rounded-full bg-info text-white ring-2 ring-white dark:ring-navy-700 font-bold text-2xl">
    <?= $bus_initials ?>
</div>
    <p class="mt-1.5 font-medium text-slate-700 line-clamp-1 dark:text-navy-100">
      <?= htmlspecialchars($row['bus_number']); ?>
    </p>
    <button class="btn mt-3 h-6 rounded-full bg-slate-150 px-3 text-xs font-medium text-slate-800 hover:bg-slate-200 dark:bg-navy-500 dark:text-navy-50">
      <?= htmlspecialchars($row['staff_name'] . " " . $row['staff_surname']); ?>
    </button>
  </div>
<?php 
  }
} else {
  echo "<p class='text-slate-500 col-span-2 text-center'>All buses reached destination ✅</p>";
}
?>
</div>

</div>  




</div>        
        <div class="mt-3 px-3">
          <h2
            class="text-xs-plus font-medium tracking-wide text-slate-700 line-clamp-1 dark:text-navy-100"
          >
            Settings
          </h2>
          <div class="mt-2 flex flex-col space-y-2">
            <label class="inline-flex items-center space-x-2">
              <input
                x-model="$store.global.isDarkModeEnabled"
                class="form-switch h-5 w-10 rounded-lg bg-slate-300 before:rounded-md before:bg-slate-50 checked:bg-slate-500 checked:before:bg-white dark:bg-navy-900 dark:before:bg-navy-300 dark:checked:bg-navy-400 dark:checked:before:bg-white"
                type="checkbox"
              />
              <span>Dark Mode</span>
            </label>
            <label class="inline-flex items-center space-x-2">
              <input
                x-model="$store.global.isMonochromeModeEnabled"
                class="form-switch h-5 w-10 rounded-lg bg-slate-300 before:rounded-md before:bg-slate-50 checked:bg-slate-500 checked:before:bg-white dark:bg-navy-900 dark:before:bg-navy-300 dark:checked:bg-navy-400 dark:checked:before:bg-white"
                type="checkbox"
              />
              <span>Monochrome Mode</span>
            </label>
          </div>
        </div>

        <div class="mt-3 px-3">
          <div class="rounded-lg bg-slate-100 p-3 dark:bg-navy-600">
            <div class="flex items-center justify-between">
              <p>
                <span
                  class="font-medium text-slate-600 dark:text-navy-100"
                  >35GB</span
                >
                of 1TB
              </p>
              <a
                href="#"
                class="text-xs-plus font-medium text-primary outline-hidden transition-colors duration-300 hover:text-primary/70 focus:text-primary/70 dark:text-accent-light dark:hover:text-accent-light/70 dark:focus:text-accent-light/70"
                >Upgrade</a
              >
            </div>

            <div class="progress mt-2 h-2 bg-slate-150 dark:bg-navy-500">
              <div class="w-7/12 rounded-full bg-info"></div>
            </div>
          </div>
        </div>
        <div class="h-18"></div>
      </div>

      <div
        x-show="activeTab === 'tabProjects'"
        x-transition:enter="transition-all duration-500 easy-in-out"
        x-transition:enter-start="opacity-0 [transform:translate3d(0,1rem,0)]"
        x-transition:enter-end="opacity-100 [transform:translate3d(0,0,0)]"
        class="is-scrollbar-hidden overflow-y-auto overscroll-contain px-3 pt-1"
      >
        <div class="grid grid-cols-2 gap-3">
          <div class="rounded-lg bg-slate-100 p-3 dark:bg-navy-600">
            <div class="flex justify-between space-x-1">
              <p
                class="text-xl font-semibold text-slate-700 dark:text-navy-100"
              >
                
                
<?php


// 1. Get all syllabus completion percentages from dashboard
$sql = "SELECT value FROM dashboard
        WHERE type='syllabus'
          AND data='completed'
          AND data_type='percentage'";

$res = mysqli_query($conn, $sql);

$totalPercentage = 0;
$count = 0;

while($row = mysqli_fetch_assoc($res)){
    $percentage = floatval($row['value']);
    $totalPercentage += $percentage;
    $count++;
}

// 2. Calculate overall completed percentage (average)
$overallCompleted = ($count > 0) ? round($totalPercentage / $count, 2) : 0;

// 3. Calculate overall non-completed percentage
$overallNonCompleted = 100 - $overallCompleted;

// 4. Display results




// 1. Get class with lowest completion


// 1. Get all classes
$classSql = "SELECT class_id, class_name, division FROM classes";
$classRes = mysqli_query($conn, $classSql);

$highest = null;
$lowest = null;

while($class = mysqli_fetch_assoc($classRes)) {
    $class_id = $class['class_id'];

    // 2. Get syllabus completion percentage from dashboard
    $dashSql = "SELECT value FROM dashboard 
                WHERE type='syllabus' 
                  AND id_type='class_id' 
                  AND id_data='$class_id' 
                  AND data='completed' 
                  AND data_type='percentage'
                LIMIT 1";
    $dashRes = mysqli_query($conn, $dashSql);
    $dashRow = mysqli_fetch_assoc($dashRes);
    $percentage = isset($dashRow['value']) ? floatval($dashRow['value']) : 0;

    // 3. Track lowest
    if($lowest === null || $percentage < $lowest['percentage']){
        $lowest = [
            'class_id' => $class['class_id'],
            'class_name' => $class['class_name'],
            'division' => $class['division'],
            'percentage' => $percentage
        ];
    }

    // 4. Track highest
    if($highest === null || $percentage > $highest['percentage']){
        $highest = [
            'class_id' => $class['class_id'],
            'class_name' => $class['class_name'],
            'division' => $class['division'],
            'percentage' => $percentage
        ];
    }
}

// 5. Display results



?>

                
                
<?php echo $overallNonCompleted; ?> %
                
                
              </p>
              <svg
                xmlns="http://www.w3.org/2000/svg"
                stroke-width="1.5"
                class="size-5 text-primary dark:text-accent"
                fill="none"
                viewBox="0 0 24 24"
                stroke="currentColor"
              >
                <path
                  stroke-linecap="round"
                  stroke-linejoin="round"
                  d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"
                />
              </svg>
            </div>
            <p class="mt-1 text-xs-plus">Incomplete</p>
          </div>
          <div class="rounded-lg bg-slate-100 p-3 dark:bg-navy-600">
            <div class="flex justify-between">
              <p
                class="text-xl font-semibold text-slate-700 dark:text-navy-100"
              >
<?php echo $overallCompleted; ?> %
              </p>
              <svg
                xmlns="http://www.w3.org/2000/svg"
                class="size-5 text-success"
                fill="none"
                viewBox="0 0 24 24"
                stroke="currentColor"
              >
                <path
                  stroke-linecap="round"
                  stroke-linejoin="round"
                  stroke-width="2"
                  d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"
                />
              </svg>
            </div>
            <p class="mt-1 text-xs-plus">Completed</p>
          </div>
          <div class="rounded-lg bg-slate-100 p-3 dark:bg-navy-600">
            <div class="flex justify-between">
              <p
                class="text-xl font-semibold text-slate-700 dark:text-navy-100"
              >
<?php
if($lowest){
    echo "Class {$lowest['class_name']} - {$lowest['division']}";
}

?>


              </p>

              <i class="fa fa-spinner text-base text-warning"></i>
            </div>
            <p class="mt-1 text-xs-plus">Lowest Syllabus</p>
          </div>
          <div class="rounded-lg bg-slate-100 p-3 dark:bg-navy-600">
            <div class="flex justify-between">
              <p
                class="text-xl font-semibold text-slate-700 dark:text-navy-100"
              >

<?php  

if($highest){
    echo "Class {$highest['class_name']} - {$highest['division']}";
}

?>
              </p>

              <i class="fa-solid fa-list-check text-base text-info"></i>
            </div>
            <p class="mt-1 text-xs-plus">Highest Syllabus</p>
          </div>
        </div>

<?php


// 1. Get all classes
$classSql = "SELECT * FROM classes";
$classRes = mysqli_query($conn, $classSql);

while ($class = mysqli_fetch_assoc($classRes)) {
    $class_id = $class['class_id'];
    $class_name = $class['class_name'];
    $division = $class['division'];
    // 2. Get syllabus completion percentage from dashboard
    $dashSql = "SELECT value FROM dashboard 
                WHERE type='syllabus' 
                  AND id_type='class_id' 
                  AND id_data='$class_id' 
                  AND data='completed' 
                  AND data_type='percentage'
                LIMIT 1";
    $dashRes = mysqli_query($conn, $dashSql);
    $dashRow = mysqli_fetch_assoc($dashRes);
    $percentage = isset($dashRow['value']) ? $dashRow['value'] : 0; // default 0

    // 3. Convert percentage to tailwind width (e.g., 25% -> w-3/12)
    $widthClass = ($percentage >= 100) ? "w-full" : "w-" . round($percentage / 8.33) . "/12"; // 100/12 ~ 8.33

    ?>
    <div class="mt-4 rounded-lg border border-slate-150 p-3 dark:border-navy-600">
        <div class="flex items-center space-x-3">



<div class="is-initial size-16 flex items-center justify-center rounded-full bg-info text-white ring-2 ring-white dark:ring-navy-700 font-bold text-2xl">
    <?= strtoupper($class_name . $division) ?>
</div>
            <div>
                <p class="font-medium leading-snug text-slate-700 dark:text-navy-100">
                    <?= htmlspecialchars($class_name) . ' - ' . htmlspecialchars($division)?>
                </p>
                <p class="text-xs text-slate-400 dark:text-navy-300">
                    Updated at <?= date("d M") ?>
                </p>
            </div>
        </div>

        <div class="mt-4">
            <div class="progress h-1.5 bg-slate-150 dark:bg-navy-500">
                <div class="rounded-full bg-primary dark:bg-accent" style="width: <?= $percentage ?>%;"></div>
            </div>
            <p class="mt-2 text-right text-xs-plus font-medium text-primary dark:text-accent-light">
                <?= $percentage ?>%
            </p>
        </div>

        <div class="mt-3 flex items-center justify-between space-x-2">

        </div>
    </div>
<?php } ?>

        <div class="h-18"></div>
      </div>

      <div
        x-show="activeTab === 'tabActivity'"
        x-transition:enter="transition-all duration-500 easy-in-out"
        x-transition:enter-start="opacity-0 [transform:translate3d(0,1rem,0)]"
        x-transition:enter-end="opacity-100 [transform:translate3d(0,0,0)]"
        class="is-scrollbar-hidden overflow-y-auto overscroll-contain pt-1"
      >
        
        
        
        <div
          class="mx-3 flex flex-col items-center rounded-lg bg-slate-100 py-3 px-8 dark:bg-navy-600"
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-8 text-secondary dark:text-secondary-light"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="2"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"
            />
          </svg>

          <p class="mt-2 text-xs">Today</p>

          <p
            class="text-lg font-medium text-slate-700 dark:text-navy-100"
          >
<?php
// Today's date
$todayDay   = date("j");   // day (1–31)
$todayMonth = date("n");   // month (1–12)
$todayYear  = date("Y");   // year (YYYY)

// ✅ Overall total students (unique student_id across all classes)
$totalSql = "SELECT COUNT(DISTINCT student_id) as total 
             FROM student_attendance 
             WHERE day='$todayDay' 
               AND month='$todayMonth' 
               AND year='$todayYear'";
$totalRes = mysqli_query($conn, $totalSql);
$totalRow = mysqli_fetch_assoc($totalRes);
$overallTotal = $totalRow['total'];

// ✅ Overall present
$presentSql = "SELECT COUNT(DISTINCT student_id) as present 
               FROM student_attendance 
               WHERE day='$todayDay' 
                 AND month='$todayMonth' 
                 AND year='$todayYear'
                 AND status='present'";
$presentRes = mysqli_query($conn, $presentSql);
$presentRow = mysqli_fetch_assoc($presentRes);
$overallPresent = $presentRow['present'];

// ✅ Overall absent
$absentSql = "SELECT COUNT(DISTINCT student_id) as absent 
              FROM student_attendance 
              WHERE day='$todayDay' 
                AND month='$todayMonth' 
                AND year='$todayYear'
                AND status='absent'";
$absentRes = mysqli_query($conn, $absentSql);
$absentRow = mysqli_fetch_assoc($absentRes);
$overallAbsent = $absentRow['absent'];

// ✅ Overall half_day
$halfSql = "SELECT COUNT(DISTINCT student_id) as half_day 
            FROM student_attendance 
            WHERE day='$todayDay' 
              AND month='$todayMonth' 
              AND year='$todayYear'
              AND status='half_day'";
$halfRes = mysqli_query($conn, $halfSql);
$halfRow = mysqli_fetch_assoc($halfRes);
$overallHalfDay = $halfRow['half_day'];

// ✅ Overall percentage (if you want half_day = 0.5 present, adjust formula)
$overallPercentage = ($overallTotal > 0) 
    ? round((($overallPresent + ($overallHalfDay * 0.5)) / $overallTotal) * 100) 
    : 0;

// Example display
echo "<div class='mt-6 p-4 bg-slate-100 rounded-lg'>
        <h3 class='font-bold text-slate-700'>Overall Attendance (".date("d M").")</h3>
        <p>Total Students: $overallTotal</p>
        <p>Present: $overallPresent</p>
        <p>Absent: $overallAbsent</p>
        <p>Half Day: $overallHalfDay</p>
        <p>Effective Present %: $overallPercentage%</p>
      </div>";
?>
          </p>

<!-- Overall Attendance Progress Bar -->
<div class="mt-6 p-4 bg-slate-100 rounded-lg">
    <h3 class="font-bold text-slate-700 dark:text-navy-100">
        Overall Attendance (<?= date("d M") ?>)
    </h3>

    <div class="progress mt-3 h-2 bg-secondary/15 dark:bg-secondary-light/25">
        <div class="is-active relative overflow-hidden rounded-full bg-secondary dark:bg-secondary-light"
             style="width: <?= $overallPercentage ?>%;">
        </div>
    </div>

    <p class="mt-2 text-right text-xs-plus font-medium text-secondary dark:text-secondary-light">
        <?= $overallPercentage ?>% (<?= $overallPresent ?> Present, <?= $overallAbsent ?> Absent, <?= $overallHalfDay ?> Half Day)
    </p>
</div>

          <button
            class="btn mt-5 space-x-2 rounded-full border border-slate-300 px-3 text-xs-plus font-medium text-slate-700 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90"
          >
            <svg
              xmlns="http://www.w3.org/2000/svg"
              class="size-4.5 text-slate-400 dark:text-navy-300"
              fill="none"
              viewBox="0 0 24 24"
              stroke="currentColor"
              stroke-width="2"
            >
              <path
                stroke-linecap="round"
                stroke-linejoin="round"
                d="M15 13l-3 3m0 0l-3-3m3 3V8m0 13a9 9 0 110-18 9 9 0 010 18z"
              />
            </svg>
            <span> Print Attendance</span>
          </button>
        </div>
<?php
// 1. Get all classes
$classSql = "SELECT * FROM classes";
$classRes = mysqli_query($conn, $classSql);

while ($class = mysqli_fetch_assoc($classRes)) {
    $class_name = $class['class_name'];
    $division = $class['division'];

    // Today's date
    $todayDay   = date("j");   // day (1–31)
    $todayMonth = date("n");   // month (1–12)
    $todayYear  = date("Y");   // year (YYYY)

    // 2. Get total students in this class/division (for today)
    $totalSql = "SELECT COUNT(DISTINCT student_id) as total 
                 FROM student_attendance 
                 WHERE class='$class_name' 
                   AND division='$division' 
                   AND day='$todayDay' 
                   AND month='$todayMonth' 
                   AND year='$todayYear'";
    $totalRes = mysqli_query($conn, $totalSql);
    $totalRow = mysqli_fetch_assoc($totalRes);
    $totalStudents = $totalRow['total'];

    // 3. Get present students
    $presentSql = "SELECT COUNT(DISTINCT student_id) as present 
                   FROM student_attendance 
                   WHERE class='$class_name' 
                     AND division='$division' 
                     AND day='$todayDay' 
                     AND month='$todayMonth' 
                     AND year='$todayYear'
                     AND status='present'";
    $presentRes = mysqli_query($conn, $presentSql);
    $presentRow = mysqli_fetch_assoc($presentRes);
    $presentStudents = $presentRow['present'];

    // 4. Calculate percentage
    $presentPercentage = ($totalStudents > 0) ? round(($presentStudents / $totalStudents) * 100) : 0;
    ?>
    
    <!-- Card -->
    <div class="mt-4 rounded-lg border border-slate-150 p-3 dark:border-navy-600">
        <div class="flex items-center space-x-3">
            <div class="is-initial size-16 flex items-center justify-center rounded-full bg-info text-white ring-2 ring-white dark:ring-navy-700 font-bold text-2xl">
                <?= strtoupper($class_name . $division) ?>
            </div>
            <div>
                <p class="font-medium leading-snug text-slate-700 dark:text-navy-100">
                    <?= htmlspecialchars($class_name) . ' - ' . htmlspecialchars($division)?>
                </p>
                <p class="text-xs text-slate-400 dark:text-navy-300">
                    Attendance for <?= date("d M") ?>
                </p>
            </div>
        </div>

        <!-- Attendance Progress -->
        <div class="mt-4">
            <div class="progress h-1.5 bg-slate-150 dark:bg-navy-500">
                <div class="rounded-full bg-primary dark:bg-accent" style="width: <?= $presentPercentage ?>%;"></div>
            </div>
            <p class="mt-2 text-right text-xs-plus font-medium text-primary dark:text-accent-light">
                <?= $presentPercentage ?>% (<?= $presentStudents ?>/<?= $totalStudents ?>)
            </p>
        </div>
    </div>

<?php } ?>

        <div class="h-18"></div>
      </div>

      <div
        class="pointer-events-none absolute bottom-4 flex w-full justify-center"
      >
        <div
          class="pointer-events-auto mx-auto flex space-x-1 rounded-full border border-slate-150 bg-white px-4 py-0.5 shadow-lg dark:border-navy-700 dark:bg-navy-900"
        >
          <button
            @click="activeTab = 'tabHome'"
            :class="activeTab === 'tabHome' && 'text-primary dark:text-accent'"
            class="btn h-9 rounded-full py-0 px-4 hover:bg-slate-300/20 hover:text-primary focus:bg-slate-300/20 focus:text-primary active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:hover:text-accent dark:focus:bg-navy-300/20 dark:focus:text-accent dark:active:bg-navy-300/25"
          >
            <svg
              x-show="activeTab === 'tabHome'"
              xmlns="http://www.w3.org/2000/svg"
              class="size-5 shrink-0"
              viewBox="0 0 20 20"
              fill="currentColor"
            >
              <path
                d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z"
              />
            </svg>
            <svg
              x-show="activeTab !== 'tabHome'"
              xmlns="http://www.w3.org/2000/svg"
              class="size-5 shrink-0"
              fill="none"
              viewBox="0 0 24 24"
              stroke="currentColor"
              stroke-width="1.5"
            >
              <path
                stroke-linecap="round"
                stroke-linejoin="round"
                d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"
              />
            </svg>
          </button>
          <button
            @click="activeTab = 'tabProjects'"
            :class="activeTab === 'tabProjects' && 'text-primary dark:text-accent'"
            class="btn h-9 rounded-full py-0 px-4 hover:bg-slate-300/20 hover:text-primary focus:bg-slate-300/20 focus:text-primary active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:hover:text-accent dark:focus:bg-navy-300/20 dark:focus:text-accent dark:active:bg-navy-300/25"
          >
            <svg
              x-show="activeTab === 'tabProjects'"
              xmlns="http://www.w3.org/2000/svg"
              class="size-5 shrink-0"
              viewBox="0 0 20 20"
              fill="currentColor"
            >
              <path
                fill-rule="evenodd"
                d="M3 3a1 1 0 000 2v8a2 2 0 002 2h2.586l-1.293 1.293a1 1 0 101.414 1.414L10 15.414l2.293 2.293a1 1 0 001.414-1.414L12.414 15H15a2 2 0 002-2V5a1 1 0 100-2H3zm11.707 4.707a1 1 0 00-1.414-1.414L10 9.586 8.707 8.293a1 1 0 00-1.414 0l-2 2a1 1 0 101.414 1.414L8 10.414l1.293 1.293a1 1 0 001.414 0l4-4z"
                clip-rule="evenodd"
              />
            </svg>

            <svg
              x-show="activeTab !== 'tabProjects'"
              xmlns="http://www.w3.org/2000/svg"
              class="size-5 shrink-0"
              fill="none"
              viewBox="0 0 24 24"
              stroke="currentColor"
              stroke-width="1.5"
            >
              <path
                stroke-linecap="round"
                stroke-linejoin="round"
                d="M7 12l3-3 3 3 4-4M8 21l4-4 4 4M3 4h18M4 4h16v12a1 1 0 01-1 1H5a1 1 0 01-1-1V4z"
              />
            </svg>
          </button>
          <button
            @click="activeTab = 'tabActivity'"
            :class="activeTab === 'tabActivity' && 'text-primary dark:text-accent'"
            class="btn h-9 rounded-full py-0 px-4 hover:bg-slate-300/20 hover:text-primary focus:bg-slate-300/20 focus:text-primary active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:hover:text-accent dark:focus:bg-navy-300/20 dark:focus:text-accent dark:active:bg-navy-300/25"
          >
            <svg
              x-show="activeTab ===  'tabActivity'"
              xmlns="http://www.w3.org/2000/svg"
              class="size-5 shrink-0"
              viewBox="0 0 20 20"
              fill="currentColor"
            >
              <path
                fill-rule="evenodd"
                d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z"
                clip-rule="evenodd"
              />
            </svg>
            <svg
              x-show="activeTab !==  'tabActivity'"
              xmlns="http://www.w3.org/2000/svg"
              class="size-5 shrink-0"
              fill="none"
              viewBox="0 0 24 24"
              stroke="currentColor"
              stroke-width="1.5"
            >
              <path
                stroke-linecap="round"
                stroke-linejoin="round"
                d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"
              />
            </svg>
          </button>
        </div>
      </div>
    </div>
  </div>
</div>