
<div x-data="{ 
    showModal: <?= $message ? 'true' : 'false' ?>, 
    message: '<?= addslashes($message) ?>', 
    type: '<?= $messageType ?>' 
 }"
 x-init="
    $watch('showModal', value => {
      if (!value && type === 'success') {
        document.getElementById('studentForm').reset();
        document.getElementById('grNumber').value = '<?= $nextGR ?>';
      }
    });
 ">

<!-- Internal Styles -->
<style>
  .modal-overlay {
    background: rgba(15, 23, 42, 0.7);
    backdrop-filter: blur(4px);
  }
  .modal-card {
    width: 100%;
    max-width: 28rem;
    border-radius: 1rem;
    background: #fff;
    box-shadow: 0 25px 50px -12px rgba(0,0,0,0.25);
    transition: all 0.3s ease;
  }
  .modal-header {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding: 2rem 1.5rem;
  }
  .icon-circle {
    display: flex;
    align-items: center;
    justify-content: center;
    height: 5rem;
    width: 5rem;
    border-radius: 50%;
  }
  .success-bg { background: #dcfce7; color: #16a34a; }
  .error-bg { background: #fee2e2; color: #dc2626; }
  .modal-title {
    margin-top: 1rem;
    font-size: 1.5rem;
    font-weight: 700;
    letter-spacing: 0.5px;
  }
  .success-text { color: #16a34a; }
  .error-text { color: #dc2626; }
  .modal-message {
    margin-top: 0.5rem;
    text-align: center;
    color: #475569;
    line-height: 1.6;
  }
  .modal-footer {
    display: flex;
    justify-content: center;
    gap: 0.75rem;
    padding: 1rem 1.5rem;
    border-top: 1px solid #e2e8f0;
  }
  .btmnsu {
    padding: 0.5rem 1.25rem;
    border-radius: 0.5rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s;
    box-shadow: 0 2px 6px rgba(0,0,0,0.15);
    color: #fff;
  }
  .btmnsu-success { background: #16a34a; }
  .btmnsu-success:hover { background: #15803d; }
  .btmnsu-error { background: #dc2626; }
  .btmnsu-error:hover { background: #b91c1c; }
</style>

<template x-teleport="body">
  <div class="fixed inset-0 z-[200] flex items-center justify-center px-4 py-6 sm:px-5"
       x-show="showModal"
       role="dialog"
       @keydown.window.escape="showModal = false">

    <!-- Overlay -->
    <div class="absolute inset-0 modal-overlay"
         @click="showModal = false"
         x-show="showModal"
         x-transition.opacity></div>

    <!-- Modal -->
    <div class="relative modal-card"
         x-show="showModal"
         x-transition.scale.opacity>

      <!-- Header -->
      <div class="modal-header">
        <div class="icon-circle"
             :class="type === 'success' ? 'success-bg' : 'error-bg'">
          <svg x-show="type === 'success'" xmlns="http://www.w3.org/2000/svg" 
               class="h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                  d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
          </svg>
          <svg x-show="type === 'error'" xmlns="http://www.w3.org/2000/svg" 
               class="h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                  d="M6 18L18 6M6 6l12 12"/>
          </svg>
        </div>

        <h2 class="modal-title"
            :class="type === 'success' ? 'success-text' : 'error-text'">
          <span x-text="type === 'success' ? 'Success!' : 'Error!'"></span>
        </h2>

        <p class="modal-message" x-text="message"></p>
      </div>

      <!-- Footer -->
      <div class="modal-footer">
        <button @click="showModal = false"
                class="btmnsu"
                :class="type === 'success' ? 'btmnsu-success' : 'btmnsu-error'">
          Close
        </button>
      </div>
    </div>
  </div>
</template>
</div>