<?php
session_start();
require_once "../core/db-connect91.php";

header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);
$staff_id = $_SESSION['staff_id'] ?? 0;

$bus_id   = intval($data['bus_id'] ?? 0);
$lat      = $data['latitude'] ?? null;
$lng      = $data['longitude'] ?? null;
$action   = $data['action'] ?? "";

if (!$bus_id || !$lat || !$lng) {
    echo json_encode(["success" => false, "message" => "Invalid data"]);
    exit;
}

// ✅ Remove past tracking data for this bus (only if not today)
$deleteSql = "DELETE FROM bus_tracking WHERE bus_id = ? AND track_date < CURDATE()";
$deleteStmt = $conn->prepare($deleteSql);
$deleteStmt->bind_param("i", $bus_id);
$deleteStmt->execute();
$deleteStmt->close();

// ✅ Now insert based on action
if ($action === "start") {
    $sql = "INSERT INTO bus_tracking 
        (bus_id, latitude, longitude, track_date, trip_start_time, status) 
        VALUES (?, ?, ?, CURDATE(), CURTIME(), 'running')";
} elseif ($action === "track") {
    $sql = "INSERT INTO bus_tracking 
        (bus_id, latitude, longitude, track_date, status) 
        VALUES (?, ?, ?, CURDATE(), 'running')";
} elseif ($action === "stop") {
    $sql = "INSERT INTO bus_tracking 
        (bus_id, latitude, longitude, track_date, trip_end_time, status) 
        VALUES (?, ?, ?, CURDATE(), CURTIME(), 'completed')";
} else {
    echo json_encode(["success" => false, "message" => "Invalid action"]);
    exit;
}

$stmt = $conn->prepare($sql);
$stmt->bind_param("idd", $bus_id, $lat, $lng);

if ($stmt->execute()) {
    echo json_encode(["success" => true]);
} else {
    echo json_encode(["success" => false, "message" => $stmt->error]);
}
$stmt->close();
?>