
<?php


require_once "core/db-connect91.php";




?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
    <link rel="icon" type="image/png" href="images/favicon.png" />

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-4">
    <div
      class="grid grid-cols-2 gap-3 sm:grid-cols-3 sm:gap-5 lg:grid-cols-2"
    >
      <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-700">
        <div class="flex justify-between space-x-1">
          <p
            class="text-xl font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $total_staff_present .' / '. $total_staff; ?>
          </p>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-5 text-primary dark:text-accent"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="2"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
            />
          </svg>
        </div>
        <p class="mt-1 text-xs-plus">Staff Attendance</p>
      </div>
      <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-700">
        <div class="flex justify-between">
          <p
            class="text-xl font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $total_students_present . '/' . $total_students; ?>
          </p>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-5 text-success"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="2"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"
            />
          </svg>
        </div>
        <p class="mt-1 text-xs-plus">Student Attendance</p>
      </div>
      <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-700">
        <div class="flex justify-between">
          <p
            class="text-xl font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $total_staff_leave_requests; ?>
          </p>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-5 text-warning"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="2"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"
            />
          </svg>
        </div>
        <p class="mt-1 text-xs-plus">Staff Leave Request</p>
      </div>
      <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-700">
        <div class="flex justify-between">
          <p
            class="text-xl font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $total_student_leave_requests; ?>
          </p>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-5 text-info"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="2"
          >
            <path
              d="M9 17a2 2 0 11-4 0 2 2 0 014 0zM19 17a2 2 0 11-4 0 2 2 0 014 0z"
            />
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M13 16V6a1 1 0 00-1-1H4a1 1 0 00-1 1v10a1 1 0 001 1h1m8-1a1 1 0 01-1 1H9m4-1V8a1 1 0 011-1h2.586a1 1 0 01.707.293l3.414 3.414a1 1 0 01.293.707V16a1 1 0 01-1 1h-1m-6-1a1 1 0 001 1h1M5 17a2 2 0 104 0m-4 0a2 2 0 114 0m6 0a2 2 0 104 0m-4 0a2 2 0 114 0"
            />
          </svg>
        </div>
        <p class="mt-1 text-xs-plus"> Student Leave Request</p>
      </div>
      <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-700">
        <div class="flex justify-between space-x-1">
          <p
            class="text-xl font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $total_staff_complaints; ?>
          </p>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-5 text-secondary"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="2"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"
            />
          </svg>
        </div>
         <p class="mt-1 text-xs-plus">Staff Complaint</p>       

      </div>
      <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-700">
        <div class="flex justify-between">
          <p
            class="text-xl font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $total_student_complaints; ?>
          </p>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-5 text-error"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="2"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"
            />
          </svg>
        </div>
        <p class="mt-1 text-xs-plus">Student Complaint</p>
      </div>
    </div>
  
  


  
  
  
  
  
  
  
<div class="card mt-6">


  <div class="grid p-4 grid-cols-2 gap-3 md:grid-cols-3 lg:grid-cols-4">
<?php

$staff_id = $_SESSION['staff_id'] ?? 0;

$bus_id = 0;
$sql = "SELECT bus_id FROM buses WHERE driver_id = ? LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $staff_id);
$stmt->execute();
$stmt->bind_result($bus_id);
$stmt->fetch();
$stmt->close();
if (!empty($bus_id)) {
    // bus found


?>

  <style>
    .btn { padding:10px 15px; margin:5px; cursor:pointer; }
    .btn:disabled { opacity:0.6; cursor:not-allowed; }
    .bg-success { background:green; color:white; }
    .bg-danger { background:red; color:white; }
  </style>


<button type="button" id="startBtn" class="btn bg-success">
    Start Location
</button>
<button type="button" id="stopBtn" class="btn bg-danger" disabled>
    End Location
</button>

<script>
document.addEventListener("DOMContentLoaded", () => {
    const startBtn = document.getElementById("startBtn");
    const stopBtn  = document.getElementById("stopBtn");
    const busId    = <?php echo json_encode($bus_id); ?>;

    let trackingInterval = null;

    function getLocation(callback) {
        if (!navigator.geolocation) {
            alert("Geolocation not supported");
            return;
        }
        navigator.geolocation.getCurrentPosition(
            (pos) => callback(pos.coords.latitude, pos.coords.longitude),
            (err) => console.error("Location error", err),
            { enableHighAccuracy: true, maximumAge: 5000, timeout: 10000 }
        );
    }

    function sendLocation(action, lat, lng) {
        fetch("supporting/bus-tracking-action.php", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({
                action: action,
                bus_id: busId,
                latitude: lat,
                longitude: lng
            })
        }).then(r => r.json()).then(data => {
            if (!data.success) console.error("Server error", data.message);
        }).catch(err => console.error("Fetch error:", err));
    }

    // Start trip
    startBtn.addEventListener("click", () => {
        getLocation((lat, lng) => {
            sendLocation("start", lat, lng);

            trackingInterval = setInterval(() => {
                getLocation((lat2, lng2) => {
                    sendLocation("track", lat2, lng2);
                });
            }, 30000); // every 30s

            startBtn.disabled = true;
            stopBtn.disabled  = false;  // ✅ now Stop button is enabled
        });
    });

    // Stop trip
    stopBtn.addEventListener("click", () => {
        clearInterval(trackingInterval);
        getLocation((lat, lng) => {
            sendLocation("stop", lat, lng);
            alert("Trip Ended!");
        });

        stopBtn.disabled  = true;
        startBtn.disabled = false; // allow starting a new trip if needed
    });
});
</script>

<?php

}else{

echo "<h3>Bus is not assigned to you.</h3>";
}

?>
</div>
  
  
  
</div>
  
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>
