<?php

// Database credentials
$host = "localhost";       // Database host
$user = "samruddh_sch";            // Database username
$pass = "Patel@2002";                // Database password
$dbname = "samruddh_sch";     // Your database name
date_default_timezone_set("Asia/Kolkata");
// Create MySQLi connection
$conn = new mysqli($host, $user, $pass, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// Optional: Set character set to utf8mb4 for full Unicode support
$conn->set_charset("utf8mb4");

session_start();

$website = "https://samruddhichemicals.com/schbee/";
// Security: Limit login attempts
if (!isset($_SESSION['login_attempts'])) {
    $_SESSION['login_attempts'] = 0;
}
$max_attempts = 50;
$lockout_time = 300; // 5 minutes

if (isset($_SESSION['last_attempt']) && (time() - $_SESSION['last_attempt'] < $lockout_time) && $_SESSION['login_attempts'] >= $max_attempts) {
    die("Too many failed attempts. Please try again after 5 minutes.");
}

$error = "";

// Generate CSRF Token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}




// Check Remember Me cookie if session not active

// If user is not logged in
if (!isset($_SESSION['staff_logged_in'])) {

    if (isset($_COOKIE['remember_me'])) {

        $cookie_token = $_COOKIE['remember_me'];

        // Only fetch rows where token is set
        $sql = "SELECT staff_id, staff_username, staff_role, remember_token, remember_expiry 
                FROM staff 
                WHERE remember_token IS NOT NULL";
        $result = $conn->query($sql);

        $validLogin = false;

        while ($row = $result->fetch_assoc()) {
            // Verify cookie with stored hashed token
            if (
                password_verify($cookie_token, $row['remember_token']) &&
                strtotime($row['remember_expiry']) > time()
            ) {
                // Auto-login
                session_regenerate_id(true);
                $_SESSION['staff_logged_in'] = true;
                $_SESSION['staff_id'] = $row['staff_id'];
                $_SESSION['staff_username'] = $row['staff_username'];
                $_SESSION['staff_role'] = $row['staff_role'];

                header("Location: " . $website . "staff/" . strtolower($row['staff_role']) . "-dashboard.php");
                exit;
            }
        }

        // If cookie is invalid, redirect to login
        header("Location: " . $website . "staff/admin-login.php");
        exit;

    } else {
        // No cookie -> redirect to login
        header("Location: " . $website . "staff/admin-login.php");
        exit;
    }

}

// If user is already logged in, do nothing and continue



// Fetch service switch statuses
$switchstatus = [];
$sql = "SELECT service_name, status FROM services";
$result = mysqli_query($conn, $sql);

if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $key = strtolower($row['service_name']); // lowercase key
        $switchstatus[$key] = (int)$row['status'];
    }
    mysqli_free_result($result);
}



$school_name = "Xyz School";
$school_logo = "school.jpg";

$batch = "2025";


// Get current page
$currentPage = $_SERVER['REQUEST_URI'];

// Initialize history array if not exists
if (!isset($_SESSION['page_history'])) {
    $_SESSION['page_history'] = [];
}

// Remove current page if already in history
if (($key = array_search($currentPage, $_SESSION['page_history'])) !== false) {
    unset($_SESSION['page_history'][$key]);
}

// Add current page to beginning of array
array_unshift($_SESSION['page_history'], $currentPage);

// Keep only last 7 pages
$_SESSION['page_history'] = array_slice($_SESSION['page_history'], 0, 7);


?>