<?php
require_once "../core/db-connect91.php";
header('Content-Type: application/json'); // Tell browser this is JSON

// Use session safely
session_start();

// Receive POST data (if JSON, decode first)
$input = json_decode(file_get_contents('php://input'), true);

$leave_id = $input['leave_id'] ?? '';
$new_status = $input['status'] ?? '';
$approved_by = $_SESSION['staff_id'] ?? '1'; // default for demo/testing

$response = [];

if (!empty($leave_id)) {
    $stmt = $conn->prepare("UPDATE student_leaves SET status = ?, approved_by = ? WHERE leave_id = ?");
    $stmt->bind_param("ssi", $new_status, $approved_by, $leave_id);

    if ($stmt->execute()) {
        $response['success'] = true;
    } else {
        $response['success'] = false;
        $response['error'] = 'DB Error: ' . $stmt->error;
    }

    $stmt->close();
} else {
    $response['success'] = false;
    $response['error'] = 'Invalid leave ID';
}

$conn->close();

// Return JSON response
echo json_encode($response);
?><?php
require_once "../core/db-connect91.php";
header('Content-Type: application/json'); // Tell browser this is JSON

// Use session safely
session_start();

// Receive POST data (if JSON, decode first)
$input = json_decode(file_get_contents('php://input'), true);

$leave_id = $input['leave_id'] ?? '';
$new_status = $input['status'] ?? '';
$approved_by = $_SESSION['staff_id'] ?? '1'; // default for demo/testing

$response = [];

if (!empty($leave_id)) {
    $stmt = $conn->prepare("UPDATE student_leaves SET status = ?, approved_by = ? WHERE leave_id = ?");
    $stmt->bind_param("ssi", $new_status, $approved_by, $leave_id);

    if ($stmt->execute()) {
        $response['success'] = true;
    } else {
        $response['success'] = false;
        $response['error'] = 'DB Error: ' . $stmt->error;
    }

    $stmt->close();
} else {
    $response['success'] = false;
    $response['error'] = 'Invalid leave ID';
}

$conn->close();

// Return JSON response
echo json_encode($response);
?>