<?php
require_once "../core/db-connect91.php";    

$year = isset($_POST['year']) ? intval($_POST['year']) : date("Y");

// Income (student fees)
$sql_income = "
    SELECT MONTH(payment_date) as month, COALESCE(SUM(paid_amount),0) as income
    FROM student_fees 
    WHERE YEAR(payment_date) = $year AND payment_status IN ('partially_paid','paid')
    GROUP BY MONTH(payment_date)";
$result_income = $conn->query($sql_income);

$income_data = array_fill(1, 12, 0);
while ($row = $result_income->fetch_assoc()) {
    $income_data[intval($row['month'])] = floatval($row['income']);
}

// Expenditure (staff salaries)
$sql_exp = "
    SELECT MONTH(payment_date) as month, COALESCE(SUM(paid_amount),0) as expenditure
    FROM staff_salary_payments 
    WHERE YEAR(payment_date) = $year AND payment_status IN ('partially_paid','paid')
    GROUP BY MONTH(payment_date)";
$result_exp = $conn->query($sql_exp);

$exp_data = array_fill(1, 12, 0);
while ($row = $result_exp->fetch_assoc()) {
    $exp_data[intval($row['month'])] = floatval($row['expenditure']);
}

echo json_encode([
    "income" => array_values($income_data),
    "expenditure" => array_values($exp_data),
]);

?>