
<?php
require_once "core/db-connect91.php";
$page8 = basename($_SERVER['PHP_SELF']); // current file name

$sql = "SELECT * FROM role_access WHERE role = '$role' AND access_page = '$page8' AND access_status = 1";
$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) == 0) {
    echo "Unauthorized Access!";
    exit;
}
?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

  
  
<?php
// Fetch all staff complaints (latest first)
$sql = "SELECT * FROM staff_complaints ORDER BY complaint_id DESC";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

while ($complaint = mysqli_fetch_assoc($result)) {

    // Fetch student details
    $sqlStu = "SELECT * FROM students WHERE student_id = ?";
    $stmtStu = mysqli_prepare($conn, $sqlStu);
    mysqli_stmt_bind_param($stmtStu, "i", $complaint['student_id']);
    mysqli_stmt_execute($stmtStu);
    $student = mysqli_fetch_assoc(mysqli_stmt_get_result($stmtStu));

    // Fetch staff details
    $sqlStaff = "SELECT * FROM staff WHERE staff_id = ?";
    $stmtStaff = mysqli_prepare($conn, $sqlStaff);
    mysqli_stmt_bind_param($stmtStaff, "i", $complaint['staff_id']);
    mysqli_stmt_execute($stmtStaff);
    $staff = mysqli_fetch_assoc(mysqli_stmt_get_result($stmtStaff));
?>
    <div class="col-span-12 grid lg:col-span-8 mb-6">
        <div class="card">
            <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
                <div class="flex items-center space-x-2">
                    <div class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary">
                        <i class="fa-solid fa-user-shield"></i>
                    </div>
                    <h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">
                        Staff Complaint Details
                    </h4>
                </div>
            </div>
            <div class="space-y-4 p-4 sm:p-5">
                
                <!-- Complaint Title -->
                <label class="block">
                    <span>Complaint Title</span>
                    <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2" value="<?= htmlspecialchars($complaint['title']) ?>" disabled />
                </label>

                <!-- Complaint Description -->
                <label class="block">
                    <span>Description</span>
                    <textarea class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2" rows="3" disabled><?= htmlspecialchars($complaint['description']) ?></textarea>
                </label>

                <!-- Filed / Resolved Dates -->
                <div class="grid grid-cols-2 gap-4">
                    <label class="block">
                        <span>Filed Date</span>
                        <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2" value="<?= htmlspecialchars($complaint['filed_date']) ?>" disabled />
                    </label>
                    <label class="block">
                        <span>Resolved Date</span>
                        <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2" value="<?= htmlspecialchars($complaint['resolved_date']) ?>" disabled />
                    </label>
                </div>

                <!-- Complaint Status -->
   <form method="POST" action="">
   <input type="hidden" name="complaint_id" value="<?= $complaint['complaint_id'] ?>">
   
   <label class="block">
   <span>Status</span>
   <select name="status" class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2">
   <option value="pending" <?= $complaint['status'] === 'pending' ? 'selected' : '' ?>>Pending</option>
   <option value="reviewing" <?= $complaint['status'] === 'reviewing' ? 'selected' : '' ?>>Reviewing</option>
   <option value="resolved" <?= $complaint['status'] === 'resolved' ? 'selected' : '' ?>>Resolved</option>
    <option value="rejected" <?= $complaint['status'] === 'rejected' ? 'selected' : '' ?>>Rejected</option>  
   </select>
   </label>
   
   <button type="submit" name="update_status"
   class="mt-3 rounded-lg bg-primary px-4 py-2 text-white hover:bg-primary-dark">
   Update Status
   </button>
   </form>

                <!-- Complaint Audio -->
                <?php if (!empty($complaint['complaint_audio'])): ?>
                    <div>
                        <span>Complaint Audio</span>
                        <audio controls class="mt-2 w-full">
                            <source src="<?= htmlspecialchars($complaint['complaint_audio']) ?>" type="audio/mpeg">
                            Your browser does not support the audio element.
                        </audio>
                    </div>
                <?php endif; ?>

                <!-- STUDENT FULL DETAILS -->
                <div class="mt-4 p-3 border rounded-lg bg-slate-50">
                    <h5 class="font-semibold mb-2">Student Details (Filed Complaint)</h5>
                    <p><strong>Name:</strong> <?= htmlspecialchars($student['student_surname'] . ' ' . $student['student_name'] . ' ' . $student['student_fathername']) ?></p>
                    <p><strong>Gender:</strong> <?= htmlspecialchars($student['student_gender']) ?></p>
                    <p><strong>Birthdate:</strong> <?= htmlspecialchars($student['student_birthdate']) ?></p>
                    <p><strong>Phone:</strong> <?= htmlspecialchars($student['student_phonenumber']) ?></p>
                    <p><strong>Email:</strong> <?= htmlspecialchars($student['student_email']) ?></p>
                    <p><strong>Address:</strong> <?= htmlspecialchars($student['student_address']) ?></p>
                    <p><strong>Class:</strong> <?= htmlspecialchars($student['student_class']) ?></p>
                    <p><strong>Division:</strong> <?= htmlspecialchars($student['student_division']) ?></p>
                </div>

                <!-- STAFF FULL DETAILS -->
                <div class="mt-4 p-3 border rounded-lg bg-slate-50">
                    <h5 class="font-semibold mb-2">Staff Details (Complaint Against)</h5>
                    <p><strong>Name:</strong> <?= htmlspecialchars($staff['staff_surname'] . ' ' . $staff['staff_name'] . ' ' . $staff['staff_fathername']) ?></p>
                    <p><strong>Gender:</strong> <?= htmlspecialchars($staff['staff_gender']) ?></p>
                    <p><strong>Birthdate:</strong> <?= htmlspecialchars($staff['staff_birthdate']) ?></p>
                    <p><strong>Phone:</strong> <?= htmlspecialchars($staff['staff_phonenumber']) ?></p>
                    <p><strong>Email:</strong> <?= htmlspecialchars($staff['staff_email']) ?></p>
                    <p><strong>Address:</strong> <?= htmlspecialchars($staff['staff_address']) ?></p>
                    <p><strong>Role:</strong> <?= htmlspecialchars($staff['staff_role']) ?></p>
                    <p><strong>Status:</strong> <?= htmlspecialchars($staff['staff_status']) ?></p>
                </div>

            </div>
        </div>
    </div>
<?php
} // end while
?>
  
  
  
<?php



if (isset($_POST['update_status'])) {
    $complaint_id = intval($_POST['complaint_id']);
    $status = mysqli_real_escape_string($conn, $_POST['status']);
    $handled_by = intval($_SESSION['staff_id']); // Logged-in staff ID

    if ($status === "Resolved") {
        // Set resolved_date + handled_by_staff
        $sqlUpdate = "UPDATE staff_complaints 
                      SET status = ?, resolved_date = NOW(), handled_by_staff = ? 
                      WHERE complaint_id = ?";
        $stmtUpdate = mysqli_prepare($conn, $sqlUpdate);
        mysqli_stmt_bind_param($stmtUpdate, "sii", $status, $handled_by, $complaint_id);
    } else {
        // Update status + handled_by_staff only
        $sqlUpdate = "UPDATE staff_complaints 
                      SET status = ?, handled_by_staff = ? 
                      WHERE complaint_id = ?";
        $stmtUpdate = mysqli_prepare($conn, $sqlUpdate);
        mysqli_stmt_bind_param($stmtUpdate, "sii", $status, $handled_by, $complaint_id);
    }

    mysqli_stmt_execute($stmtUpdate);

$message = "Changed Status Successfully!";
$messageType = "success";
}
?>

  
  
  
  
  </div>
</div>
      </main>
    </div>
    
    
    
<div x-data="{ 
        showModal: <?= $message ? 'true' : 'false' ?>, 
        message: '<?= addslashes($message) ?>', 
        type: '<?= $messageType ?>' 
     }"
     x-init="
        $watch('showModal', value => {
          if (!value && type === 'success') {
            // Reset form and refresh GR
            document.getElementById('studentForm').reset();
            document.getElementById('grNumber').value = '<?= $nextGR ?>';
          }
        });
     ">
  <!-- Modal content same as before (success/error with colors) -->


  <template x-teleport="#x-teleport-target">
    <div class="fixed inset-0 z-[100] flex items-center justify-center px-4 py-6 sm:px-5"
         x-show="showModal"
         role="dialog"
         @keydown.window.escape="showModal = false">

      <!-- Overlay -->
      <div class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
           @click="showModal = false"
           x-show="showModal"
           x-transition:enter="ease-out"
           x-transition:enter-start="opacity-0"
           x-transition:enter-end="opacity-100"
           x-transition:leave="ease-in"
           x-transition:leave-start="opacity-100"
           x-transition:leave-end="opacity-0"></div>

      <!-- Modal Content -->
      <div class="scrollbar-sm relative flex max-w-lg flex-col overflow-y-auto rounded-lg px-4 py-10 text-center transition-opacity duration-300 sm:px-5"
           x-show="showModal"
           x-transition:enter="ease-out"
           x-transition:enter-start="opacity-0"
           x-transition:enter-end="opacity-100"
           x-transition:leave="ease-in"
           x-transition:leave-start="opacity-100"
           x-transition:leave-end="opacity-0"
           :class="type === 'success' ? 'bg-white dark:bg-navy-700' : 'bg-white border border-red-500 dark:bg-navy-700'">

        <!-- Icon based on type -->
        <svg x-show="type === 'success'" xmlns="http://www.w3.org/2000/svg"
             class="mx-auto inline size-28 shrink-0 text-success"
             fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>

        <svg x-show="type === 'error'" xmlns="http://www.w3.org/2000/svg"
             class="mx-auto inline size-28 shrink-0 text-red-600"
             fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M6 18L18 6M6 6l12 12"/>
        </svg>

        <div class="mt-4">
          <h2 class="text-2xl font-bold"
              :class="type === 'success' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'">
            <span x-text="type === 'success' ? 'Success!' : 'Error!'"></span>
          </h2>
          <p class="mt-2 text-slate-600 dark:text-slate-200" x-text="message"></p>

          <button @click="showModal = false"
                  class="btn mt-6 font-medium text-white"
                  :class="type === 'success' ? 'bg-success hover:bg-success-focus' : 'bg-red-600 hover:bg-red-700'">
            Close
          </button>
        </div>
      </div>
    </div>
  </template>
</div>
    
    
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>