
<?php
require_once "core/db-connect91.php";
$page8 = basename($_SERVER['PHP_SELF']); // current file name

$sql = "SELECT * FROM role_access WHERE role = '$role' AND access_page = '$page8' AND access_status = 1";
$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) == 0) {
    echo "Unauthorized Access!";
    exit;
}
?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">






<!-- Results -->
<div class="grid grid-cols-1 gap-4 sm:grid-cols-2 sm:gap-5 lg:grid-cols-3 lg:gap-6 xl:grid-cols-4 mt-6">












<?php


$staff_id = $_SESSION['staff_id'] ?? 0;
$date = new DateTime();
$day = $date->format("d");
$month = $date->format("m");
$year = $date->format("Y");


// Check if staff_edit_attendance is enabled
$serviceCheck = $conn->query("SELECT status FROM services WHERE service_name = 'staff_edit_attendance' LIMIT 1");
$allowEdit = 0;
if ($serviceCheck && $serviceCheck->num_rows > 0) {
    $rowService = $serviceCheck->fetch_assoc();
    $allowEdit = $rowService['status']; // 1 = allowed, 0 = not allowed
}
// --- 1) Check if attendance already exists for today ---
$sqlCheck = "SELECT sa.*, s.student_surname, s.student_name, s.student_fathername, s.student_gr_no 
             FROM student_attendance sa
             JOIN students s ON sa.student_id = s.student_id
             WHERE sa.day = ? AND sa.month = ? AND sa.year = ?";
$stmt = $conn->prepare($sqlCheck);
$stmt->bind_param("iii", $day, $month, $year);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    echo "<h3>Attendance Already Recorded for Today ($day-$month-$year)</h3>";
?>

<div class="mt-5">
  <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
    <table class="is-zebra w-full text-left">
      <thead>
        <tr>
          <th class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 lg:px-5">
            #
          </th>
          <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 lg:px-5">
            Status
          </th>
          <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 lg:px-5">
            Student Name
          </th>
          <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 lg:px-5">
            GR No
          </th>

          <?php if ($allowEdit == 1): ?>
          <th class="whitespace-nowrap rounded-r-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 lg:px-5">
            Action
          </th>
          <?php endif; ?>
        </tr>
      </thead>
      <tbody>
        <?php
        $count = 1;
        while ($row = $result->fetch_assoc()):
            $fullname = $row['student_surname'] . " " . $row['student_name'] . " " . $row['student_fathername'];
            $status = ucfirst($row['status']);
            $color = ($row['status'] == "present") ? "text-green-600 font-bold" : (($row['status'] == "half_day") ? "text-orange-500 font-bold" : "text-red-600 font-bold");
        ?>
        <tr>
          <td class="whitespace-nowrap rounded-l-lg px-4 py-3 sm:px-5">
            <?= $count++; ?>
          </td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5" 
          style="
          font-weight: bold; 
          color: 
          <?php 
          if ($row['status'] == 'present') {
          echo 'green';
          } elseif ($row['status'] == 'absent') {
          echo 'red';
          } elseif ($row['status'] == 'half_day') {
          echo 'orange';
          }
          ?>;
          ">
          <?= ucfirst($row['status']); ?>
          </td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5">
            <?= htmlspecialchars($fullname); ?>
          </td>
          <td class="whitespace-nowrap px-4 py-3 sm:px-5">
            <?= htmlspecialchars($row['student_gr_no']); ?>
          </td>

          <?php if ($allowEdit == 1): ?>
          <td class="whitespace-nowrap rounded-r-lg px-4 py-3 sm:px-5">
            <select class="updateStatus border rounded px-2 py-1" data-id="<?= $row['attendance_id']; ?>">
              <option value="present" <?= ($row['status'] == 'present') ? 'selected' : ''; ?>>Present</option>
              <option value="absent" <?= ($row['status'] == 'absent') ? 'selected' : ''; ?>>Absent</option>
              <option value="half_day" <?= ($row['status'] == 'half_day') ? 'selected' : ''; ?>>Half Day</option>
            </select>
          </td>
          <?php endif; ?>
        </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<?php
} else {






?>
<form id="attendanceForm" method="POST">
  <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
<?php
if (isset($result) && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
?>
    <div class="card student_card" data-id="<?= $row['student_id'] ?>" 
    data-name="<?= $row['student_name']." ".$row['student_surname'] ?>" 
    data-gr="<?= $row['student_gr_no'] ?>" 
    data-class="<?= $row['student_class'] ?>" 
    data-division="<?= $row['student_division'] ?>">
         <input type="checkbox" name="present_students[]" value="<?= $row['student_id'] ?>" class="hidden present-checkbox">       
        <div class="p-2 text-right"></div>
        <div class="flex grow flex-col items-center px-4 pb-5 sm:px-5">
            <div class="avatar size-20">
                <img class="rounded-full" src="<?= $row['student_image'] ?: 'images/200x200.png' ?>" alt="avatar"/>
            </div>
            <h3 class="pt-3 text-lg font-medium text-slate-700 dark:text-navy-100">
                <?= $row['student_name']." ".$row['student_surname'] ?>
            </h3>
            <p class="text-xs-plus"><?= $row['student_class']." - ".$row['student_division'] ?></p>
            
            <div class="inline-space mt-3 flex grow flex-wrap items-start">
                <span class="tag rounded-full bg-success/10 text-success">GR: <?= $row['student_gr_no'] ?></span>
                <span class="tag rounded-full bg-success/10 text-success">Mobile: <?= $row['student_phonenumber'] ?></span>
            </div>

            <!-- Hidden Form -->
            <form action="set-student-id.php" method="POST" id="studentForm<?= $row['student_id'] ?>" style="display:none;">
                <input type="hidden" name="student_id" value="<?= $row['student_id'] ?>">
                <input type="hidden" name="target_page" id="targetPage<?= $row['student_id'] ?>" value="">
            </form>

            <!-- Buttons -->
            <div class="mt-6 grid w-full grid-cols-1 gap-2">                
                <button type="button" 
                    class="btn bg-primary text-white"
                    onclick="
                        document.getElementById('targetPage<?= $row['student_id'] ?>').value='staff-view-student-main.php';
                        document.getElementById('studentForm<?= $row['student_id'] ?>').submit();
                    ">
                    View Profile
                </button>           


            </div>
        </div>
    </div>
<?php
    }
} else {
    echo "<p class='text-center col-span-3'>No students found.</p>";
}
?>
  </div>

  <div class="mt-6 flex justify-center">
    <button type="button" id="submitBtn" 
            class="btn bg-primary text-white px-4 py-2 rounded-lg">
      Submit Attendance
    </button>
  </div>
</form>

<!-- Confirmation Modal -->
<div id="confirmModal" class="hidden fixed inset-0 flex items-center justify-center bg-black/50 z-50">
  <div class="bg-white dark:bg-navy-700 p-6 rounded-lg shadow-lg w-96">
    <h2 class="text-lg font-bold mb-3">Confirm Attendance</h2>
    <p><b>Total Present:</b> <span id="presentCount"></span></p>
    <p><b>Total Absent:</b> <span id="absentCount"></span></p>
    <p class="mt-2 font-semibold">Absent Students:</p>
    <ul id="absentList" class="list-disc pl-5 text-red-600"></ul>

    <div class="mt-4 flex justify-end space-x-2">
<button type="button" 
    class="btn bg-error text-white"
onclick="document.getElementById('confirmModal').classList.add('hidden')"
    >
Cancel
</button>           
<button type="button" 
    class="btn bg-primary text-white"
id="finalSubmit"
    >
Final Submit
</button>           
      

    </div>
  </div>
</div>

<!-- Small CSS for outer glow when selected (does not change your HTML classes) -->
<style>
  /* Uses a dedicated selector so it doesn't affect other cards */
.student_card.student-selected {
  box-shadow: 0 0 12px 4px rgba(37, 99, 235, 0.7); /* Bright blue outer glow */
  border-color: #2563eb !important; /* Strong blue border */
  transition: box-shadow 0.3s ease, border-color 0.3s ease;
}
</style>

<script>
// --- Safe guards for missing elements ---
const submitBtn = document.getElementById('submitBtn');
const confirmModal = document.getElementById('confirmModal');
const finalSubmitBtn = document.getElementById('finalSubmit');

//
// 1) Selection toggle on card click
//    NOTE: selecting uses the existing classes and the hidden checkbox
//
document.querySelectorAll('.student_card').forEach(card => {
  // Use pointerdown/click depending on UX; click is fine here
  card.addEventListener('click', function(e) {
    // Prevent toggling when clicking internal actionable controls (buttons/links/inputs)
    if (e.target.closest('button') || e.target.closest('a') || e.target.tagName === 'INPUT') {
      return;
    }

    const checkbox = card.querySelector('.present-checkbox');
    if (!checkbox) return;

    // Toggle checkbox
    checkbox.checked = !checkbox.checked;

    // Visual feedback: keep your existing classes and also add a dedicated selected class
    card.classList.toggle('border-green-500');
    card.classList.toggle('shadow-lg');
    card.classList.toggle('student-selected');
  });
});

//
// 2) Show confirmation modal
//
if (submitBtn) {
  submitBtn.addEventListener('click', () => {
    let present = document.querySelectorAll('.present-checkbox:checked');
    let all = document.querySelectorAll('.student_card');
    let absentNames = [];

    all.forEach(card => {
      let cb = card.querySelector('.present-checkbox');
      if (!cb || !cb.checked) {
        // Use dataset name as you already set it in the HTML
        absentNames.push(card.dataset.name || 'Unknown');
      }
    });

    // Populate counts and list
    document.getElementById('presentCount').innerText = present.length;
    document.getElementById('absentCount').innerText = (all.length - present.length);

    let absentList = document.getElementById('absentList');
    absentList.innerHTML = "";
    absentNames.forEach(name => {
      let li = document.createElement("li");
      li.textContent = name;
      absentList.appendChild(li);
    });

    // Show modal
    if (confirmModal) confirmModal.classList.remove('hidden');
  });
}

//
// 3) Final submit -> submit the attendance form
//
if (finalSubmitBtn) {
  finalSubmitBtn.addEventListener('click', () => {
    const form = document.getElementById('attendanceForm');
    if (form) form.submit();
  });
}
</script>




<?php

$staff_id = $_SESSION['staff_id'] ?? 0;



if ($_SERVER['REQUEST_METHOD'] === 'POST') {


// Current date & time
date_default_timezone_set("Asia/Kolkata"); 
$date = new DateTime();
$day = $date->format("d");
$month = $date->format("m");
$year = $date->format("Y");
$currentTime = date("H:i:s");

// Fetch active students
$students = $conn->query("SELECT student_id, student_gr_no, student_class, student_division 
                          FROM students 
                          WHERE student_class = '$class_name' 
                          AND student_division = '$division' 
                          AND student_status='Active'");

$present_students = $_POST['present_students'] ?? [];

while ($s = $students->fetch_assoc()) {
    $status = in_array($s['student_id'], $present_students) ? "present" : "absent";

    $sql = "INSERT INTO student_attendance 
            (student_id, student_gr_no, day, month, year, status, class, division, batch, `timestamp`, recorded_by) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);
$stmt->bind_param("isiiisssssi", 
    $s['student_id'],       // i
    $s['student_gr_no'],    // s
    $day,                   // i
    $month,                 // i
    $year,                  // i
    $status,                // s
    $s['student_class'],    // s
    $s['student_division'], // s
    $batch,                 // s
    $currentTime,           // s
    $staff_id               // i
);
$stmt->execute();
}

echo "<script>alert('Attendance saved successfully!'); </script>";
}
}
?>





 </div>












<script>
$(document).on("change", ".updateStatus", function() {
    var attendanceId = $(this).data("id");
    var newStatus = $(this).val();

    $.ajax({
        url: "supporting/update-student-attendance.php",
        type: "POST",
        data: { id: attendanceId, new_status: newStatus },
        success: function(response) {
            alert(response);
            location.reload(); // refresh to reflect updated color/status
        },
        error: function() {
            alert("Error updating attendance");
        }
    });
});
</script>

  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>

  </body>
</html>