
<?php
require_once "core/db-connect91.php";


$student_id = $_SESSION['student_id'];

// 1. Get student's class


$classQuery = $conn->query("SELECT student_class, student_division FROM students WHERE student_id = '$student_id'");
$classRow = $classQuery->fetch_assoc();
$class = $classRow['student_class'];
$division = $classRow['student_division'];

$classQuery0 = $conn->query("SELECT class_id FROM classes WHERE class_name = '$class' AND division = '$division'");
$classRow0 = $classQuery0->fetch_assoc();
$class_id = $classRow0['class_id'];
$currentClassId = $class_id;
// 2. Fetch student marks and class average per exam
// 1. Get all exams for the class
$sqlExams = "
    SELECT exam_id, exam_name, start_date
    FROM exam_schedule
    WHERE class_id = '$class_id'
    ORDER BY start_date ASC
";
$examsResult = $conn->query($sqlExams);

$examNames = [];
$studentMarks = [];
$classAvgMarks = [];

$totalStudentMarks = 0;
$totalClassMarks = 0;
$examCount = 0;

while($exam = $examsResult->fetch_assoc()) {
    $examId = $exam['exam_id'];
    $examNames[] = $exam['exam_name'];

    // 2. Get student marks for this exam
    $sqlStudent = "
        SELECT AVG(marks_obtained) AS student_marks
        FROM exam_results
        WHERE exam_id = '$examId' AND student_id = '$student_id'
    ";
    $studentResult = $conn->query($sqlStudent);
    $studentRow = $studentResult->fetch_assoc();
    $studentMark = (float)($studentRow['student_marks'] ?? 0);
    $studentMarks[] = $studentMark;
    $totalStudentMarks += $studentMark;

    // 3. Get class average for this exam
    $sqlClassAvg = "
        SELECT AVG(marks_obtained) AS class_avg_marks
        FROM exam_results
        WHERE exam_id = '$examId'
    ";
    $classResult = $conn->query($sqlClassAvg);
    $classRow = $classResult->fetch_assoc();
    $classAvgMark = (float)($classRow['class_avg_marks'] ?? 0);
    $classAvgMarks[] = $classAvgMark;
    $totalClassMarks += $classAvgMark;

    $examCount++;
}

// 4. Calculate overall averages
$studentOverallAvg = $examCount > 0 ? round($totalStudentMarks / $examCount, 2) : 0;
$classOverallAvg = $examCount > 0 ? round($totalClassMarks / $examCount, 2) : 0;





$currentStudentId = $_SESSION['student_id'];

// Attendance summary query
$attendanceQuery = "
    SELECT 
        COUNT(*) AS total_records,
        SUM(CASE WHEN status='present' THEN 1 ELSE 0 END) AS present_count,
        SUM(CASE WHEN status='absent' THEN 1 ELSE 0 END) AS absent_count,
        SUM(CASE WHEN status='half_day' THEN 1 ELSE 0 END) AS half_day_count
    FROM student_attendance
    WHERE student_id = '$currentStudentId' AND batch = '$batch'
";

$attendanceResult = $conn->query($attendanceQuery);
$attendanceData = $attendanceResult->fetch_assoc();

// Assign variables with new names
$totalRecords = $attendanceData['total_records'];
$presentDays = $attendanceData['present_count'];
$absentDays = $attendanceData['absent_count'];
$halfDays = $attendanceData['half_day_count'];

// Calculate attendance percentage (half-day counts as 0.5)
$attendancePercent = 0;
if ($totalRecords > 0) {
    $weightedPresence = $presentDays + ($halfDays * 0.5);
    $attendancePercent = round(($weightedPresence / $totalRecords) * 100, 2);
}







$currentStudentId = $_SESSION['student_id'];



// 2. Fetch student average marks and class average marks per subject
$sql = "
    SELECT 
        esub.subject_name,
        ROUND(AVG(CASE WHEN er.student_id = '$currentStudentId' THEN er.marks_obtained END),2) AS student_avg,
        ROUND(AVG(er.marks_obtained),2) AS class_avg
    FROM exam_results er
    INNER JOIN exam_subjects esub ON esub.exam_subject_id = er.exam_subject_id
    INNER JOIN exam_schedule es ON es.exam_id = esub.exam_id
    WHERE es.class_id = '$currentClassId'
    GROUP BY esub.subject_name
    ORDER BY esub.subject_name ASC
";

$result = $conn->query($sql);

$subjectNames = [];
$studentSubjectAvg = [];
$classSubjectAvg = [];

while($row = $result->fetch_assoc()){
    $subjectNames[] = $row['subject_name'];
    $studentSubjectAvg[] = (float)$row['student_avg'];
    $classSubjectAvg[] = (float)$row['class_avg'];
}



// 1️⃣ Fetch data from student_analysis
$analysisQuery = $conn->prepare("
    SELECT *
    FROM student_analysis
    WHERE student_id = ? AND batch = ?
    LIMIT 1
");
$analysisQuery->bind_param("is", $student_id, $batch);
$analysisQuery->execute();
$analysisResult = $analysisQuery->get_result();

if ($analysisResult->num_rows > 0) {
    $analysisData = $analysisResult->fetch_assoc();

    // Store in PHP variables
    $student_gr_no = $analysisData['student_gr_no'];
    $student_school_rank = $analysisData['student_school_rank'];
    $student_class_rank = $analysisData['student_class_rank'];
    $student_attendance = $analysisData['student_attendance'];
    $total_attendance = $analysisData['total_attendance'];
    $student_accuracy = $analysisData['student_accuracy'];
    $student_behavior = $analysisData['student_behavior'];
    $student_analysis = $analysisData['student_analysis'];
    $analysis_date = $analysisData['analysis_date'];
} else {
    echo "No analysis record found for this student.";
}

// 2️⃣ Fetch data from student_analysis_subject

?>
<?php
$studentId = $_SESSION['student_id'];
$complaints = [];

// Fetch complaints with teacher (staff) name
$sql = "
SELECT sc.*, s.staff_name, s.staff_surname
FROM student_complaints sc
LEFT JOIN staff s ON sc.staff_id = s.staff_id
WHERE sc.student_id = '$studentId'
ORDER BY sc.filed_date DESC
";

$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $complaints[] = $row;
    }
}

// Count of complaints
$complaintCount = count($complaints);
?>


<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

  
  
<div
  class="card col-span-12 sm:col-span-7 lg:col-span-8 xl:col-span-7"
>
  <div class="my-3 flex items-center justify-between px-4">
    <h2
      class="font-medium tracking-wide text-slate-700 dark:text-navy-100"
    >
Exam Analysis
    </h2>
    <div
      x-data="usePopper({placement:'bottom-end',offset:4})"
      @click.outside="isShowPopper && (isShowPopper = false)"
      class="inline-flex"
    >
      <button
        x-ref="popperRef"
        @click="isShowPopper = !isShowPopper"
        class="btn -mr-1.5 size-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
      >
        <svg
          xmlns="http://www.w3.org/2000/svg"
          class="size-5"
          fill="none"
          viewBox="0 0 24 24"
          stroke="currentColor"
          stroke-width="2"
        >
          <path
            stroke-linecap="round"
            stroke-linejoin="round"
            d="M5 12h.01M12 12h.01M19 12h.01M6 12a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0z"
          />
        </svg>
      </button>

      <div
        x-ref="popperRoot"
        class="popper-root"
        :class="isShowPopper && 'show'"
      >
        <div
          class="popper-box rounded-md border border-slate-150 bg-white py-1.5 font-inter dark:border-navy-500 dark:bg-navy-700"
        >
          <ul>
            <li>
              <a
                href="#"
                class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                >Action</a
              >
            </li>
            <li>
              <a
                href="#"
                class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                >Another Action</a
              >
            </li>
            <li>
              <a
                href="#"
                class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                >Something else</a
              >
            </li>
          </ul>
          <div
            class="my-1 h-px bg-slate-150 dark:bg-navy-500"
          ></div>
          <ul>
            <li>
              <a
                href="#"
                class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                >Separated Link</a
              >
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>
  <div class="mt-3 px-3">
<div id="marksChart"></div>
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>

<script>
var options = {
    chart: {
        type: 'line',
        height: 400,
        toolbar: { show: false }, // Hide all chart toolbar icons
        zoom: { enabled: false }, // Disable zoom on click/drag
        selection: { enabled: false } // Disable selection/dragging
    },
    series: [
        {
            name: 'Student Marks',
            data: <?php echo json_encode($studentMarks); ?>,
            color: '#007bff'
        },
        {
            name: 'Class Average Marks',
            data: <?php echo json_encode($classAvgMarks); ?>,
            color: '#ff7f0e'
        }
    ],
    xaxis: {
        categories: <?php echo json_encode($examNames); ?>,
        title: { text: 'Exams' }
    },
    yaxis: {
        title: { text: 'Marks' },
        min: 0,
        labels: {
            formatter: function (val) {
                return Math.round(val); // Y-axis shows 100, 200, 300
            }
        }
    },
    stroke: {
        curve: 'smooth',
        width: 3
    },
    markers: {
        size: 5
    },
    tooltip: {
        y: {
            formatter: function(val) {
                return val.toFixed(2) + " marks"; // Tooltip shows full decimal marks
            }
        }
    },

};
var chart = new ApexCharts(document.querySelector("#marksChart"), options);
chart.render();
</script>
  </div>
  
<div class="grid grid-cols-2 my-3 gap-3 px-4">
  <div class="rounded-lg bg-slate-100 p-3 dark:bg-navy-600">
    <div class="flex justify-between space-x-1">
      <p
        class="text-xl font-semibold text-slate-700 dark:text-navy-100"
      >
<?php echo $studentOverallAvg; ?>
      </p>
      <svg
        xmlns="http://www.w3.org/2000/svg"
        stroke-width="1.5"
        class="size-5 text-primary dark:text-accent"
        fill="none"
        viewBox="0 0 24 24"
        stroke="currentColor"
      >
        <path
          stroke-linecap="round"
          stroke-linejoin="round"
          d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"
        />
        <path
          stroke-linecap="round"
          stroke-linejoin="round"
          d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"
        />
      </svg>
    </div>
    <p class="mt-1 text-xs-plus">Student Overall Average</p>
  </div>
  <div class="rounded-lg bg-slate-100 p-3 dark:bg-navy-600">
    <div class="flex justify-between">
      <p
        class="text-xl font-semibold text-slate-700 dark:text-navy-100"
      >
<?php echo $classOverallAvg; ?>
      </p>
      <svg
        xmlns="http://www.w3.org/2000/svg"
        class="size-5 text-success"
        fill="none"
        viewBox="0 0 24 24"
        stroke="currentColor"
      >
        <path
          stroke-linecap="round"
          stroke-linejoin="round"
          d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"
        />
      </svg>
    </div>
    <p class="mt-1 text-xs-plus">Class Overall Average</p>
  </div>
</div>
</div>
 
 
 
  
  <div
  class="card mt-3 col-span-12 sm:col-span-7 lg:col-span-8 xl:col-span-7"
  >
  <div class="my-3 flex items-center justify-between px-4">
    <h2
      class="font-medium tracking-wide text-slate-700 dark:text-navy-100"
    >
  Exam Analysis
    </h2>
    <div
      x-data="usePopper({placement:'bottom-end',offset:4})"
      @click.outside="isShowPopper && (isShowPopper = false)"
      class="inline-flex"
    >
      <button
        x-ref="popperRef"
        @click="isShowPopper = !isShowPopper"
        class="btn -mr-1.5 size-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
      >
        <svg
          xmlns="http://www.w3.org/2000/svg"
          class="size-5"
          fill="none"
          viewBox="0 0 24 24"
          stroke="currentColor"
          stroke-width="2"
        >
          <path
            stroke-linecap="round"
            stroke-linejoin="round"
            d="M5 12h.01M12 12h.01M19 12h.01M6 12a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0z"
          />
        </svg>
      </button>
  
      <div
        x-ref="popperRoot"
        class="popper-root"
        :class="isShowPopper && 'show'"
      >
        <div
          class="popper-box rounded-md border border-slate-150 bg-white py-1.5 font-inter dark:border-navy-500 dark:bg-navy-700"
        >
          <ul>
            <li>
              <a
                href="#"
                class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                >Action</a
              >
            </li>
            <li>
              <a
                href="#"
                class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                >Another Action</a
              >
            </li>
            <li>
              <a
                href="#"
                class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                >Something else</a
              >
            </li>
          </ul>
          <div
            class="my-1 h-px bg-slate-150 dark:bg-navy-500"
          ></div>
          <ul>
            <li>
              <a
                href="#"
                class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                >Separated Link</a
              >
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>
  <div class="mt-3 px-3">
<div id="subjectMarksChart"></div>


<script>
var options = {
    chart: {
        type: 'bar',
        height: 400
    },
    series: [
        {
            name: 'Student Average Marks',
            data: <?php echo json_encode($studentSubjectAvg); ?>,
            color: '#007bff' // Blue
        },
        {
            name: 'Class Average Marks',
            data: <?php echo json_encode($classSubjectAvg); ?>,
            color: '#ff7f0e' // Orange
        }
    ],
    xaxis: {
        categories: <?php echo json_encode($subjectNames); ?>,
        title: { text: 'Subjects' }
    },
    yaxis: {
        title: { text: 'Marks' },
        min: 0
    },
    plotOptions: {
        bar: {
            horizontal: false,
            columnWidth: '45%',
            borderRadius: 10,           
            endingShape: 'rounded'
        }
    },
    dataLabels: {
        enabled: false
    },
    tooltip: {
        y: {
            formatter: function(val) { return val + " marks"; }
        }
    }

};

var chart = new ApexCharts(document.querySelector("#subjectMarksChart"), options);
chart.render();
</script>
  
  
  </div>
  
  <div class="grid my-3 grid-cols-2 gap-3 px-4">
  <?php
  
  $subjectQuery = $conn->prepare("
  SELECT *
  FROM student_analysis_subject
  WHERE student_id = ? AND batch = ?
  ");
  $subjectQuery->bind_param("is", $student_id, $batch);
  $subjectQuery->execute();
  $subjectResult = $subjectQuery->get_result();
  
  $subjects = [];
  if ($subjectResult->num_rows > 0) {
  while ($row = $subjectResult->fetch_assoc()) {
  $subjects[] = $row; 
  }
  }
  
  // ✅ Example usage:
  
  

  foreach ($subjects as $subject) {


  
  ?>
  
  
  
  <div class="rounded-lg bg-slate-100 p-3 dark:bg-navy-600">
    <div class="flex justify-between space-x-1">
      <p
        class="text-xl font-semibold text-slate-700 dark:text-navy-100"
      >
  <?php echo $subject['subject_class_rank']; ?>
      </p>
      <svg
        xmlns="http://www.w3.org/2000/svg"
        stroke-width="1.5"
        class="size-5 text-primary dark:text-accent"
        fill="none"
        viewBox="0 0 24 24"
        stroke="currentColor"
      >
        <path
          stroke-linecap="round"
          stroke-linejoin="round"
          d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"
        />
        <path
          stroke-linecap="round"
          stroke-linejoin="round"
          d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"
        />
      </svg>
    </div>
    <p class="mt-1 text-xs-plus"><?php echo $subject['subject_name']; ?> Rank</p>
  </div>
  <?php
  
    }
  ?>
  

  </div>
  </div>
  
  <div class="card p-4 my-3 sm:col-span-2 sm:p-5">
    
    
    
    
    <div
      class="grid grid-cols-1 gap-4 sm:grid-cols-2 sm:gap-5 lg:gap-6"
    >
      <div
        class="flex items-center space-x-4 rounded-2xl border border-slate-150 p-4 dark:border-navy-600"
      >
        <div
          class="mask is-star-2 flex size-12 items-center justify-center bg-warning/10 dark:bg-warning"
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-6 text-warning dark:text-white"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              stroke-width="2"
              d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"
            />
          </svg>
        </div>
        <div class="font-inter">
          <p
            class="text-base font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $student_class_rank; ?>
          </p>
          <p>Student Class Rank</p>
        </div>
      </div>
      <div
        class="flex items-center space-x-4 rounded-2xl border border-slate-150 p-4 dark:border-navy-600"
      >
        <div
          class="mask is-star-2 flex size-12 items-center justify-center bg-primary/10 dark:bg-accent"
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-6 text-primary dark:text-white"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              stroke-width="2"
              d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"
            />
          </svg>
        </div>
        <div class="font-inter">
          <p
            class="text-base font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $complaintCount; ?>
          </p>
          <p>Complaint</p>
        </div>
      </div>
      <div
        class="flex items-center space-x-4 rounded-2xl border border-slate-150 p-4 dark:border-navy-600"
      >
        <div
          class="mask is-star-2 flex size-12 items-center justify-center bg-secondary/10 dark:bg-secondary"
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-6 text-secondary dark:text-white"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              stroke-width="2"
              d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"
            />
          </svg>
        </div>
        <div class="font-inter">
          <p
            class="text-base font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $presentDays . ' / ' . $totalRecords; ?>
          </p>
          <p>Student Attendance</p>
        </div>
      </div>
      <div
        class="flex items-center space-x-4 rounded-2xl border border-slate-150 p-4 dark:border-navy-600"
      >
        <div
          class="mask is-star-2 flex size-12 items-center justify-center bg-success/10 dark:bg-success"
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-6 text-success dark:text-white"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              stroke-width="2"
              d="M17 8h2a2 2 0 012 2v6a2 2 0 01-2 2h-2v4l-4-4H9a1.994 1.994 0 01-1.414-.586m0 0L11 14h4a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2v4l.586-.586z"
            />
          </svg>
        </div>
        <div class="font-inter">
          <p
            class="text-base font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $attendancePercent; ?>
          </p>
          <p>Attendance Percentage</p>
        </div>
      </div>
    </div>
  </div>
  




<div x-data="{ showModal: false, showComplaintModal: false }">

  <!-- Top Button Row -->
  <div class="card mt-3 col-span-12 sm:col-span-7 lg:col-span-8 xl:col-span-7">
    <div class="my-3 flex items-center justify-between px-4">
      <button class="btn bg-primary text-white" @click="showModal = true">
        View Attendance
      </button>
      <button 
        class="btn rounded-lg bg-primary px-4 py-2 font-medium text-white hover:bg-primary-focus"
        @click="showComplaintModal = true">
        View Complaints
      </button>
    </div>
  </div>

  <!-- ✅ Complaints Modal -->
  <template x-teleport="#x-teleport-target">
    <div
      class="fixed inset-0 z-[100] flex flex-col items-center justify-center overflow-hidden px-4 py-6 sm:px-5"
      x-show="showComplaintModal"
      role="dialog"
      @keydown.window.escape="showComplaintModal = false"
      x-transition
    >
      <div
        class="absolute inset-0 bg-slate-900/60 backdrop-blur-sm"
        @click="showComplaintModal = false"
        x-show="showComplaintModal"
        x-transition>
      </div>

      <div
        class="scrollbar-sm relative flex max-w-4xl w-full flex-col overflow-y-auto rounded-lg bg-white px-4 py-6 text-left dark:bg-navy-700 sm:px-5"
        x-show="showComplaintModal"
        x-transition
      >

        <h2 class="text-lg font-semibold text-slate-800 dark:text-navy-100 mb-4">
          Complaints Filed by Teachers
        </h2>

<div class="card mt-6">
  <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
    <div class="flex items-center space-x-2">
      <div class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary dark:bg-accent-light/10 dark:text-accent-light">
        <i class="fa-solid fa-triangle-exclamation"></i>
      </div>
      <h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">
        Complaints (<?= $complaintCount ?>)
      </h4>
    </div>
  </div>

  <div class="space-y-4 p-4 sm:p-5">
    <?php if (!empty($complaints)): ?>
      <?php foreach ($complaints as $complaint): ?>
        <div class="rounded-lg border border-slate-300 p-4 bg-slate-50 dark:bg-navy-600">
          <h3 class="font-medium text-slate-800 dark:text-navy-50"><?= htmlspecialchars($complaint['title']) ?></h3>
          <p class="text-slate-600 dark:text-navy-200 mt-1"><?= nl2br(htmlspecialchars($complaint['description'])) ?></p>
          
          <p class="mt-2 text-xs text-slate-500 dark:text-navy-300">
            Filed on: <?= date('d M Y', strtotime($complaint['filed_date'])) ?>
            <?= $complaint['status'] == 'resolved' && $complaint['resolved_date'] 
              ? ' | Resolved on: ' . date('d M Y', strtotime($complaint['resolved_date'])) 
              : '' ?>
          </p>

          <p class="mt-1 text-sm text-slate-500 dark:text-navy-200">
            Filed By: <span class="font-medium"><?= htmlspecialchars($complaint['staff_name'] . ' ' . $complaint['staff_surname'] ?? 'Unknown') ?></span>
          </p>

          <?php if (!empty($complaint['staff_audio'])): ?>
            <div class="mt-3">
              <audio controls class="w-full">
                <source src="<?= $website . '/' . $complaint['staff_audio'] ?>" type="audio/mpeg">
                Your browser does not support the audio element.
              </audio>
            </div>
          <?php endif; ?>
        </div>
      <?php endforeach; ?>
    <?php else: ?>
      <p class="text-slate-500 italic">No complaints found for this student.</p>
    <?php endif; ?>
  </div>
</div>
        <button
          class="mt-6 self-end rounded-lg bg-slate-700 px-4 py-2 text-white hover:bg-slate-800 dark:bg-navy-500 dark:hover:bg-navy-600"
          @click="showComplaintModal = false"
        >
          Close
        </button>
      </div>
    </div>
  </template>

  <!-- ✅ Attendance Modal -->
  <template x-teleport="#x-teleport-target">
    <div
      class="fixed inset-0 z-[100] flex flex-col items-center justify-center overflow-hidden px-4 py-6 sm:px-5"
      x-show="showModal"
      role="dialog"
      @keydown.window.escape="showModal = false"
      x-transition
    >
      <div class="absolute inset-0 bg-slate-900/60 backdrop-blur-sm"
           @click="showModal = false"
           x-show="showModal"
           x-transition>
      </div>

      <div class="scrollbar-sm relative flex max-w-7xl w-full flex-col overflow-y-auto rounded-lg bg-white px-4 py-6 text-center dark:bg-navy-700 sm:px-5"
           x-show="showModal"
           x-transition>
<div class="col-span-12 grid lg:grid-cols-2 gap-6 mx-auto max-w-7xl">
<?php




$sql = "SELECT * FROM student_attendance 
WHERE student_id = '$student_id' 
AND batch = '$batch'
ORDER BY year ASC, month ASC, day ASC";

$result = mysqli_query($conn, $sql);

if (!$result || mysqli_num_rows($result) == 0) {
echo '<div class="text-center text-red-500 font-medium mt-5">No student attendance record found.</div>';
}

$attendanceData = [];
while ($row = mysqli_fetch_assoc($result)) {
$monthYear = date("F Y", mktime(0, 0, 0, $row['month'], 1, $row['year']));
$attendanceData[$monthYear][] = $row;
}
?>

<?php foreach ($attendanceData as $monthYear => $records): ?>
<div class="card shadow-md">
<div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
<div class="flex items-center space-x-2">
<div class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary dark:bg-accent-light/10 dark:text-accent-light">
<i class="fa-solid fa-calendar-days"></i>
</div>
<h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">
<?= $monthYear ?>
</h4>
</div>
</div>

<div class="space-y-4 p-4 sm:p-5 text-center">
<div class="flex flex-wrap gap-2 justify-center">
<?php foreach ($records as $row): 
$day = $row['day'];
$status = strtolower($row['status']); 
$btnClass = "bg-slate-400 text-white";

if ($status == 'present') $btnClass = "bg-success hover:bg-success-focus";
if ($status == 'absent') $btnClass = "bg-error hover:bg-error-focus";
if ($status == 'half_day') $btnClass = "bg-warning hover:bg-warning-focus";
?>
<button class="btn size-9 <?= $btnClass ?> p-0 font-medium text-white">
<?= $day ?>
</button>
<?php endforeach; ?>
</div>

<div class="mt-4 text-xs text-slate-600 dark:text-navy-200">
<span class="inline-block size-3 rounded-full bg-success mr-1"></span> Present
<span class="inline-block size-3 rounded-full bg-error ml-3 mr-1"></span> Absent
<span class="inline-block size-3 rounded-full bg-warning ml-3 mr-1"></span> Half Day
</div>
</div>
</div>
<?php endforeach; ?>
</div>
        <!-- (Already provided by you and works fine) -->
      </div>
    </div>
  </template>

</div> <!-- END x-data wrapper -->




  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>

