<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>QR Scanner</title>
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #f3f4f6;
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
    }
    .card {
      background: #fff;
      border-radius: 24px;
      box-shadow: 0 10px 30px rgba(0,0,0,0.1);
      padding: 24px;
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 16px;
      position: relative;
    }
    .scanner-wrapper {
      position: relative;
      width: 320px;
      height: 320px;
      border: 4px solid red;
      border-radius: 20px;
      box-shadow: 0 6px 20px rgba(0,0,0,0.08);
      overflow: hidden;
      background: #000;
      transition: border-color 0.3s ease;
    }
    video {
      width: 100%;
      height: 100%;
      object-fit: cover;
      border-radius: 16px;
    }
    .scan-line {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 4px;
      background: rgba(0, 255, 0, 0.7);
      animation: scan 2s linear infinite;
    }
    @keyframes scan {
      0% { top: 0; }
      100% { top: calc(100% - 4px); }
    }
    .status {
      font-size: 16px;
      font-weight: 500;
      color: #555;
      transition: color 0.3s ease;
    }
    .status.detected {
      color: green;
    }

  </style>
</head>
<body>
  <div class="card">
    <div class="scanner-wrapper" id="scannerBox">
      <video id="preview"></video>
      <div class="scan-line"></div>
    </div>
    <div id="statusText" class="status">Scanning...</div>
  </div>

  <!-- Instascan Library -->
  <script src="https://rawcdn.githack.com/schmich/instascan-builds/master/instascan.min.js"></script>
<script>
  let scanner = new Instascan.Scanner({ video: document.getElementById('preview') });
  scanner.addListener('scan', function (content) {
    const scannerBox = document.getElementById('scannerBox');
    const statusText = document.getElementById('statusText');
    scannerBox.style.borderColor = "#22c55e";
    statusText.textContent = "QR Code Detected!";
    statusText.classList.add("detected");

    setTimeout(() => {
      window.location.href = "student-qr-result.php?token=" + encodeURIComponent(content);
    }, 500);
  });

  Instascan.Camera.getCameras().then(function (cameras) {
    if (cameras.length > 0) {
      // Prefer back camera if available
      let selectedCam = cameras.find(cam => cam.name.toLowerCase().includes('back')) || cameras[0];
      scanner.start(selectedCam);

      // ✅ Mirror fix: only mirror front cam, keep back cam normal
      if (selectedCam.name.toLowerCase().includes('front')) {
        document.getElementById('preview').style.transform = "scaleX(-1)";
      } else {
        document.getElementById('preview').style.transform = "scaleX(1)";
      }
    } else {
      alert('No cameras found.');
    }
  }).catch(function (e) {
    console.error(e);
    alert("Camera access denied or not available.");
  });
</script>
</body>
</html>