<?php

// Database credentials
$host = "localhost";       // Database host
$user = "samruddh_sch";            // Database username
$pass = "Patel@2002";                // Database password
$dbname = "samruddh_sch";     // Your database name
date_default_timezone_set("Asia/Kolkata");
// Create MySQLi connection
$conn = new mysqli($host, $user, $pass, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// Optional: Set character set to utf8mb4 for full Unicode support
$conn->set_charset("utf8mb4");

session_start();
$website = "https://samruddhichemicals.com/schbee/";



$school_name = "Xyz School";
$school_logo = "school.jpg";

$batch = "2025";


// Loop through semesters (1,2,...). You can adjust this.
$semesters = [1, 2];

foreach ($semesters as $semester) {
    $sql = "
        SELECT 
            c.class_name,
            SUM(CASE WHEN sf.payment_status='paid' THEN 1 ELSE 0 END) AS paid_count,
            SUM(CASE WHEN sf.payment_status IN ('unpaid','partially_paid') THEN 1 ELSE 0 END) AS unpaid_count
        FROM classes c
        LEFT JOIN student_fees sf 
            ON c.class_id = sf.class_id AND sf.semester = '$semester'
        GROUP BY c.class_name
        ORDER BY CAST(SUBSTRING_INDEX(c.class_name, ' ', -1) AS UNSIGNED)
    ";

    $result = $conn->query($sql);

    $classes = [];
    $paid = [];
    $unpaid = [];

    while ($row = $result->fetch_assoc()) {
        $classes[] = $row['class_name'];
        $paid[] = (int)$row['paid_count'];
        $unpaid[] = (int)$row['unpaid_count'];
    }

    // Prepare JSON
    $data = [
        "classes" => $classes,
        "paid"    => $paid,
        "unpaid"  => $unpaid,
        "semester"=> $semester
    ];
    $jsonData = json_encode($data);

    // Insert or update in cache
    $dataKey = "fees_summary_sem" . $semester;

    $sqlInsert = "
        INSERT INTO dashboard_cache (data_key, data_json)
        VALUES ('$dataKey', '$jsonData')
        ON DUPLICATE KEY UPDATE 
            data_json = VALUES(data_json), 
            updated_at = NOW()
    ";
    $conn->query($sqlInsert);
}

echo "Fees summary cached successfully!";





// Fetch all classes
$sqlClasses = "SELECT class_id, CONCAT(class_name, '-', division) AS class_label 
               FROM classes 
               ORDER BY class_id";
$resultClasses = mysqli_query($conn, $sqlClasses);

$classLabels = [];
$avgMarks    = [];

if ($resultClasses && mysqli_num_rows($resultClasses) > 0) {
    while ($classRow = mysqli_fetch_assoc($resultClasses)) {
        $classId = $classRow['class_id'];
        $classLabels[] = $classRow['class_label'];

        // Fetch all exams for this class
        $sqlExams = "SELECT exam_id FROM exam_schedule WHERE class_id = $classId";
        $resultExams = mysqli_query($conn, $sqlExams);

        $avgMarksSum = 0;
        $marksCount  = 0;

        if ($resultExams && mysqli_num_rows($resultExams) > 0) {
            while ($examRow = mysqli_fetch_assoc($resultExams)) {
                $examId = $examRow['exam_id'];

                // Average marks for this exam
                $sqlMarks = "SELECT AVG(marks_obtained) AS avg_marks 
                             FROM exam_results 
                             WHERE exam_id = $examId";
                $resultMarks = mysqli_query($conn, $sqlMarks);

                if ($resultMarks && $rowMarks = mysqli_fetch_assoc($resultMarks)) {
                    if ($rowMarks['avg_marks'] !== null) {
                        $avgMarksSum += $rowMarks['avg_marks'];
                        $marksCount++;
                    }
                }
            }
        }

        // Final average per class
        $finalAvg = ($marksCount > 0) ? round($avgMarksSum / $marksCount, 2) : 0;
        $avgMarks[] = $finalAvg;
    }
}

// Prepare JSON
$data = [
    "classes" => $classLabels,
    "average" => $avgMarks
];
$jsonData = json_encode($data);

// Insert/update in cache
$dataKey = "avg_marks_per_class";
$sqlInsert = "
    INSERT INTO dashboard_cache (data_key, data_json)
    VALUES ('$dataKey', '$jsonData')
    ON DUPLICATE KEY UPDATE 
        data_json = VALUES(data_json),
        updated_at = NOW()
";
mysqli_query($conn, $sqlInsert);


echo "Average marks per class cached successfully!";




// Fetch all classes
$sqlClasses = "SELECT class_id FROM classes ORDER BY class_name, division";
$resultClasses = mysqli_query($conn, $sqlClasses);

if ($resultClasses && mysqli_num_rows($resultClasses) > 0) {
    while ($row = mysqli_fetch_assoc($resultClasses)) {
        $classId = $row['class_id'];

        // Reuse your function to get averages
        list($subjects, $averages) = getClassSubjectAverages($conn, $classId);

        // Prepare cache data
        $cacheKey = "class_avg_" . $classId;
        $dataJson = json_encode([
            "subjects" => $subjects,
            "averages" => $averages
        ]);

        // Insert or update cache
        $sqlCache = "
            INSERT INTO dashboard_cache (data_key, data_json)
            VALUES ('$cacheKey', '$dataJson')
            ON DUPLICATE KEY UPDATE data_json = VALUES(data_json), updated_at = CURRENT_TIMESTAMP
        ";
        mysqli_query($conn, $sqlCache);
    }
}

// Function (same as before)
function getClassSubjectAverages($conn, $classId) {
    $subjects = [];
    $averages = [];

    $sqlSubjects = "SELECT subject_name FROM class_subjects WHERE class_id = $classId";
    $resultSubjects = mysqli_query($conn, $sqlSubjects);

    if ($resultSubjects && mysqli_num_rows($resultSubjects) > 0) {
        while ($sub = mysqli_fetch_assoc($resultSubjects)) {
            $subject = $sub['subject_name'];
            $subjects[] = $subject;

            $sqlExamSubjects = "
                SELECT es.exam_subject_id 
                FROM exam_subjects es
                INNER JOIN exam_schedule sch ON es.exam_id = sch.exam_id
                WHERE sch.class_id = $classId AND es.subject_name = '$subject'
            ";
            $resExamSub = mysqli_query($conn, $sqlExamSubjects);

            $totalMarks = 0;
            $count = 0;

            if ($resExamSub && mysqli_num_rows($resExamSub) > 0) {
                while ($esRow = mysqli_fetch_assoc($resExamSub)) {
                    $examSubId = $esRow['exam_subject_id'];
                    $sqlMarks = "SELECT AVG(marks_obtained) AS avg_marks FROM exam_results WHERE exam_subject_id = $examSubId";
                    $resMarks = mysqli_query($conn, $sqlMarks);
                    if ($resMarks && $rowMarks = mysqli_fetch_assoc($resMarks)) {
                        if ($rowMarks['avg_marks'] !== null) {
                            $totalMarks += $rowMarks['avg_marks'];
                            $count++;
                        }
                    }
                }
            }

            $finalAvg = ($count > 0) ? round($totalMarks / $count, 2) : 0;
            $averages[] = $finalAvg;
        }
    }

    return [$subjects, $averages];
}









// 1️⃣ Get all active batch names
$sqlBatches = "SELECT batch_name FROM batch WHERE status = 'Active'";
$resBatches = mysqli_query($conn, $sqlBatches);

$batches = [];
if ($resBatches && mysqli_num_rows($resBatches) > 0) {
    while ($row = mysqli_fetch_assoc($resBatches)) {
        $batches[] = $row['batch_name'];
    }
}

// 2️⃣ Loop semesters (1 & 2)
$semesters = [1, 2];

// 3️⃣ Generate cache for each (semester + batch_name)
foreach ($semesters as $sem) {
    foreach ($batches as $batchName) {

        // --- Query ---
        $sql = "
            SELECT c.class_name, c.division,
                   SUM(CASE WHEN sf.payment_status='paid' THEN sf.paid_amount ELSE 0 END) AS total_paid,
                   SUM(CASE WHEN sf.payment_status='unpaid' OR sf.payment_status='partially_paid' THEN sf.balance_amount ELSE 0 END) AS total_unpaid
            FROM student_fees sf
            JOIN classes c ON sf.class_id = c.class_id
            WHERE sf.semester = '$sem' 
              AND sf.batch = '".$conn->real_escape_string($batchName)."'
            GROUP BY c.class_id, c.class_name
        ";
        $res = mysqli_query($conn, $sql);

        $classNames = [];
        $seriesPaid = [];
        $seriesUnpaid = [];

        if ($res && mysqli_num_rows($res) > 0) {
            while ($feeRow = mysqli_fetch_assoc($res)) {
                $classNames[] = $feeRow['class_name'] . $feeRow['division'];
                $seriesPaid[] = (float)$feeRow['total_paid'];
                $seriesUnpaid[] = (float)$feeRow['total_unpaid'];
            }
        }

        // --- Prepare cache data ---
        $cacheKey = "fees_sem{$sem}_batch" . strtolower(str_replace(' ', '_', $batchName));
        $dataJson = json_encode([
            "seriesClasses" => $classNames,
            "seriesPaid"    => $seriesPaid,
            "seriesUnpaid"  => $seriesUnpaid
        ]);

        // --- Insert/Update cache ---
        $sqlCache = "
            INSERT INTO dashboard_cache (data_key, data_json)
            VALUES ('$cacheKey', '$dataJson')
            ON DUPLICATE KEY UPDATE data_json = VALUES(data_json), updated_at = CURRENT_TIMESTAMP
        ";
        mysqli_query($conn, $sqlCache);
    }
}

echo "✅ Fee cache updated successfully\n";

?>