<?php
// about.php
// Requires db.php providing $cfg + helpers: g($key,$default), e($string)

// db.php (procedural mysqli version)



// Database credentials
$host = "localhost";       // Database host
$user = "samruddh_sch";            // Database username
$pass = "Patel@2002";                // Database password
$dbname = "samruddh_sch";     // Your database name
date_default_timezone_set("Asia/Kolkata");
// Create MySQLi connection
$conn = new mysqli($host, $user, $pass, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// Optional: Set character set to utf8mb4 for full Unicode support
$conn->set_charset("utf8mb4");

session_start();

$website = "https://samruddhichemicals.com/schbee/";

// Ensure UTF-8 encoding
mysqli_set_charset($conn, "utf8mb4");
// --- SET CURRENT PAGE IDENTIFIER ---
$current_page = 'about';

// --- LOAD GLOBAL FIRST, THEN PAGE-SPECIFIC TO OVERRIDE ---
$sql = "
  SELECT page, variable, value
  FROM site_settings
  WHERE page IN ('global', ?)
  ORDER BY CASE WHEN page = 'global' THEN 0 ELSE 1 END, id
";

$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "s", $current_page);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$cfg = [];
while ($r = mysqli_fetch_assoc($result)) {
    // page rows appear after global and override same variable key
    $cfg[$r['variable']] = (string)$r['value'];
}

mysqli_stmt_close($stmt);

// --- HELPERS ---
function g(string $key, string $default = ''): string {
    global $cfg;
    return isset($cfg[$key]) ? $cfg[$key] : $default;
}
function e(string $s): string {
    return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
}

// Local helper to render star icons for testimonials
function stars_html($n) {
  $n = max(0, min(5, (int)$n));
  return str_repeat('<i class="bi bi-star-fill"></i>', $n);
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title><?= e(g('about_html_title','About - Mentor Bootstrap Template')) ?></title>
  <meta name="description" content="<?= e(g('about_meta_description','')) ?>">
  <meta name="keywords" content="<?= e(g('about_meta_keywords','')) ?>">

  <!-- Favicons -->
  <link href="<?= e(g('favicon_url','assets/img/favicon.png')) ?>" rel="icon">
  <link href="<?= e(g('apple_touch_icon_url','assets/img/apple-touch-icon.png')) ?>" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,300;1,400;1,500;1,600;1,700;1,800&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/aos/aos.css" rel="stylesheet">
  <link href="assets/vendor/glightbox/css/glightbox.min.css" rel="stylesheet">
  <link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">

  <!-- Main CSS File -->
  <link href="assets/css/main.css" rel="stylesheet">

  <!-- =======================================================
  * Template Name: Mentor
  * Template URL: https://bootstrapmade.com/mentor-free-education-bootstrap-theme/
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body class="about-page">

  <header id="header" class="header d-flex align-items-center sticky-top">
    <div class="container-fluid container-xl position-relative d-flex align-items-center">

      <a href="<?= e(g('logo_href','index.html')) ?>" class="logo d-flex align-items-center me-auto">
        <?php if (trim(g('logo_url','')) !== ''): ?>
          <img src="<?= e(g('logo_url','assets/img/logo.png')) ?>" alt="<?= e(g('logo_alt','Logo')) ?>">
        <?php else: ?>
          <h1 class="sitename"><?= e(g('site_name','Mentor')) ?></h1>
        <?php endif; ?>
      </a>

      <nav id="navmenu" class="navmenu">
        <ul>
          <li><a href="<?= e(g('nav_home_href','index.html')) ?>"><?= e(g('nav_home_label','Home')) ?><br></a></li>
          <li><a href="<?= e(g('nav_about_href','about.html')) ?>" class="active"><?= e(g('nav_about_label','About')) ?></a></li>
          <li><a href="<?= e(g('nav_courses_href','courses.html')) ?>"><?= e(g('nav_courses_label','Courses')) ?></a></li>
          <li><a href="<?= e(g('nav_trainers_href','trainers.html')) ?>"><?= e(g('nav_trainers_label','Trainers')) ?></a></li>
          <li><a href="<?= e(g('nav_events_href','events.html')) ?>><?= e(g('nav_events_label','Events')) ?></a></li>
          <li><a href="<?= e(g('nav_pricing_href','pricing.html')) ?>"><?= e(g('nav_pricing_label','Pricing')) ?></a></li>
          <li class="dropdown"><a href="#"><span><?= e(g('nav_dropdown_label','Dropdown')) ?></span> <i class="bi bi-chevron-down toggle-dropdown"></i></a>
            <ul>
              <li><a href="<?= e(g('dropdown_1_href','#')) ?>"><?= e(g('dropdown_1_label','Dropdown 1')) ?></a></li>
              <li class="dropdown"><a href="#"><span><?= e(g('deep_dropdown_label','Deep Dropdown')) ?></span> <i class="bi bi-chevron-down toggle-dropdown"></i></a>
                <ul>
                  <li><a href="<?= e(g('deep_dropdown_1_href','#')) ?>"><?= e(g('deep_dropdown_1_label','Deep Dropdown 1')) ?></a></li>
                  <li><a href="<?= e(g('deep_dropdown_2_href','#')) ?>"><?= e(g('deep_dropdown_2_label','Deep Dropdown 2')) ?></a></li>
                  <li><a href="<?= e(g('deep_dropdown_3_href','#')) ?>><?= e(g('deep_dropdown_3_label','Deep Dropdown 3')) ?></a></li>
                  <li><a href="<?= e(g('deep_dropdown_4_href','#')) ?>><?= e(g('deep_dropdown_4_label','Deep Dropdown 4')) ?></a></li>
                  <li><a href="<?= e(g('deep_dropdown_5_href','#')) ?>><?= e(g('deep_dropdown_5_label','Deep Dropdown 5')) ?></a></li>
                </ul>
              </li>
              <li><a href="<?= e(g('dropdown_2_href','#')) ?>"><?= e(g('dropdown_2_label','Dropdown 2')) ?></a></li>
              <li><a href="<?= e(g('dropdown_3_href','#')) ?>><?= e(g('dropdown_3_label','Dropdown 3')) ?></a></li>
              <li><a href="<?= e(g('dropdown_4_href','#')) ?>"><?= e(g('dropdown_4_label','Dropdown 4')) ?></a></li>
            </ul>
          </li>
          <li><a href="<?= e(g('nav_contact_href','contact.html')) ?>"><?= e(g('nav_contact_label','Contact')) ?></a></li>
        </ul>
        <i class="mobile-nav-toggle d-xl-none bi bi-list"></i>
      </nav>

      <a class="btn-getstarted" href="<?= e(g('nav_cta_link','courses.html')) ?>"><?= e(g('nav_cta_label','Get Started')) ?></a>

    </div>
  </header>

  <main class="main">

    <!-- Page Title -->
    <div class="page-title" data-aos="fade">
      <div class="heading">
        <div class="container">
          <div class="row d-flex justify-content-center text-center">
            <div class="col-lg-8">
              <h1><?= e(g('about_page_heading','About Us')) ?><br></h1>
              <p class="mb-0"><?= e(g('about_page_subtext','')) ?></p>
            </div>
          </div>
        </div>
      </div>
      <nav class="breadcrumbs">
        <div class="container">
          <ol>
            <li><a href="<?= e(g('breadcrumbs_home_href','index.html')) ?>"><?= e(g('breadcrumbs_home_label','Home')) ?></a></li>
            <li class="current"><?= e(g('breadcrumbs_current_label','About Us')) ?><br></li>
          </ol>
        </div>
      </nav>
    </div><!-- End Page Title -->

    <!-- About Us Section -->
    <section id="about-us" class="section about-us">

      <div class="container">

        <div class="row gy-4">

          <div class="col-lg-6 order-1 order-lg-2" data-aos="fade-up" data-aos-delay="100">
            <img src="<?= e(g('about2_image_url','assets/img/about-2.jpg')) ?>" class="img-fluid" alt="<?= e(g('about2_image_alt','About image')) ?>">
          </div>

          <div class="col-lg-6 order-2 order-lg-1 content" data-aos="fade-up" data-aos-delay="200">
            <h3><?= e(g('about2_title','Voluptatem dignissimos provident quasi corporis')) ?></h3>
            <p class="fst-italic">
              <?= e(g('about2_intro','Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.')) ?>
            </p>
            <ul>
              <li><i class="bi bi-check-circle"></i> <span><?= e(g('about2_bullet_1','Ullamco laboris nisi ut aliquip ex ea commodo consequat.')) ?></span></li>
              <li><i class="bi bi-check-circle"></i> <span><?= e(g('about2_bullet_2','Duis aute irure dolor in reprehenderit in voluptate velit.')) ?></span></li>
              <li><i class="bi bi-check-circle"></i> <span><?= e(g('about2_bullet_3','Ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate trideta storacalaperda mastiro dolore eu fugiat nulla pariatur.')) ?></span></li>
            </ul>
          </div>

        </div>

      </div>

    </section><!-- /About Us Section -->

    <!-- Counts Section -->
    <section id="counts" class="section counts light-background">

      <div class="container" data-aos="fade-up" data-aos-delay="100">

        <div class="row gy-4">

          <div class="col-lg-3 col-md-6">
            <div class="stats-item text-center w-100 h-100">
              <span data-purecounter-start="0" data-purecounter-end="<?= e(g('counts_students','1232')) ?>" data-purecounter-duration="1" class="purecounter"></span>
              <p><?= e(g('counts_students_label','Students')) ?></p>
            </div>
          </div><!-- End Stats Item -->

          <div class="col-lg-3 col-md-6">
            <div class="stats-item text-center w-100 h-100">
              <span data-purecounter-start="0" data-purecounter-end="<?= e(g('counts_courses','64')) ?>" data-purecounter-duration="1" class="purecounter"></span>
              <p><?= e(g('counts_courses_label','Courses')) ?></p>
            </div>
          </div><!-- End Stats Item -->

          <div class="col-lg-3 col-md-6">
            <div class="stats-item text-center w-100 h-100">
              <span data-purecounter-start="0" data-purecounter-end="<?= e(g('counts_events','42')) ?>" data-purecounter-duration="1" class="purecounter"></span>
              <p><?= e(g('counts_events_label','Events')) ?></p>
            </div>
          </div><!-- End Stats Item -->

          <div class="col-lg-3 col-md-6">
            <div class="stats-item text-center w-100 h-100">
              <span data-purecounter-start="0" data-purecounter-end="<?= e(g('counts_trainers','24')) ?>" data-purecounter-duration="1" class="purecounter"></span>
              <p><?= e(g('counts_trainers_label','Trainers')) ?></p>
            </div>
          </div><!-- End Stats Item -->

        </div>

      </div>

    </section><!-- /Counts Section -->

    <!-- Testimonials Section -->
    <section id="testimonials" class="testimonials section">

      <!-- Section Title -->
      <div class="container section-title" data-aos="fade-up">
        <h2><?= e(g('testimonials_title','Testimonials')) ?></h2>
        <p><?= e(g('testimonials_subtitle','What are they saying')) ?></p>
      </div><!-- End Section Title -->

      <div class="container" data-aos="fade-up" data-aos-delay="100">

        <div class="swiper init-swiper">
          <script type="application/json" class="swiper-config">
            {
              "loop": true,
              "speed": 600,
              "autoplay": {
                "delay": 5000
              },
              "slidesPerView": "auto",
              "pagination": {
                "el": ".swiper-pagination",
                "type": "bullets",
                "clickable": true
              },
              "breakpoints": {
                "320": {
                  "slidesPerView": 1,
                  "spaceBetween": 40
                },
                "1200": {
                  "slidesPerView": 2,
                  "spaceBetween": 20
                }
              }
            }
          </script>
          <div class="swiper-wrapper">

            <?php
              $tcount = (int) g('testimonials_count', '5');
              for ($i = 1; $i <= $tcount; $i++):
                $img   = g("testimonial_{$i}_image_url", "assets/img/testimonials/testimonials-{$i}.jpg");
                $name  = g("testimonial_{$i}_name", "Name {$i}");
                $role  = g("testimonial_{$i}_role", "Role");
                $text  = g("testimonial_{$i}_text", "Testimonial text");
                $stars = g("testimonial_{$i}_stars", "5");
            ?>
            <div class="swiper-slide">
              <div class="testimonial-wrap">
                <div class="testimonial-item">
                  <img src="<?= e($img) ?>" class="testimonial-img" alt="<?= e($name) ?>">
                  <h3><?= e($name) ?></h3>
                  <h4><?= e($role) ?></h4>
                  <div class="stars"><?= stars_html($stars) ?></div>
                  <p>
                    <i class="bi bi-quote quote-icon-left"></i>
                    <span><?= e($text) ?></span>
                    <i class="bi bi-quote quote-icon-right"></i>
                  </p>
                </div>
              </div>
            </div><!-- End testimonial item -->
            <?php endfor; ?>

          </div>
          <div class="swiper-pagination"></div>
        </div>

      </div>

    </section><!-- /Testimonials Section -->

  </main>

  <footer id="footer" class="footer position-relative light-background">

    <div class="container footer-top">
      <div class="row gy-4">
        <div class="col-lg-4 col-md-6 footer-about">
          <a href="<?= e(g('footer_logo_href','index.html')) ?>" class="logo d-flex align-items-center">
            <span class="sitename"><?= e(g('footer_sitename','Mentor')) ?></span>
          </a>
          <div class="footer-contact pt-3">
            <p><?= e(g('footer_addr_line1','A108 Adam Street')) ?></p>
            <p><?= e(g('footer_addr_line2','New York, NY 535022')) ?></p>
            <p class="mt-3"><strong><?= e(g('footer_phone_label','Phone:')) ?></strong> <span><?= e(g('footer_phone','+1 5589 55488 55')) ?></span></p>
            <p><strong><?= e(g('footer_email_label','Email:')) ?></strong> <span><?= e(g('footer_email','info@example.com')) ?></span></p>
          </div>
          <div class="social-links d-flex mt-4">
            <a href="<?= e(g('footer_twitter','#')) ?>"><i class="bi bi-twitter-x"></i></a>
            <a href="<?= e(g('footer_facebook','#')) ?>"><i class="bi bi-facebook"></i></a>
            <a href="<?= e(g('footer_instagram','#')) ?>"><i class="bi bi-instagram"></i></a>
            <a href="<?= e(g('footer_linkedin','#')) ?>"><i class="bi bi-linkedin"></i></a>
          </div>
        </div>

        <div class="col-lg-2 col-md-3 footer-links">
          <h4><?= e(g('useful_links_title','Useful Links')) ?></h4>
          <ul>
            <li><a href="<?= e(g('useful_link1_href','#')) ?>"><?= e(g('useful_link1_label','Home')) ?></a></li>
            <li><a href="<?= e(g('useful_link2_href','#')) ?>"><?= e(g('useful_link2_label','About us')) ?></a></li>
            <li><a href="<?= e(g('useful_link3_href','#')) ?>"><?= e(g('useful_link3_label','Services')) ?></a></li>
            <li><a href="<?= e(g('useful_link4_href','#')) ?>"><?= e(g('useful_link4_label','Terms of service')) ?></a></li>
            <li><a href="<?= e(g('useful_link5_href','#')) ?>"><?= e(g('useful_link5_label','Privacy policy')) ?></a></li>
          </ul>
        </div>

        <div class="col-lg-2 col-md-3 footer-links">
          <h4><?= e(g('services_title','Our Services')) ?></h4>
          <ul>
            <li><a href="<?= e(g('services_1_href','#')) ?>"><?= e(g('services_1_label','Web Design')) ?></a></li>
            <li><a href="<?= e(g('services_2_href','#')) ?>"><?= e(g('services_2_label','Web Development')) ?></a></li>
            <li><a href="<?= e(g('services_3_href','#')) ?>><?= e(g('services_3_label','Product Management')) ?></a></li>
            <li><a href="<?= e(g('services_4_href','#')) ?>"><?= e(g('services_4_label','Marketing')) ?></a></li>
            <li><a href="<?= e(g('services_5_href','#')) ?>><?= e(g('services_5_label','Graphic Design')) ?></a></li>
          </ul>
        </div>

        <div class="col-lg-4 col-md-12 footer-newsletter">
          <h4><?= e(g('newsletter_title','Our Newsletter')) ?></h4>
          <p><?= e(g('newsletter_text','Subscribe to our newsletter and receive the latest news about our products and services!')) ?></p>
          <form action="<?= e(g('newsletter_action','forms/newsletter.php')) ?>" method="post" class="php-email-form">
            <div class="newsletter-form">
              <input type="email" name="email" placeholder="<?= e(g('newsletter_input_placeholder','Email')) ?>">
              <input type="submit" value="<?= e(g('newsletter_submit_label','Subscribe')) ?>">
            </div>
            <div class="loading"><?= e(g('newsletter_loading_text','Loading')) ?></div>
            <div class="error-message"></div>
            <div class="sent-message"><?= e(g('newsletter_sent_text','Your subscription request has been sent. Thank you!')) ?></div>
          </form>
        </div>

      </div>
    </div>

    <div class="container copyright text-center mt-4">
      <p><?= e(g('copyright_line','© Copyright')) ?>
        <strong class="px-1 sitename"><?= e(g('copyright_sitename','Mentor')) ?></strong>
        <span><?= e(g('copyright_tail','All Rights Reserved')) ?></span>
      </p>
      <div class="credits">
        <?= e(g('credit_designed_label','Designed by')) ?>
        <a href="<?= e(g('credit_designed_href','https://bootstrapmade.com/')) ?>"><?= e(g('credit_designed_name','BootstrapMade')) ?></a>
        <?= e(g('credit_separator',' ')) ?>
        <?= e(g('credit_distributed_label','Distributed by')) ?>
        <a href="<?= e(g('credit_distributed_href','https://themewagon.com/')) ?>"><?= e(g('credit_distributed_name','ThemeWagon')) ?></a>
      </div>
    </div>

  </footer>

  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Preloader -->


  <!-- Vendor JS Files -->
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>
  <script src="assets/vendor/aos/aos.js"></script>
  <script src="assets/vendor/glightbox/js/glightbox.min.js"></script>
  <script src="assets/vendor/purecounter/purecounter_vanilla.js"></script>
  <script src="assets/vendor/swiper/swiper-bundle.min.js"></script>

  <!-- Main JS File -->
  <script src="assets/js/main.js"></script>

</body>
</html>
