<?php
function changePermissions($path, $filePerm = 0644, $folderPerm = 0755) {
    if (!file_exists($path)) {
        echo "The specified path does not exist.";
        return;
    }

    if (is_dir($path)) {
        chmod($path, $folderPerm);

        $items = scandir($path);
        foreach ($items as $item) {
            if ($item === '.' || $item === '..') continue;

            $fullPath = $path . DIRECTORY_SEPARATOR . $item;
            changePermissions($fullPath, $filePerm, $folderPerm);
        }
    } elseif (is_file($path)) {
        chmod($path, $filePerm);
    }
}

// Use the current script directory
$targetPath = __DIR__;
changePermissions($targetPath);

echo "Permissions have been updated successfully for: " . $targetPath;
?>