<?php
// db.php — include at the top of your page

// Connect using procedural MySQLi


// Database credentials
$host = "localhost";       // Database host
$user = "samruddh_sch";            // Database username
$pass = "Patel@2002";                // Database password
$dbname = "samruddh_sch";     // Your database name
date_default_timezone_set("Asia/Kolkata");
// Create MySQLi connection
$conn = new mysqli($host, $user, $pass, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// Optional: Set character set to utf8mb4 for full Unicode support
$conn->set_charset("utf8mb4");

session_start();

$website = "https://samruddhichemicals.com/schbee/";

// Ensure UTF-8 encoding
mysqli_set_charset($conn, "utf8mb4");

// Load settings as [variable => value]
$cfg = [];
$sql = "SELECT variable, value FROM site_settings";
$result = mysqli_query($conn, $sql);
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $cfg[$row['variable']] = $row['value'];
    }
    mysqli_free_result($result);
}

// Helpers
function g(string $key, string $default = ''): string {
    global $cfg;
    return isset($cfg[$key]) ? (string)$cfg[$key] : $default;
}
function e(string $s): string {
    return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title><?= e(g('html_title','Index - Mentor Bootstrap Template')) ?></title>
  <meta name="description" content="<?= e(g('meta_description','')) ?>">
  <meta name="keywords" content="<?= e(g('meta_keywords','')) ?>">

  <!-- Favicons -->
  <link href="<?= e(g('favicon_url','assets/img/favicon.png')) ?>" rel="icon">
  <link href="<?= e(g('apple_touch_icon_url','assets/img/apple-touch-icon.png')) ?>" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;500;600;700;800&family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Raleway:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/aos/aos.css" rel="stylesheet">
  <link href="assets/vendor/glightbox/css/glightbox.min.css" rel="stylesheet">
  <link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">

  <!-- Main CSS File -->
  <link href="assets/css/main.css" rel="stylesheet">

  <!-- =======================================================
  * Template Name: Mentor
  * Template URL: https://bootstrapmade.com/mentor-free-education-bootstrap-theme/
  * Updated: (controlled by template)
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body class="index-page">

  <header id="header" class="header d-flex align-items-center sticky-top">
    <div class="container-fluid container-xl position-relative d-flex align-items-center">

      <a href="<?= e(g('logo_href','index.html')) ?>" class="logo d-flex align-items-center me-auto">
        <img src="<?= e(g('logo_url','assets/img/logo.png')) ?>" alt="<?= e(g('logo_alt','Logo')) ?>">
      </a>

      <nav id="navmenu" class="navmenu">
        <ul>
          <li><a href="<?= e(g('nav_home_href','index.html')) ?>" class="active"><?= e(g('nav_home_label','Home')) ?><br></a></li>
          <li><a href="<?= e(g('nav_about_href','about.html')) ?>"><?= e(g('nav_about_label','About')) ?></a></li>
          <li><a href="<?= e(g('nav_courses_href','courses.html')) ?>"><?= e(g('nav_courses_label','Courses')) ?></a></li>
          <li><a href="<?= e(g('nav_trainers_href','trainers.html')) ?>"><?= e(g('nav_trainers_label','Trainers')) ?></a></li>
          <li><a href="<?= e(g('nav_events_href','events.html')) ?>"><?= e(g('nav_events_label','Events')) ?></a></li>
          <li><a href="<?= e(g('nav_pricing_href','pricing.html')) ?>"><?= e(g('nav_pricing_label','Pricing')) ?></a></li>

          <li class="dropdown">
            <a href="#"><span><?= e(g('nav_dropdown_label','Dropdown')) ?></span> <i class="bi bi-chevron-down toggle-dropdown"></i></a>
            <ul>
              <li><a href="<?= e(g('dropdown_1_href','#')) ?>"><?= e(g('dropdown_1_label','Dropdown 1')) ?></a></li>
              <li class="dropdown">
                <a href="#"><span><?= e(g('deep_dropdown_label','Deep Dropdown')) ?></span> <i class="bi bi-chevron-down toggle-dropdown"></i></a>
                <ul>
                  <li><a href="<?= e(g('deep_dropdown_1_href','#')) ?>"><?= e(g('deep_dropdown_1_label','Deep Dropdown 1')) ?></a></li>
                  <li><a href="<?= e(g('deep_dropdown_2_href','#')) ?>"><?= e(g('deep_dropdown_2_label','Deep Dropdown 2')) ?></a></li>
                  <li><a href="<?= e(g('deep_dropdown_3_href','#')) ?>"><?= e(g('deep_dropdown_3_label','Deep Dropdown 3')) ?></a></li>
                  <li><a href="<?= e(g('deep_dropdown_4_href','#')) ?>"><?= e(g('deep_dropdown_4_label','Deep Dropdown 4')) ?></a></li>
                  <li><a href="<?= e(g('deep_dropdown_5_href','#')) ?>"><?= e(g('deep_dropdown_5_label','Deep Dropdown 5')) ?></a></li>
                </ul>
              </li>
              <li><a href="<?= e(g('dropdown_2_href','#')) ?>"><?= e(g('dropdown_2_label','Dropdown 2')) ?></a></li>
              <li><a href="<?= e(g('dropdown_3_href','#')) ?>"><?= e(g('dropdown_3_label','Dropdown 3')) ?></a></li>
              <li><a href="<?= e(g('dropdown_4_href','#')) ?>"><?= e(g('dropdown_4_label','Dropdown 4')) ?></a></li>
            </ul>
          </li>

          <li><a href="<?= e(g('nav_contact_href','contact.html')) ?>"><?= e(g('nav_contact_label','Contact')) ?></a></li>
        </ul>
        <i class="mobile-nav-toggle d-xl-none bi bi-list"></i>
      </nav>

      <a class="btn-getstarted" href="<?= e(g('nav_cta_link','courses.html')) ?>"><?= e(g('nav_cta_label','Get Started')) ?></a>

    </div>
  </header>

  <main class="main">

    <!-- Hero Section -->
    <section id="hero" class="hero section dark-background">
      <img src="<?= e(g('hero_bg_url','assets/img/hero-bg.jpg')) ?>" alt="<?= e(g('hero_bg_alt','')) ?>" data-aos="fade-in">

      <div class="container">
        <h2 data-aos="fade-up" data-aos-delay="100"><?= e(g('hero_title','Learning Today, Leading Tomorrow')) ?></h2>
        <p data-aos="fade-up" data-aos-delay="200"><?= e(g('hero_subtitle','We are team of talented designers making websites with Bootstrap')) ?></p>
        <div class="d-flex mt-4" data-aos="fade-up" data-aos-delay="300">
          <a href="<?= e(g('hero_btn_link','courses.html')) ?>" class="btn-get-started"><?= e(g('hero_btn_label','Get Started')) ?></a>
        </div>
      </div>
    </section>

    <!-- About Section -->
    <section id="about" class="about section">
      <div class="container">
        <div class="row gy-4">
          <div class="col-lg-6 order-1 order-lg-2" data-aos="fade-up" data-aos-delay="100">
            <img src="<?= e(g('about_image_url','assets/img/about.jpg')) ?>" class="img-fluid" alt="<?= e(g('about_image_alt','About')) ?>">
          </div>

          <div class="col-lg-6 order-2 order-lg-1 content" data-aos="fade-up" data-aos-delay="200">
            <h3><?= e(g('about_title','Voluptatem dignissimos provident quasi corporis')) ?></h3>
            <p class="fst-italic"><?= e(g('about_intro','')) ?></p>
            <ul>
              <li><i class="bi bi-check-circle"></i> <span><?= e(g('about_bullet_1','')) ?></span></li>
              <li><i class="bi bi-check-circle"></i> <span><?= e(g('about_bullet_2','')) ?></span></li>
              <li><i class="bi bi-check-circle"></i> <span><?= e(g('about_bullet_3','')) ?></span></li>
            </ul>
            <a href="<?= e(g('about_readmore_link','#')) ?>" class="read-more"><span><?= e(g('about_readmore_label','Read More')) ?></span><i class="bi bi-arrow-right"></i></a>
          </div>
        </div>
      </div>
    </section>

    <!-- Counts Section -->
    <section id="counts" class="section counts light-background">
      <div class="container" data-aos="fade-up" data-aos-delay="100">
        <div class="row gy-4">
          <div class="col-lg-3 col-md-6">
            <div class="stats-item text-center w-100 h-100">
              <span data-purecounter-start="0" data-purecounter-end="<?= e(g('counts_students','0')) ?>" data-purecounter-duration="1" class="purecounter"></span>
              <p><?= e(g('counts_students_label','Students')) ?></p>
            </div>
          </div>

          <div class="col-lg-3 col-md-6">
            <div class="stats-item text-center w-100 h-100">
              <span data-purecounter-start="0" data-purecounter-end="<?= e(g('counts_courses','0')) ?>" data-purecounter-duration="1" class="purecounter"></span>
              <p><?= e(g('counts_courses_label','Courses')) ?></p>
            </div>
          </div>

          <div class="col-lg-3 col-md-6">
            <div class="stats-item text-center w-100 h-100">
              <span data-purecounter-start="0" data-purecounter-end="<?= e(g('counts_events','0')) ?>" data-purecounter-duration="1" class="purecounter"></span>
              <p><?= e(g('counts_events_label','Events')) ?></p>
            </div>
          </div>

          <div class="col-lg-3 col-md-6">
            <div class="stats-item text-center w-100 h-100">
              <span data-purecounter-start="0" data-purecounter-end="<?= e(g('counts_trainers','0')) ?>" data-purecounter-duration="1" class="purecounter"></span>
              <p><?= e(g('counts_trainers_label','Trainers')) ?></p>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Why Us Section -->
    <section id="why-us" class="section why-us">
      <div class="container">
        <div class="row gy-4">
          <div class="col-lg-4" data-aos="fade-up" data-aos-delay="100">
            <div class="why-box">
              <h3><?= e(g('why_title','Why Choose Our Products?')) ?></h3>
              <p><?= e(g('why_text','')) ?></p>
              <div class="text-center">
                <a href="<?= e(g('why_btn_link','#')) ?>" class="more-btn"><span><?= e(g('why_btn_label','Learn More')) ?></span> <i class="bi bi-chevron-right"></i></a>
              </div>
            </div>
          </div>

          <div class="col-lg-8 d-flex align-items-stretch">
            <div class="row gy-4" data-aos="fade-up" data-aos-delay="200">
              <div class="col-xl-4">
                <div class="icon-box d-flex flex-column justify-content-center align-items-center">
                  <i class="bi bi-clipboard-data"></i>
                  <h4><?= e(g('iconbox1_title','')) ?></h4>
                  <p><?= e(g('iconbox1_text','')) ?></p>
                </div>
              </div>

              <div class="col-xl-4" data-aos="fade-up" data-aos-delay="300">
                <div class="icon-box d-flex flex-column justify-content-center align-items-center">
                  <i class="bi bi-gem"></i>
                  <h4><?= e(g('iconbox2_title','')) ?></h4>
                  <p><?= e(g('iconbox2_text','')) ?></p>
                </div>
              </div>

              <div class="col-xl-4" data-aos="fade-up" data-aos-delay="400">
                <div class="icon-box d-flex flex-column justify-content-center align-items-center">
                  <i class="bi bi-inboxes"></i>
                  <h4><?= e(g('iconbox3_title','')) ?></h4>
                  <p><?= e(g('iconbox3_text','')) ?></p>
                </div>
              </div>
            </div>
          </div>

        </div>
      </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="features section">
      <div class="container">
        <div class="row gy-4">
          <?php for ($i=1; $i<=12; $i++): ?>
            <div class="col-lg-3 col-md-4" data-aos="fade-up" data-aos-delay="<?= 100*$i ?>">
              <div class="features-item">
                <i class="<?= e(g("features_{$i}_icon","bi bi-star")) ?>"></i>
                <h3><a href="<?= e(g("features_{$i}_href","")) ?>" class="stretched-link"><?= e(g("features_{$i}_label","Feature {$i}")) ?></a></h3>
              </div>
            </div>
          <?php endfor; ?>
        </div>
      </div>
    </section>

    <!-- Courses Section -->
    <section id="courses" class="courses section">
      <div class="container section-title" data-aos="fade-up">
        <h2><?= e(g('courses_section_title','Courses')) ?></h2>
        <p><?= e(g('courses_section_subtitle','Popular Courses')) ?></p>
      </div>

      <div class="container">
        <div class="row">
          <?php for ($i=1; $i<=3; $i++): ?>
            <div class="col-lg-4 col-md-6 d-flex align-items-stretch <?= $i>1 ? 'mt-4 mt-md-0' : '' ?>" data-aos="zoom-in" data-aos-delay="<?= 100*$i ?>">
              <div class="course-item">
                <img src="<?= e(g("course{$i}_image_url","assets/img/course-{$i}.jpg")) ?>" class="img-fluid" alt="<?= e(g("course{$i}_image_alt","")) ?>">
                <div class="course-content">
                  <div class="d-flex justify-content-between align-items-center mb-3">
                    <p class="category"><?= e(g("course{$i}_category","")) ?></p>
                    <p class="price"><?= e(g("course{$i}_price","")) ?></p>
                  </div>

                  <h3><a href="<?= e(g("course{$i}_link","course-details.html")) ?>"><?= e(g("course{$i}_title","")) ?></a></h3>
                  <p class="description"><?= e(g("course{$i}_desc","")) ?></p>

                  <div class="trainer d-flex justify-content-between align-items-center">
                    <div class="trainer-profile d-flex align-items-center">
                      <img src="<?= e(g("course{$i}_trainer_image_url","assets/img/trainers/trainer-{$i}-2.jpg")) ?>" class="img-fluid" alt="<?= e(g("course{$i}_trainer_image_alt","")) ?>">
                      <a href="<?= e(g("course{$i}_trainer_link","#")) ?>" class="trainer-link"><?= e(g("course{$i}_trainer_name","")) ?></a>
                    </div>
                    <div class="trainer-rank d-flex align-items-center">
                      <i class="bi bi-person user-icon"></i>&nbsp;<?= e(g("course{$i}_users","0")) ?>
                      &nbsp;&nbsp;
                      <i class="bi bi-heart heart-icon"></i>&nbsp;<?= e(g("course{$i}_likes","0")) ?>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          <?php endfor; ?>
        </div>
      </div>
    </section>

    <!-- Trainers Index Section -->
    <section id="trainers-index" class="section trainers-index">
      <div class="container">
        <div class="row">
          <?php for ($i=1; $i<=3; $i++): ?>
            <div class="col-lg-4 col-md-6 d-flex" data-aos="fade-up" data-aos-delay="<?= 100*$i ?>">
              <div class="member">
                <img src="<?= e(g("trainer{$i}_image_url","assets/img/trainers/trainer-{$i}.jpg")) ?>" class="img-fluid" alt="<?= e(g("trainer{$i}_image_alt","")) ?>">
                <div class="member-content">
                  <h4><?= e(g("trainer{$i}_name","")) ?></h4>
                  <span><?= e(g("trainer{$i}_role","")) ?></span>
                  <p><?= e(g("trainer{$i}_desc","")) ?></p>
                  <div class="social">
                    <a href="<?= e(g("trainer{$i}_twitter","#")) ?>"><i class="bi bi-twitter-x"></i></a>
                    <a href="<?= e(g("trainer{$i}_facebook","#")) ?>"><i class="bi bi-facebook"></i></a>
                    <a href="<?= e(g("trainer{$i}_instagram","#")) ?>"><i class="bi bi-instagram"></i></a>
                    <a href="<?= e(g("trainer{$i}_linkedin","#")) ?>"><i class="bi bi-linkedin"></i></a>
                  </div>
                </div>
              </div>
            </div>
          <?php endfor; ?>
        </div>
      </div>
    </section>

  </main>

  <footer id="footer" class="footer position-relative light-background">
    <div class="container footer-top">
      <div class="row gy-4">
        <div class="col-lg-4 col-md-6 footer-about">
          <a href="<?= e(g('footer_logo_href','index.html')) ?>" class="logo d-flex align-items-center">
            <span class="sitename"><?= e(g('footer_sitename','Mentor')) ?></span>
          </a>
          <div class="footer-contact pt-3">
            <p><?= e(g('footer_addr_line1','')) ?></p>
            <p><?= e(g('footer_addr_line2','')) ?></p>
            <p class="mt-3"><strong><?= e(g('footer_phone_label','Phone:')) ?></strong> <span><?= e(g('footer_phone','')) ?></span></p>
            <p><strong><?= e(g('footer_email_label','Email:')) ?></strong> <span><?= e(g('footer_email','')) ?></span></p>
          </div>
          <div class="social-links d-flex mt-4">
            <a href="<?= e(g('footer_twitter','#')) ?>"><i class="bi bi-twitter-x"></i></a>
            <a href="<?= e(g('footer_facebook','#')) ?>"><i class="bi bi-facebook"></i></a>
            <a href="<?= e(g('footer_instagram','#')) ?>"><i class="bi bi-instagram"></i></a>
            <a href="<?= e(g('footer_linkedin','#')) ?>"><i class="bi bi-linkedin"></i></a>
          </div>
        </div>

        <div class="col-lg-2 col-md-3 footer-links">
          <h4><?= e(g('useful_links_title','Useful Links')) ?></h4>
          <ul>
            <li><a href="<?= e(g('useful_link1_href','#')) ?>"><?= e(g('useful_link1_label','Home')) ?></a></li>
            <li><a href="<?= e(g('useful_link2_href','#')) ?>"><?= e(g('useful_link2_label','About us')) ?></a></li>
            <li><a href="<?= e(g('useful_link3_href','#')) ?>"><?= e(g('useful_link3_label','Services')) ?></a></li>
            <li><a href="<?= e(g('useful_link4_href','#')) ?>"><?= e(g('useful_link4_label','Terms of service')) ?></a></li>
            <li><a href="<?= e(g('useful_link5_href','#')) ?>"><?= e(g('useful_link5_label','Privacy policy')) ?></a></li>
          </ul>
        </div>

        <div class="col-lg-2 col-md-3 footer-links">
          <h4><?= e(g('services_title','Our Services')) ?></h4>
          <ul>
            <li><a href="<?= e(g('services_1_href','#')) ?>"><?= e(g('services_1_label','Web Design')) ?></a></li>
            <li><a href="<?= e(g('services_2_href','#')) ?>"><?= e(g('services_2_label','Web Development')) ?></a></li>
            <li><a href="<?= e(g('services_3_href','#')) ?>"><?= e(g('services_3_label','Product Management')) ?></a></li>
            <li><a href="<?= e(g('services_4_href','#')) ?>"><?= e(g('services_4_label','Marketing')) ?></a></li>
            <li><a href="<?= e(g('services_5_href','#')) ?>"><?= e(g('services_5_label','Graphic Design')) ?></a></li>
          </ul>
        </div>

        <div class="col-lg-4 col-md-12 footer-newsletter">
          <h4><?= e(g('newsletter_title','Our Newsletter')) ?></h4>
          <p><?= e(g('newsletter_text','Subscribe to our newsletter and receive the latest news about our products and services!')) ?></p>
          <form action="<?= e(g('newsletter_action','forms/newsletter.php')) ?>" method="post" class="php-email-form">
            <div class="newsletter-form">
              <input type="email" name="email" placeholder="<?= e(g('newsletter_input_placeholder','Email')) ?>">
              <input type="submit" value="<?= e(g('newsletter_submit_label','Subscribe')) ?>">
            </div>
            <div class="loading"><?= e(g('newsletter_loading_text','Loading')) ?></div>
            <div class="error-message"></div>
            <div class="sent-message"><?= e(g('newsletter_sent_text','Your subscription request has been sent. Thank you!')) ?></div>
          </form>
        </div>
      </div>
    </div>

    <div class="container copyright text-center mt-4">
      <p><?= e(g('copyright_line','© Copyright')) ?>
        <strong class="px-1 sitename"><?= e(g('copyright_sitename','Mentor')) ?></strong>
        <span><?= e(g('copyright_tail','All Rights Reserved')) ?></span>
      </p>
      <div class="credits">
        <?= e(g('credit_designed_label','Designed by')) ?>
        <a href="<?= e(g('credit_designed_href','https://bootstrapmade.com/')) ?>"><?= e(g('credit_designed_name','BootstrapMade')) ?></a>
        <?= e(g('credit_separator',' ')) ?>
        <?= e(g('credit_distributed_label','Distributed by')) ?>
        <a href="<?= e(g('credit_distributed_href','https://themewagon.com/')) ?>"><?= e(g('credit_distributed_name','ThemeWagon')) ?></a>
      </div>
    </div>
  </footer>

  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Preloader -->
  <div id="preloader"></div>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>
  <script src="assets/vendor/aos/aos.js"></script>
  <script src="assets/vendor/glightbox/js/glightbox.min.js"></script>
  <script src="assets/vendor/purecounter/purecounter_vanilla.js"></script>
  <script src="assets/vendor/swiper/swiper-bundle.min.js"></script>

  <!-- Main JS File -->
  <script src="assets/js/main.js"></script>
</body>
</html>
