
<?php


require_once "core/db-connect91.php";




// Get today's date
$day = date('j');      // Day without leading zero
$month = date('n');    // Month without leading zero
$year = date('Y');     // Full year
$today = date('Y-m-d'); // For fee payment date

// 1. Total Students
$total_students = $conn->query("SELECT COUNT(*) AS total FROM students")->fetch_assoc()['total'];

// 2. Total Staff
$total_staff = $conn->query("SELECT COUNT(*) AS total FROM staff")->fetch_assoc()['total'];

// 3. Total Students Present Today
$total_students_present = $conn->query("
    SELECT COUNT(*) AS total 
    FROM student_attendance 
    WHERE day='$day' AND month='$month' AND year='$year' AND status='present'
")->fetch_assoc()['total'];

// 4. Total Staff Present Today
$total_staff_present = $conn->query("
    SELECT COUNT(*) AS total 
    FROM staff_attendance 
    WHERE day='$day' AND month='$month' AND year='$year' AND status='present'
")->fetch_assoc()['total'];

// 5. Total Staff Leave Requests (Pending/Approved)
$total_staff_leave_requests = $conn->query("
    SELECT COUNT(*) AS total 
    FROM staff_leaves 
    WHERE status IN ('pending','approved')
")->fetch_assoc()['total'];

// 6. Total Amount of Fees Deposited Today
$total_fees_today = $conn->query("
    SELECT IFNULL(SUM(paid_amount),0) AS total 
    FROM student_fees 
    WHERE payment_date='$today'
")->fetch_assoc()['total'];

// 7. Total Number of Student Complaints
$total_student_complaints = $conn->query("
    SELECT COUNT(*) AS total 
    FROM student_complaints
")->fetch_assoc()['total'];

// 8. Total Number of Staff Complaints
$total_staff_complaints = $conn->query("
    SELECT COUNT(*) AS total 
    FROM staff_complaints
")->fetch_assoc()['total'];


// Count total student leave requests (pending or approved)
$total_student_leave_requests = $conn->query("
    SELECT COUNT(*) AS total 
    FROM student_leaves 
    WHERE status IN ('pending','approved')
")->fetch_assoc()['total'];


// Today's day & month


$todayDay = date('d');
$todayMonth = date('m');

// Pagination setup
$limit = 4; // 5 students per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$offset = ($page - 1) * $limit;

// Count total students for pagination
$countResult = $conn->query("
    SELECT COUNT(*) AS total 
    FROM students
    WHERE DATE_FORMAT(STR_TO_DATE(student_birthdate,'%Y-%m-%d'), '%d') = '$todayDay'
      AND DATE_FORMAT(STR_TO_DATE(student_birthdate,'%Y-%m-%d'), '%m') = '$todayMonth'
");
$totalStudents = $countResult->fetch_assoc()['total'];
$totalPages = ceil($totalStudents / $limit);

// Fetch students for current page
$result = $conn->query("
    SELECT 
        student_image,
        student_name,
        student_fathername,
        student_surname,
        student_class,
        student_division,
        student_birthdate,
        TIMESTAMPDIFF(YEAR, STR_TO_DATE(student_birthdate,'%Y-%m-%d'), CURDATE()) AS age
    FROM students
    WHERE DATE_FORMAT(STR_TO_DATE(student_birthdate,'%Y-%m-%d'), '%d') = '$todayDay'
      AND DATE_FORMAT(STR_TO_DATE(student_birthdate,'%Y-%m-%d'), '%m') = '$todayMonth'
    ORDER BY student_name ASC
    LIMIT $limit OFFSET $offset
");

$students = [];
while ($row = $result->fetch_assoc()) {
    $students[] = $row;
}



// Pagination display
$startEntry = $offset + 1;
$endEntry = min($offset + $limit, $totalStudents);





?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
    <link rel="icon" type="image/png" href="images/favicon.png" />

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>
  <div class="col-span-12 lg:col-span-8">
    <div class="flex items-center justify-between space-x-2">
      <h2
        class="text-base font-medium tracking-wide text-slate-800 line-clamp-1 dark:text-navy-100"
      >
        Overview
      </h2>
      <div
        x-data="{activeTab:'tabRecent'}"
        class="is-scrollbar-hidden overflow-x-auto rounded-lg bg-slate-200 text-slate-600 dark:bg-navy-800 dark:text-navy-200"
      >

        <div class="tabs-list flex p-1">
          
<button
    id="btnSemester1"
    @click="activeTab = 'tabRecent'"
    :class="activeTab === 'tabRecent' ? 'bg-white shadow-sm dark:bg-navy-500 dark:text-navy-100' : 'hover:text-slate-800 focus:text-slate-800 dark:hover:text-navy-100 dark:focus:text-navy-100'"
    class="btn shrink-0 px-3 py-1 text-xs-plus font-medium"
>
    Semester 1
</button>
<button
    id="btnSemester2"
    @click="activeTab = 'tabAll'"
    :class="activeTab === 'tabAll' ? 'bg-white shadow-sm dark:bg-navy-500 dark:text-navy-100' : 'hover:text-slate-800 focus:text-slate-800 dark:hover:text-navy-100 dark:focus:text-navy-100'"
    class="btn shrink-0 px-3 py-1 text-xs-plus font-medium"
>
    Semester 2
</button>
        </div>
      </div>
    </div>

    <div class="flex flex-col sm:flex-row sm:space-x-7">
      <div
        class="mt-4 flex shrink-0 flex-col items-center sm:items-start"
      >
        <svg
          xmlns="http://www.w3.org/2000/svg"
          class="size-8 text-info"
          fill="none"
          viewBox="0 0 24 24"
          stroke="currentColor"
          stroke-width="1.5"
        >
          <path
            stroke-linecap="round"
            stroke-linejoin="round"
            d="M11 3.055A9.001 9.001 0 1020.945 13H11V3.055z"
          />
          <path
            stroke-linecap="round"
            stroke-linejoin="round"
            d="M20.488 9H15V3.512A9.025 9.025 0 0120.488 9z"
          />
        </svg>
        <div class="mt-4">
          <div class="flex items-center space-x-1">
            <p
              class="text-2xl font-semibold text-slate-700 dark:text-navy-100"
            >
            <?php echo '₹' . $total_fees_today; ?>
            </p>
            <button
              class="btn size-6 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
            >
              <svg
                xmlns="http://www.w3.org/2000/svg"
                class="size-4"
                fill="none"
                viewBox="0 0 24 24"
                stroke="currentColor"
                stroke-width="1.5"
              >
                <path
                  stroke-linecap="round"
                  stroke-linejoin="round"
                  d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"
                />
              </svg>
            </button>
          </div>
          <p class="text-xs text-slate-400 dark:text-navy-300">
Today
          </p>
        </div>

        <button
          class="btn mt-8 space-x-2 rounded-full border border-slate-300 px-3 text-xs-plus font-medium text-slate-700 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90"
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-4.5 text-slate-400 dark:text-navy-300"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="2"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M15 13l-3 3m0 0l-3-3m3 3V8m0 13a9 9 0 110-18 9 9 0 010 18z"
            />
          </svg>
          <span> Download Report</span>
        </button>
      </div>

      <div class="ax-transparent-gridline grid w-full grid-cols-1">

<?php

// Get semester from request (default Semester 1)
$semester = isset($_GET['semester']) ? $_GET['semester'] : '1';

$sql = "
    SELECT 
        c.class_name,
        SUM(CASE WHEN sf.payment_status='paid' THEN 1 ELSE 0 END) AS paid_count,
        SUM(CASE WHEN sf.payment_status IN ('unpaid','partially_paid') THEN 1 ELSE 0 END) AS unpaid_count
    FROM classes c
    LEFT JOIN student_fees sf 
        ON c.class_id = sf.class_id AND sf.semester = '$semester'
    GROUP BY c.class_name
    ORDER BY CAST(SUBSTRING_INDEX(c.class_name, ' ', -1) AS UNSIGNED)
";

$result = $conn->query($sql);

$classes = [];
$paid = [];
$unpaid = [];

while ($row = $result->fetch_assoc()) {
    $classes[] = $row['class_name']; // Now only Class 1, Class 2...
    $paid[] = (int)$row['paid_count'];
    $unpaid[] = (int)$row['unpaid_count'];
}

$conn->close();

// Convert to JSON for ApexCharts
$classes_json = json_encode($classes);
$paid_json = json_encode($paid);
$unpaid_json = json_encode($unpaid);
?>

<!-- Semester Filter -->

<div id="feesChart"></div>


<script>
// Initialize empty chart
var options = {
    chart: {
        type: 'bar',
        height: 400,
        toolbar: { show: false }
    },
    series: [
        { name: 'Paid Students', data: [] },
        { name: 'Unpaid/Partially Paid', data: [] }
    ],
    xaxis: { categories: [] },
    colors: ['#775DD0', '#00CFE8'],
    plotOptions: {
        bar: {
            horizontal: false,
            columnWidth: '45%',
            borderRadius: 10,
            endingShape: 'rounded'
        }
    },
    dataLabels: { enabled: false },
    grid: { borderColor: '#f1f1f1' },
    stroke: { show: true, width: 2, colors: ['transparent'] },
    legend: { position: 'top', horizontalAlign: 'right' },
    fill: {
        type: 'gradient',
        gradient: { shade: 'light', type: "vertical", shadeIntensity: 0.4, opacityFrom: 1, opacityTo: 1, stops: [0, 100] }
    }
};

var chart = new ApexCharts(document.querySelector("#feesChart"), options);
chart.render();

// Load chart data using POST
function loadChartData(semester) {
    $.ajax({
        url: 'supporting/fetch-semester-fee-data.php',
        type: 'POST',
        data: { semester: semester },
        dataType: 'json',
        success: function(data) {
            chart.updateOptions({
                xaxis: { categories: data.classes }
            });
            chart.updateSeries([
                { name: 'Paid Students', data: data.paid },
                { name: 'Unpaid/Partially Paid', data: data.unpaid }
            ]);
        }
    });
}

// Load Semester 1 by default
loadChartData(1);

// Button click events using IDs
$('#btnSemester1').on('click', function() {
    loadChartData(1);
});

$('#btnSemester2').on('click', function() {
    loadChartData(2);
});
</script>


<!-- Chart -->

      </div>
    </div>
  </div>
  <div class="col-span-12 lg:col-span-4">
    <div
      class="grid grid-cols-2 gap-3 sm:grid-cols-3 sm:gap-5 lg:grid-cols-2"
    >
      <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-700">
        <div class="flex justify-between space-x-1">
          <p
            class="text-xl font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $total_staff_present .' / '. $total_staff; ?>
          </p>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-5 text-primary dark:text-accent"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="2"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
            />
          </svg>
        </div>
        <p class="mt-1 text-xs-plus">Staff Attendance</p>
      </div>
      <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-700">
        <div class="flex justify-between">
          <p
            class="text-xl font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $total_students_present . '/' . $total_students; ?>
          </p>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-5 text-success"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="2"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"
            />
          </svg>
        </div>
        <p class="mt-1 text-xs-plus">Student Attendance</p>
      </div>
      <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-700">
        <div class="flex justify-between">
          <p
            class="text-xl font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $total_staff_leave_requests; ?>
          </p>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-5 text-warning"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="2"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"
            />
          </svg>
        </div>
        <p class="mt-1 text-xs-plus">Staff Leave Request</p>
      </div>
      <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-700">
        <div class="flex justify-between">
          <p
            class="text-xl font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $total_student_leave_requests; ?>
          </p>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-5 text-info"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="2"
          >
            <path
              d="M9 17a2 2 0 11-4 0 2 2 0 014 0zM19 17a2 2 0 11-4 0 2 2 0 014 0z"
            />
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M13 16V6a1 1 0 00-1-1H4a1 1 0 00-1 1v10a1 1 0 001 1h1m8-1a1 1 0 01-1 1H9m4-1V8a1 1 0 011-1h2.586a1 1 0 01.707.293l3.414 3.414a1 1 0 01.293.707V16a1 1 0 01-1 1h-1m-6-1a1 1 0 001 1h1M5 17a2 2 0 104 0m-4 0a2 2 0 114 0m6 0a2 2 0 104 0m-4 0a2 2 0 114 0"
            />
          </svg>
        </div>
        <p class="mt-1 text-xs-plus"> Student Leave Request</p>
      </div>
      <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-700">
        <div class="flex justify-between space-x-1">
          <p
            class="text-xl font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $total_staff_complaints; ?>
          </p>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-5 text-secondary"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="2"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"
            />
          </svg>
        </div>
         <p class="mt-1 text-xs-plus">Staff Complaint</p>       

      </div>
      <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-700">
        <div class="flex justify-between">
          <p
            class="text-xl font-semibold text-slate-700 dark:text-navy-100"
          >
<?php echo $total_student_complaints; ?>
          </p>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="size-5 text-error"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            stroke-width="2"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"
            />
          </svg>
        </div>
        <p class="mt-1 text-xs-plus">Student Complaint</p>
      </div>
    </div>
  
  


  
  
  
  
  
  
  
<div class="card px-4 pb-4 mt-6 sm:px-5">
  <div class="my-3 flex h-8 items-center justify-between">
    <h2 class="text-sm-plus font-medium tracking-wide text-slate-700 line-clamp-1 dark:text-navy-100">
      Today's Birthdays 🎉
    </h2>
    <div
      x-data="usePopper({placement:'bottom-end',offset:4})"
      @click.outside="isShowPopper && (isShowPopper = false)"
      class="inline-flex"
    >
      <button
        x-ref="popperRef"
        @click="isShowPopper = !isShowPopper"
        class="btn -mr-1.5 size-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
      >
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M5 12h.01M12 12h.01M19 12h.01" />
        </svg>
      </button>
      <div x-ref="popperRoot" class="popper-root" :class="isShowPopper && 'show'">
        <div class="popper-box rounded-md border border-slate-150 bg-white py-1.5 font-inter dark:border-navy-500 dark:bg-navy-700">
          <ul>
            <li><a href="#" class="flex h-8 items-center px-3 pr-8 font-medium hover:bg-slate-100 dark:hover:bg-navy-600">Action</a></li>
            <li><a href="#" class="flex h-8 items-center px-3 pr-8 font-medium hover:bg-slate-100 dark:hover:bg-navy-600">Another Action</a></li>
          </ul>
        </div>
      </div>
    </div>
  </div>

  <div class="grid grid-cols-2 gap-3 md:grid-cols-3 lg:grid-cols-4">
    <?php if(!empty($students)): ?>
      <?php foreach($students as $student): ?>
        <div class="relative flex flex-col items-center justify-center rounded-lg border border-slate-200 p-4 dark:border-navy-500">
          <div class="avatar size-12">
            <img class="mask is-hexagon" src="<?= $student['student_image'] ?>" alt="avatar">
          </div>
          <p class="mt-1.5 font-medium text-slate-700 line-clamp-1 dark:text-navy-100">
            <?= $student['student_name'] . " " . $student['student_surname'] ?>
          </p>
          
<button
  class="btn mt-3 h-6 rounded-full bg-slate-150 px-3 text-xs font-medium text-slate-800 hover:bg-slate-200 focus:bg-slate-200 active:bg-slate-200/80 dark:bg-navy-500 dark:text-navy-50 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90"
>
<p class="text-xs text-slate-500 dark:text-navy-200">
  <?= $student['student_class'] . " - " . $student['student_division'] ?>
</p>
</button>

          
          
          <span class="mt-2 text-xs font-medium text-slate-600 dark:text-navy-100">
            Age: <?= $student['age'] ?>
          </span>
        </div>
      <?php endforeach; ?>
    <?php else: ?>
      <div class="col-span-full text-center text-slate-500 py-5">
        No birthdays today 🎉
      </div>
    <?php endif; ?>
  </div>
<div
  style="overflow:auto;"
  class="flex flex-col justify-between space-y-4 px-4 py-4 sm:flex-row sm:items-center sm:space-y-0 sm:px-5"
>
  <div class="text-xs-plus">
    <?= $totalStudents ? "$startEntry - $endEntry of $totalStudents entries" : "No entries"; ?>
  </div>
  <ol class="pagination space-x-1.5">
    <!-- Previous button -->
    <li>
      <a href="?page=<?= max(1, $page-1) ?>"
        class="flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 transition-colors hover:bg-slate-300">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/>
        </svg>
      </a>
    </li>
    
    <!-- Page numbers -->
    <?php for($i=1; $i<=$totalPages; $i++): ?>
      <li>
        <a href="?page=<?= $i ?>"
          class="flex h-8 min-w-[2rem] items-center justify-center rounded-full px-3 leading-tight 
          <?= $i==$page ? 'bg-primary text-white' : 'bg-slate-150 hover:bg-slate-300' ?>">
          <?= $i ?>
        </a>
      </li>
    <?php endfor; ?>

    <!-- Next button -->
    <li>
      <a href="?page=<?= min($totalPages, $page+1) ?>"
        class="flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 transition-colors hover:bg-slate-300">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"/>
        </svg>
      </a>
    </li>
  </ol>
</div>
  
  
  
</div>
  
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>



     <th class="bg-slate-200 px-4 py-3 font-semibold uppercase">Class & Division</th>
      <th class="bg-slate-200 px-4 py-3 font-semibold uppercase">Age</th>
    </tr>
  </thead>
  <tbody>
    <?php if(!empty($students)): ?>
        <?php foreach($students as $student): ?>
        <tr class="border-b border-slate-200">
            <td class="px-4 py-3">
                <img src="<?= $student['student_image'] ?>" alt="Profile" class="size-10 mask is-squircle">
            </td>
            <td class="px-4 py-3 font-medium text-slate-700">
                <?= $student['student_name'] . " " . $student['student_fathername'] . " " . $student['student_surname'] ?>
            </td>
            <td class="px-4 py-3">
                <?= $student['student_class'] . " - " . $student['student_division'] ?>
            </td>
            <td class="px-4 py-3">
                <?= $student['age'] ?>
            </td>
        </tr>
        <?php endforeach; ?>
    <?php else: ?>
        <tr>
            <td colspan="4" class="text-center py-3 text-slate-500">No birthdays today 🎉</td>
        </tr>
    <?php endif; ?>
  </tbody>
</table>
    </div>


<div
  style="overflow:auto;"
  class="flex flex-col justify-between space-y-4 px-4 py-4 sm:flex-row sm:items-center sm:space-y-0 sm:px-5"
>
  <div class="text-xs-plus">
    <?= $totalStudents ? "$startEntry - $endEntry of $totalStudents entries" : "No entries"; ?>
  </div>
  <ol class="pagination space-x-1.5">
    <!-- Previous button -->
    <li>
      <a href="?page=<?= max(1, $page-1) ?>"
        class="flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 transition-colors hover:bg-slate-300">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/>
        </svg>
      </a>
    </li>
    
    <!-- Page numbers -->9
    <?php for($i=1; $i<=$totalPages; $i++): ?>
      <li>
        <a href="?page=<?= $i ?>"
          class="flex h-8 min-w-[2rem] items-center justify-center rounded-full px-3 leading-tight 
          <?= $i==$page ? 'bg-primary text-white' : 'bg-slate-150 hover:bg-slate-300' ?>">
          <?= $i ?>
        </a>
      </li>
    <?php endfor; ?>

    <!-- Next button -->
    <li>
      <a href="?page=<?= min($totalPages, $page+1) ?>"
        class="flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 transition-colors hover:bg-slate-300">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"/>
        </svg>
      </a>
    </li>
  </ol>
</div>
  </div>
</div>
  
  
  
  
  
  
  
  
  
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>



