
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

  
<div class="col-span-12 grid lg:col-span-8 mb-6">
    <div class="card">
        <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
            <div class="flex items-center space-x-2">
                <div class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary dark:bg-accent-light/10 dark:text-accent-light">
                    <i class="fa-solid fa-layer-group"></i>
                </div>
                <h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">
                    Leave Request
                </h4>
            </div>
        </div>
        <div class="space-y-4 p-4 sm:p-5">

<form method="POST" enctype="multipart/form-data">

    <!-- From Date -->
    <label class="relative flex">
        <input
            name="leave_date_from"
            x-init="$el._x_flatpickr = flatpickr($el, {dateFormat:'Y-m-d'})"
            class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 
                   placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary 
                   dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
            placeholder="Leave Date"
            type="text"
            required
        />
        <span
            class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
        >
            <svg xmlns="http://www.w3.org/2000/svg"
                class="size-5 transition-colors duration-200"
                fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                <path stroke-linecap="round" stroke-linejoin="round"
                    d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
            </svg>
        </span>
    </label>

    <!-- Leave Type -->
    <label class="block mt-3">
        <span>Leave Type</span>
        <select name="leave_type"
            class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2">
            <option value="sick">Sick</option>
            <option value="personal">Personal</option>
            <option value="emergency">Emergency</option>
            <option value="other" selected>Other</option>
        </select>
    </label>

    <!-- Reason -->
    <label class="block mt-3">
        <span>Reason</span>
        <textarea name="reason"
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
            rows="3" required></textarea>
    </label>

    <button type="submit" name="apply_leave"
        class="mt-5 btn bg-primary text-white">
        Apply Leave
    </button>
</form>

        </div>
    </div>
</div>

<?php
if (isset($_POST['apply_leave'])) {
    $student_id = $_SESSION['student_id'] ?? 0;
    $student_gr_no = $_SESSION['student_gr_no'] ?? ''; // Make sure you store this in session at login

    $leave_date = $_POST['leave_date_from'];
    $leave_type = $_POST['leave_type'];
    $reason = $_POST['reason'];

    $sql = "INSERT INTO student_leaves (student_id, student_gr_no, leave_date, leave_type, reason, status, applied_at) 
            VALUES (?, ?, ?, ?, ?, 'pending', NOW())";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("issss", $student_id, $student_gr_no, $leave_date, $leave_type, $reason);

    if ($stmt->execute()) {
        echo "<script>alert('Leave application submitted successfully!');</script>";
    } else {
        echo "Error: " . $stmt->error;
    }
}
?>
  
  
  
  
  
<?php
// Get current student_id from session
$student_id = $_SESSION['student_id'] ?? 0;

$sql = "
  SELECT
    sl.leave_id,
    sl.student_id,
    sl.student_gr_no,
    sl.leave_date,
    sl.leave_type,
    sl.reason,
    sl.status AS leave_status,
    sl.applied_at,
    s.student_name,
    s.student_surname,
    s.student_fathername,
    s.student_image,
    s.class,
    s.division
  FROM student_leaves AS sl
  JOIN students AS s ON sl.student_id = s.student_id
  WHERE sl.student_id = $student_id
  ORDER BY sl.applied_at DESC
";

$result = $conn->query($sql);
?>

<div>
  <div class="flex items-center justify-between">
    <!-- … header/search … -->
  </div>

  <div class="card mt-3">
    <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
      <table class="is-hoverable w-full text-left">
        <thead>
          <tr>
            <th class="whitespace-nowrap rounded-tl-lg bg-slate-200 px-4 py-3 font-semibold uppercase">#</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Avatar</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Name</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Father Name</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">GR No</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Class</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Division</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Leave Type</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Leave Date</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Applied At</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Status</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($result && $result->num_rows): ?>
            <?php $i = 1; while($row = $result->fetch_assoc()): ?>
              <?php
              $status = strtolower(trim($row['leave_status']));
              $statusClass = '';
              if ($status === 'approved') $statusClass = 'bg-green-100 text-green-700 border border-green-400 px-3 py-1 rounded-full text-sm font-medium';
              elseif ($status === 'rejected') $statusClass = 'bg-red-100 text-red-700 border border-red-400 px-3 py-1 rounded-full text-sm font-medium';
              elseif ($status === 'pending') $statusClass = 'bg-yellow-100 text-yellow-700 border border-yellow-400 px-3 py-1 rounded-full text-sm font-medium';
              else $statusClass = 'bg-gray-100 text-gray-700 border border-gray-400 px-3 py-1 rounded-full text-sm font-medium';
              ?>
              <tr class="border-y border-transparent border-b-slate-200">
                <td class="px-4 py-3"><?= $i++ ?></td>
                <td class="px-4 py-3">
                  <div class="avatar flex size-10">
                    <img class="mask is-squircle"
                         src="<?= htmlspecialchars($row['student_image']) ?>"
                         alt="avatar" />
                  </div>
                </td>
                <td class="px-3 py-3 font-medium"><?= htmlspecialchars($row['student_name'] . ' ' . $row['student_surname']) ?></td>
                <td class="px-4 py-3"><?= htmlspecialchars($row['student_fathername']) ?></td>
                <td class="px-4 py-3"><?= htmlspecialchars($row['student_gr_no']) ?></td>
                <td class="px-4 py-3"><?= htmlspecialchars($row['class']) ?></td>
                <td class="px-4 py-3"><?= htmlspecialchars($row['division']) ?></td>
                <td class="px-4 py-3"><?= htmlspecialchars($row['leave_type']) ?></td>
                <td class="px-4 py-3"><?= htmlspecialchars($row['leave_date']) ?></td>
                <td class="px-4 py-3"><?= date('d M, Y', strtotime($row['applied_at'])) ?></td>
                <td class="px-4 py-3"><span class="<?= $statusClass; ?>"><?= ucfirst($status) ?></span></td>
              </tr>
            <?php endwhile; else: ?>
              <tr><td colspan="11" class="text-center py-4">No student leave requests found.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>