
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

  
  


  
  
  <?php

  
  // Get student id: prefer session, fallback to GET
  $student_id = $_SESSION['student_id'] ?? ($_GET['student_id'] ?? null);
  if (!$student_id) {
  echo "Student ID not provided.";
  exit;
  }
  
  /* 1) Get student's class and division */
  $sql = "SELECT student_class, student_division FROM students WHERE student_id = ?";
  $stmt = mysqli_prepare($conn, $sql);
  mysqli_stmt_bind_param($stmt, 'i', $student_id);
  mysqli_stmt_execute($stmt);
  $res = mysqli_stmt_get_result($stmt);
  $student = mysqli_fetch_assoc($res);
  mysqli_stmt_close($stmt);
  
  if (!$student) {
  echo "Student not found.";
  exit;
  }
  
  $student_class = $student['student_class'];
  $student_division = $student['student_division'];
  
  /* 2) Resolve class_id from classes table (matching class_name + division) */
  $sql = "SELECT class_id FROM classes WHERE class_name = ? AND division = ? LIMIT 1";
  $stmt = mysqli_prepare($conn, $sql);
  mysqli_stmt_bind_param($stmt, 'ss', $student_class, $student_division);
  mysqli_stmt_execute($stmt);
  $res = mysqli_stmt_get_result($stmt);
  $classRow = mysqli_fetch_assoc($res);
  mysqli_stmt_close($stmt);
  
  if (!$classRow) {
  echo "Class not found for {$student_class} - Division: {$student_division}";
  exit;
  }
  $class_id = $classRow['class_id'];
  
  /* 3) Get exam list for this class */
  $sql = "SELECT exam_id, exam_name, start_date, end_date, batch FROM exam_schedule WHERE class_id = ? ORDER BY start_date DESC";
  $stmt = mysqli_prepare($conn, $sql);
  mysqli_stmt_bind_param($stmt, 'i', $class_id);
  mysqli_stmt_execute($stmt);
  $result = mysqli_stmt_get_result($stmt);
  
  $exams = [];
  while ($row = mysqli_fetch_assoc($result)) {
  $exams[] = $row;
  }
  mysqli_stmt_close($stmt);
  
  /* 4) For each exam check if result published (exam_results table) */
  /* Logic:
  - Try to fetch a row from exam_results WHERE exam_id = ?
  - If that row has a 'published' column -> use it
  - Else if any row exists for that exam_id -> consider published
  - Also try to grab a session_id if present
  */
function examIsPublished($conn, $exam_id, $student_id) {
    $sql = "SELECT 1 FROM exam_results WHERE exam_id = ? AND student_id = ? LIMIT 1";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, 'ii', $exam_id, $student_id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_store_result($stmt);
    
    $published = mysqli_stmt_num_rows($stmt) > 0;
    mysqli_stmt_close($stmt);

    return ['published' => $published];
}
  
  ?>


<h1 class="text-lg font-semibold mb-4">
    Exams for Class: <?= htmlspecialchars($student_class) ?> - Division: <?= htmlspecialchars($student_division) ?>
</h1>

<?php if (empty($exams)): ?>
    <p>No exams scheduled for this class.</p>
<?php else: ?>
<div class="card px-4 pb-4 sm:px-5">
    <div class="my-3 flex h-8 items-center justify-between">
        <h2 class="font-medium tracking-wide text-slate-700 line-clamp-1 dark:text-navy-100 lg:text-base">
            Exam List
        </h2>
    </div>

    <div class="mt-5">
        <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
            <table class="is-zebra w-full text-left border border-slate-300 dark:border-navy-500">
                <thead>
                    <tr>
                        <th class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase 
                                   text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5 border border-slate-300">
                            #
                        </th>
                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase 
                                   text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5 border border-slate-300">
                            Exam
                        </th>
                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase 
                                   text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5 border border-slate-300">
                            Batch/Session
                        </th>
                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase 
                                   text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5 border border-slate-300">
                            Start
                        </th>
                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase 
                                   text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5 border border-slate-300">
                            End
                        </th>
                        <th class="whitespace-nowrap rounded-r-lg bg-slate-200 px-4 py-3 font-semibold uppercase 
                                   text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5 border border-slate-300">
                            Result
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $count = 1; ?>
                    <?php foreach ($exams as $exam): 
                        $check = examIsPublished($conn, $exam['exam_id'], $student_id);
                        $published = $check['published'];
                        $session_id = $check['session_id'];
                    ?>
                    <tr>
                        <td class="whitespace-nowrap rounded-l-lg px-4 py-3 sm:px-5 border border-slate-300">
                            <?= $count++ ?>
                        </td>
                        <td class="whitespace-nowrap px-4 py-3 sm:px-5 border border-slate-300">
                            <?= htmlspecialchars($exam['exam_name']) ?>
                        </td>
                        <td class="whitespace-nowrap px-4 py-3 sm:px-5 border border-slate-300">
                            <?= htmlspecialchars($exam['batch'] ?? '-') ?>
                        </td>
                        <td class="whitespace-nowrap px-4 py-3 sm:px-5 border border-slate-300">
                            <?= htmlspecialchars($exam['start_date']) ?>
                        </td>
                        <td class="whitespace-nowrap px-4 py-3 sm:px-5 border border-slate-300">
                            <?= htmlspecialchars($exam['end_date']) ?>
                        </td>
<td class="whitespace-nowrap rounded-r-lg px-4 py-3 sm:px-5 border border-slate-300">
    <?php if ($published): ?>
        <form method="POST" action="staff-view-student-scorecard-main.php" class="inline">
            <input type="hidden" name="exam_id" value="<?= htmlspecialchars($exam['exam_id']) ?>">
            <?php if ($session_id): ?>
                <input type="hidden" name="session_id" value="<?= htmlspecialchars($session_id) ?>">
            <?php endif; ?>
            <input type="hidden" name="student_id" value="<?= htmlspecialchars($student_id) ?>">
            <button type="submit" class="btn bg-primary text-white px-3 py-1 rounded">View Result</button>
        </form>
    <?php else: ?>
        <span class="px-3 py-1 rounded bg-gray-300 dark:bg-gray-600 text-gray-700 dark:text-gray-300">Not Published</span>
    <?php endif; ?>
</td>
                    
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php endif; ?>
  

  
  

  
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>